/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.interpolation;

import org.apache.commons.math4.analysis.interpolation.UnivariateInterpolator;
import org.apache.commons.math4.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math4.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.NonMonotonicSequenceException;
import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.MathArrays;

public class SplineInterpolator
implements UnivariateInterpolator {
    @Override
    public PolynomialSplineFunction interpolate(double[] x, double[] y) throws DimensionMismatchException, NumberIsTooSmallException, NonMonotonicSequenceException {
        if (x.length != y.length) {
            throw new DimensionMismatchException(x.length, y.length);
        }
        if (x.length < 3) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.NUMBER_OF_POINTS, (Number)x.length, 3, true);
        }
        int n = x.length - 1;
        MathArrays.checkOrder(x);
        double[] h = new double[n];
        for (int i = 0; i < n; ++i) {
            h[i] = x[i + 1] - x[i];
        }
        double[] mu = new double[n];
        double[] z = new double[n + 1];
        double g = 0.0;
        int indexM1 = 0;
        int index = 1;
        int indexP1 = 2;
        while (index < n) {
            double xIp1 = x[indexP1];
            double xIm1 = x[indexM1];
            double hIm1 = h[indexM1];
            double hI = h[index];
            g = 2.0 * (xIp1 - xIm1) - hIm1 * mu[indexM1];
            mu[index] = hI / g;
            z[index] = (3.0 * (y[indexP1] * hIm1 - y[index] * (xIp1 - xIm1) + y[indexM1] * hI) / (hIm1 * hI) - hIm1 * z[indexM1]) / g;
            indexM1 = index;
            index = indexP1++;
        }
        double[] b = new double[n];
        double[] c = new double[n + 1];
        double[] d = new double[n];
        for (int j = n - 1; j >= 0; --j) {
            double cJp1 = c[j + 1];
            double cJ = z[j] - mu[j] * cJp1;
            double hJ = h[j];
            b[j] = (y[j + 1] - y[j]) / hJ - hJ * (cJp1 + 2.0 * cJ) / 3.0;
            c[j] = cJ;
            d[j] = (cJp1 - cJ) / (3.0 * hJ);
        }
        PolynomialFunction[] polynomials = new PolynomialFunction[n];
        double[] coefficients = new double[4];
        for (int i = 0; i < n; ++i) {
            coefficients[0] = y[i];
            coefficients[1] = b[i];
            coefficients[2] = c[i];
            coefficients[3] = d[i];
            polynomials[i] = new PolynomialFunction(coefficients);
        }
        return new PolynomialSplineFunction(x, polynomials);
    }
}

