/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.solvers;

import org.apache.commons.math4.analysis.solvers.AbstractUnivariateSolver;

public class BrentSolver
extends AbstractUnivariateSolver {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    public BrentSolver() {
        this(1.0E-6);
    }

    public BrentSolver(double absoluteAccuracy) {
        super(absoluteAccuracy);
    }

    public BrentSolver(double relativeAccuracy, double absoluteAccuracy) {
        super(relativeAccuracy, absoluteAccuracy);
    }

    public BrentSolver(double relativeAccuracy, double absoluteAccuracy, double functionValueAccuracy) {
        super(relativeAccuracy, absoluteAccuracy, functionValueAccuracy);
    }

    @Override
    protected double doSolve() {
        double min = this.getMin();
        double max = this.getMax();
        double initial = this.getStartValue();
        org.apache.commons.numbers.rootfinder.BrentSolver rf = new org.apache.commons.numbers.rootfinder.BrentSolver(this.getRelativeAccuracy(), this.getAbsoluteAccuracy(), this.getFunctionValueAccuracy());
        double root = Double.NaN;
        try {
            root = rf.findRoot(arg -> this.computeObjectiveValue(arg), min, initial, max);
        }
        catch (IllegalArgumentException e) {
            this.verifySequence(min, initial, max);
            this.verifyBracketing(min, max);
        }
        return root;
    }
}

