/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.ode.nonstiff;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math4.field.linalg.FieldDecompositionSolver;
import org.apache.commons.math4.field.linalg.FieldDenseMatrix;
import org.apache.commons.math4.field.linalg.FieldLUDecomposition;
import org.apache.commons.math4.linear.Array2DRowRealMatrix;
import org.apache.commons.math4.linear.QRDecomposition;
import org.apache.commons.math4.linear.RealMatrix;
import org.apache.commons.numbers.field.BigFractionField;
import org.apache.commons.numbers.fraction.BigFraction;

public class AdamsNordsieckTransformer {
    private static final Map<Integer, AdamsNordsieckTransformer> CACHE = new HashMap<Integer, AdamsNordsieckTransformer>();
    private final Array2DRowRealMatrix update;
    private final double[] c1;

    private AdamsNordsieckTransformer(int n) {
        int i;
        int dim = n - 1;
        FieldDenseMatrix<BigFraction> bigP = this.buildP(dim);
        FieldDecompositionSolver<BigFraction> pSolver = FieldLUDecomposition.of(bigP).getSolver();
        FieldDenseMatrix<BigFraction> u = FieldDenseMatrix.create(BigFractionField.get(), dim, 1).fill(BigFraction.ONE);
        FieldDenseMatrix<BigFraction> bigC1 = pSolver.solve(u);
        FieldDenseMatrix<BigFraction> shiftedP = bigP.copy();
        for (int i2 = dim - 1; i2 > 0; --i2) {
            for (int j = 0; j < dim; ++j) {
                shiftedP.set(i2, j, shiftedP.get(i2 - 1, j));
            }
        }
        for (int j = 0; j < dim; ++j) {
            shiftedP.set(0, j, BigFraction.ZERO);
        }
        FieldDenseMatrix<BigFraction> bigMSupdate = pSolver.solve(shiftedP);
        double[][] updateData = new double[dim][dim];
        for (i = 0; i < dim; ++i) {
            for (int j = 0; j < dim; ++j) {
                updateData[i][j] = bigMSupdate.get(i, j).doubleValue();
            }
        }
        this.update = new Array2DRowRealMatrix(updateData, false);
        this.c1 = new double[dim];
        for (i = 0; i < dim; ++i) {
            this.c1[i] = bigC1.get(i, 0).doubleValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdamsNordsieckTransformer getInstance(int nSteps) {
        Map<Integer, AdamsNordsieckTransformer> map = CACHE;
        synchronized (map) {
            AdamsNordsieckTransformer t = CACHE.get(nSteps);
            if (t == null) {
                t = new AdamsNordsieckTransformer(nSteps);
                CACHE.put(nSteps, t);
            }
            return t;
        }
    }

    @Deprecated
    public int getNSteps() {
        return this.c1.length;
    }

    private FieldDenseMatrix<BigFraction> buildP(int rows) {
        FieldDenseMatrix<BigFraction> pData = FieldDenseMatrix.create(BigFractionField.get(), rows, rows).fill(BigFraction.ZERO);
        for (int i = 1; i <= rows; ++i) {
            int factor;
            int aj = factor = -i;
            for (int j = 1; j <= rows; ++j) {
                pData.set(i - 1, j - 1, BigFraction.of((int)(aj * (j + 1))));
                aj *= factor;
            }
        }
        return pData;
    }

    public Array2DRowRealMatrix initializeHighOrderDerivatives(double h, double[] t, double[][] y, double[][] yDot) {
        double[][] a = new double[this.c1.length + 1][this.c1.length + 1];
        double[][] b = new double[this.c1.length + 1][y[0].length];
        double[] y0 = y[0];
        double[] yDot0 = yDot[0];
        for (int i = 1; i < y.length; ++i) {
            double di = t[i] - t[0];
            double ratio = di / h;
            double dikM1Ohk = 1.0 / h;
            double[] aI = a[2 * i - 2];
            double[] aDotI = 2 * i - 1 < a.length ? a[2 * i - 1] : null;
            for (int j = 0; j < aI.length; ++j) {
                aI[j] = di * (dikM1Ohk *= ratio);
                if (aDotI == null) continue;
                aDotI[j] = (double)(j + 2) * dikM1Ohk;
            }
            double[] yI = y[i];
            double[] yDotI = yDot[i];
            double[] bI = b[2 * i - 2];
            double[] bDotI = 2 * i - 1 < b.length ? b[2 * i - 1] : null;
            for (int j = 0; j < yI.length; ++j) {
                bI[j] = yI[j] - y0[j] - di * yDot0[j];
                if (bDotI == null) continue;
                bDotI[j] = yDotI[j] - yDot0[j];
            }
        }
        QRDecomposition decomposition = new QRDecomposition(new Array2DRowRealMatrix(a, false));
        RealMatrix x = decomposition.getSolver().solve(new Array2DRowRealMatrix(b, false));
        Array2DRowRealMatrix truncatedX = new Array2DRowRealMatrix(x.getRowDimension() - 1, x.getColumnDimension());
        for (int i = 0; i < truncatedX.getRowDimension(); ++i) {
            for (int j = 0; j < truncatedX.getColumnDimension(); ++j) {
                truncatedX.setEntry(i, j, x.getEntry(i, j));
            }
        }
        return truncatedX;
    }

    public Array2DRowRealMatrix updateHighOrderDerivativesPhase1(Array2DRowRealMatrix highOrder) {
        return this.update.multiply(highOrder);
    }

    public void updateHighOrderDerivativesPhase2(double[] start, double[] end, Array2DRowRealMatrix highOrder) {
        double[][] data = highOrder.getDataRef();
        for (int i = 0; i < data.length; ++i) {
            double[] dataI = data[i];
            double c1I = this.c1[i];
            for (int j = 0; j < dataI.length; ++j) {
                int n = j;
                dataI[n] = dataI[n] + c1I * (start[j] - end[j]);
            }
        }
    }
}

