/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.random;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.math4.random.RandomGenerator;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.rng.RandomProviderState;
import org.apache.commons.rng.RestorableUniformRandomProvider;
import org.apache.commons.rng.core.RandomProviderDefaultState;
import org.apache.commons.rng.simple.RandomSource;

@Deprecated
public final class RngAdaptor
implements RandomGenerator,
Serializable {
    private static final long serialVersionUID = 12345L;
    private final RandomSource source;
    private transient RestorableUniformRandomProvider delegate;
    private double nextGaussian = Double.NaN;

    public RngAdaptor(RandomSource source) {
        this(source, null);
    }

    public RngAdaptor(RandomSource source, Object seed) {
        this.source = source;
        this.delegate = RandomSource.create((RandomSource)source, (Object)seed, (Object[])new Object[0]);
    }

    @Override
    public void setSeed(int seed) {
        this.delegate = RandomSource.create((RandomSource)this.source, (Object)seed, (Object[])new Object[0]);
        this.clear();
    }

    @Override
    public void setSeed(int[] seed) {
        this.delegate = RandomSource.create((RandomSource)this.source, (Object)seed, (Object[])new Object[0]);
        this.clear();
    }

    @Override
    public void setSeed(long seed) {
        this.delegate = RandomSource.create((RandomSource)this.source, (Object)seed, (Object[])new Object[0]);
        this.clear();
    }

    @Override
    public boolean nextBoolean() {
        return this.delegate.nextBoolean();
    }

    @Override
    public void nextBytes(byte[] bytes) {
        this.delegate.nextBytes(bytes);
    }

    @Override
    public double nextDouble() {
        return this.delegate.nextDouble();
    }

    @Override
    public float nextFloat() {
        return this.delegate.nextFloat();
    }

    @Override
    public double nextGaussian() {
        double random;
        if (Double.isNaN(this.nextGaussian)) {
            double x = this.nextDouble();
            double y = this.nextDouble();
            double alpha = Math.PI * 2 * x;
            double r = FastMath.sqrt(-2.0 * FastMath.log(y));
            random = r * FastMath.cos(alpha);
            this.nextGaussian = r * FastMath.sin(alpha);
        } else {
            random = this.nextGaussian;
            this.nextGaussian = Double.NaN;
        }
        return random;
    }

    @Override
    public int nextInt() {
        return this.delegate.nextInt();
    }

    @Override
    public int nextInt(int n) {
        return this.delegate.nextInt(n);
    }

    @Override
    public long nextLong() {
        return this.delegate.nextLong();
    }

    private void clear() {
        this.nextGaussian = Double.NaN;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(((RandomProviderDefaultState)this.delegate.saveState()).getState());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.delegate = RandomSource.create((RandomSource)this.source);
        RandomProviderDefaultState state = new RandomProviderDefaultState((byte[])in.readObject());
        this.delegate.restoreState((RandomProviderState)state);
    }
}

