/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.stat.descriptive.summary;

import java.io.Serializable;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.math4.util.MathUtils;

public class SumOfLogs
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 20150412L;
    private int n;
    private double value;

    public SumOfLogs() {
        this.value = 0.0;
        this.n = 0;
    }

    public SumOfLogs(SumOfLogs original) throws NullArgumentException {
        SumOfLogs.copy(original, this);
    }

    @Override
    public void increment(double d) {
        this.value += FastMath.log(d);
        ++this.n;
    }

    @Override
    public double getResult() {
        return this.value;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public void clear() {
        this.value = 0.0;
        this.n = 0;
    }

    @Override
    public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
        double sumLog = Double.NaN;
        if (MathArrays.verifyValues(values, begin, length, true)) {
            sumLog = 0.0;
            for (int i = begin; i < begin + length; ++i) {
                sumLog += FastMath.log(values[i]);
            }
        }
        return sumLog;
    }

    @Override
    public SumOfLogs copy() {
        SumOfLogs result = new SumOfLogs();
        SumOfLogs.copy(this, result);
        return result;
    }

    public static void copy(SumOfLogs source, SumOfLogs dest) throws NullArgumentException {
        MathUtils.checkNotNull(source);
        MathUtils.checkNotNull(dest);
        dest.n = source.n;
        dest.value = source.value;
    }
}

