/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.util;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.math4.exception.MathArithmeticException;
import org.apache.commons.math4.exception.NotPositiveException;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.numbers.combinatorics.BinomialCoefficient;
import org.apache.commons.numbers.combinatorics.Factorial;
import org.apache.commons.numbers.core.ArithmeticUtils;

public final class CombinatoricsUtils {
    static final AtomicReference<long[][]> STIRLING_S2 = new AtomicReference<Object>(null);

    private CombinatoricsUtils() {
    }

    public static long stirlingS2(int n, int k) throws NotPositiveException, NumberIsTooLargeException, MathArithmeticException {
        if (k < 0) {
            throw new NotPositiveException(k);
        }
        if (k > n) {
            throw new NumberIsTooLargeException(k, (Number)n, true);
        }
        Object stirlingS2 = STIRLING_S2.get();
        if (stirlingS2 == null) {
            int maxIndex = 26;
            stirlingS2 = new long[26][];
            stirlingS2[0] = new long[]{1L};
            for (int i = 1; i < ((long[][])stirlingS2).length; ++i) {
                stirlingS2[i] = new long[i + 1];
                stirlingS2[i][0] = 0L;
                stirlingS2[i][1] = 1L;
                stirlingS2[i][i] = 1L;
                for (int j = 2; j < i; ++j) {
                    stirlingS2[i][j] = (long)j * stirlingS2[i - 1][j] + stirlingS2[i - 1][j - 1];
                }
            }
            STIRLING_S2.compareAndSet((long[][])null, (long[][])stirlingS2);
        }
        if (n < ((long[][])stirlingS2).length) {
            return stirlingS2[n][k];
        }
        if (k == 0) {
            return 0L;
        }
        if (k == 1 || k == n) {
            return 1L;
        }
        if (k == 2) {
            return (1L << n - 1) - 1L;
        }
        if (k == n - 1) {
            return BinomialCoefficient.value((int)n, (int)2);
        }
        long sum = 0L;
        long sign = (k & 1) == 0 ? 1L : -1L;
        for (int j = 1; j <= k; ++j) {
            if ((sum += (sign = -sign) * BinomialCoefficient.value((int)k, (int)j) * (long)ArithmeticUtils.pow((int)j, (int)n)) >= 0L) continue;
            throw new MathArithmeticException(LocalizedFormats.ARGUMENT_OUTSIDE_DOMAIN, n, 0, ((long[][])stirlingS2).length - 1);
        }
        return sum / Factorial.value((int)k);
    }
}

