/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class PluginTransformer
implements ResourceTransformer {
    public static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    String resource;
    Document doc;

    public boolean canTransformResource(String r) {
        r = r.toLowerCase();
        return this.resource != null && this.resource.toLowerCase().equals(r);
    }

    public void processResource(String resource, InputStream is, List relocators) throws IOException {
        this.processResource(is);
    }

    public void processResource(InputStream is) throws IOException {
        Document r;
        try {
            r = new SAXBuilder().build(is);
        }
        catch (JDOMException e) {
            throw new RuntimeException(e);
        }
        if (this.doc == null) {
            this.doc = r;
            Element el = this.doc.getRootElement();
            el.setAttribute("name", "default");
            el.setAttribute("provider", "cxf.apache.org");
        } else {
            Element root = r.getRootElement();
            Iterator itr = root.getChildren().iterator();
            while (itr.hasNext()) {
                Content n = (Content)itr.next();
                itr.remove();
                this.doc.getRootElement().addContent(n);
            }
        }
    }

    public boolean hasTransformedResource() {
        return this.doc != null;
    }

    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        jos.putNextEntry(new JarEntry(this.resource));
        new XMLOutputter(Format.getPrettyFormat()).output(this.doc, (OutputStream)jos);
        this.doc = null;
    }
}

