/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.types;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.CorbaTypeMap;
import org.apache.cxf.binding.corba.types.AbstractCorbaTypeListener;
import org.apache.cxf.binding.corba.types.CorbaHandlerUtils;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.apache.cxf.binding.corba.types.CorbaPrimitiveHandler;
import org.apache.cxf.binding.corba.types.CorbaTypeListener;
import org.apache.cxf.binding.corba.types.CorbaUnionHandler;
import org.apache.cxf.binding.corba.wsdl.CaseType;
import org.apache.cxf.binding.corba.wsdl.Union;
import org.apache.cxf.binding.corba.wsdl.Unionbranch;
import org.apache.cxf.service.model.ServiceInfo;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;

public class CorbaUnionListener
extends AbstractCorbaTypeListener {
    private CorbaTypeMap typeMap;
    private ServiceInfo serviceInfo;
    private ORB orb;
    private List<Unionbranch> branches;
    private CorbaTypeListener currentTypeListener;
    private Union unionType;

    public CorbaUnionListener(CorbaObjectHandler handler, CorbaTypeMap tm, ORB oorb, ServiceInfo sInfo) {
        super(handler);
        this.typeMap = tm;
        this.serviceInfo = sInfo;
        this.orb = oorb;
        this.unionType = (Union)handler.getType();
        this.branches = this.unionType.getUnionbranch();
    }

    @Override
    public void processStartElement(QName name) {
        if (this.currentTypeListener == null) {
            for (Unionbranch branch : this.branches) {
                CorbaObjectHandler content;
                QName unionName = null;
                String branchName = branch.getName();
                if (branch.getName().equals(name.getLocalPart())) {
                    unionName = name;
                } else if (this.branches.size() == 1) {
                    unionName = this.handler.getName();
                }
                if (unionName != null) {
                    CorbaObjectHandler discObj = CorbaHandlerUtils.createTypeHandler(this.orb, new QName("discriminator"), this.unionType.getDiscriminator(), this.typeMap);
                    ((CorbaUnionHandler)this.handler).setDiscriminator(discObj);
                    String descriminatorValue = this.determineDescriminatorValue(branch);
                    ((CorbaUnionHandler)this.handler).setDiscriminatorValueFromData(descriminatorValue);
                    this.currentTypeListener = CorbaHandlerUtils.getTypeListener(unionName, branch.getIdltype(), this.typeMap, this.orb, this.serviceInfo);
                    this.currentTypeListener.setNamespaceContext(this.ctx);
                    content = this.currentTypeListener.getCorbaObject();
                    ((CorbaUnionHandler)this.handler).setValue(branchName, content);
                    if (this.unionType.isSetNillable() && this.unionType.isNillable()) {
                        this.currentTypeListener.processStartElement(name);
                    }
                } else {
                    QName emptyBranchContentQName = new QName(name.getNamespaceURI(), branchName);
                    content = CorbaHandlerUtils.initializeObjectHandler(this.orb, emptyBranchContentQName, branch.getIdltype(), this.typeMap, this.serviceInfo);
                }
                ((CorbaUnionHandler)this.handler).addCase(content);
            }
        } else {
            this.currentTypeListener.processStartElement(name);
        }
    }

    @Override
    public void processCharacters(String text) {
        if (this.currentTypeListener != null) {
            this.currentTypeListener.processCharacters(text);
        } else {
            CorbaPrimitiveHandler discObj = new CorbaPrimitiveHandler(new QName("discriminator"), this.unionType.getDiscriminator(), this.orb.get_primitive_tc(TCKind.from_int((int)8)), null);
            discObj.setValue(Boolean.TRUE);
            ((CorbaUnionHandler)this.handler).setDiscriminator(discObj);
            CorbaTypeListener typeListener = CorbaHandlerUtils.getTypeListener(this.handler.getName(), this.branches.get(0).getIdltype(), this.typeMap, this.orb, this.serviceInfo);
            typeListener.setNamespaceContext(this.ctx);
            ((CorbaUnionHandler)this.handler).setValue("value", typeListener.getCorbaObject());
            typeListener.processCharacters(text);
        }
    }

    @Override
    public void processEndElement(QName name) {
        if (this.currentTypeListener != null) {
            this.currentTypeListener.processEndElement(name);
        }
    }

    private String determineDescriminatorValue(Unionbranch branch) {
        String descriminatorValue;
        List<CaseType> branchCases = branch.getCase();
        if (branchCases.size() != 0) {
            CaseType caseLabel = branchCases.get(0);
            descriminatorValue = caseLabel.getLabel();
        } else {
            descriminatorValue = ((CorbaUnionHandler)this.handler).createDefaultDiscriminatorLabel();
        }
        return descriminatorValue;
    }

    @Override
    public void processWriteAttribute(String prefix, String namespaceURI, String localName, String val) {
        if ("nil".equals(localName)) {
            CorbaPrimitiveHandler discObj = new CorbaPrimitiveHandler(new QName("discriminator"), this.unionType.getDiscriminator(), this.orb.get_primitive_tc(TCKind.from_int((int)8)), null);
            discObj.setValue(Boolean.FALSE);
            ((CorbaUnionHandler)this.handler).setDiscriminator(discObj);
            Unionbranch branch = this.branches.get(0);
            QName emptyBranchContentQName = new QName(this.handler.getName().getNamespaceURI(), branch.getName());
            CorbaObjectHandler content = CorbaHandlerUtils.initializeObjectHandler(this.orb, emptyBranchContentQName, branch.getIdltype(), this.typeMap, this.serviceInfo);
            ((CorbaUnionHandler)this.handler).addCase(content);
        } else if (this.currentTypeListener != null) {
            this.currentTypeListener.processWriteAttribute(prefix, namespaceURI, localName, val);
        }
    }

    @Override
    public void processWriteNamespace(String prefix, String namespaceURI) {
        if (this.currentTypeListener != null) {
            this.currentTypeListener.processWriteNamespace(prefix, namespaceURI);
        }
    }
}

