/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.CorbaBindingException;
import org.apache.cxf.binding.corba.CorbaStreamable;
import org.apache.cxf.binding.corba.CorbaTypeMap;
import org.apache.cxf.binding.corba.wsdl.Alias;
import org.apache.cxf.binding.corba.wsdl.Anonarray;
import org.apache.cxf.binding.corba.wsdl.Anonfixed;
import org.apache.cxf.binding.corba.wsdl.Anonsequence;
import org.apache.cxf.binding.corba.wsdl.Anonstring;
import org.apache.cxf.binding.corba.wsdl.Anonwstring;
import org.apache.cxf.binding.corba.wsdl.Array;
import org.apache.cxf.binding.corba.wsdl.CaseType;
import org.apache.cxf.binding.corba.wsdl.CorbaConstants;
import org.apache.cxf.binding.corba.wsdl.CorbaType;
import org.apache.cxf.binding.corba.wsdl.CorbaTypeImpl;
import org.apache.cxf.binding.corba.wsdl.Enum;
import org.apache.cxf.binding.corba.wsdl.Enumerator;
import org.apache.cxf.binding.corba.wsdl.Fixed;
import org.apache.cxf.binding.corba.wsdl.MemberType;
import org.apache.cxf.binding.corba.wsdl.Sequence;
import org.apache.cxf.binding.corba.wsdl.Struct;
import org.apache.cxf.binding.corba.wsdl.TypeMappingType;
import org.apache.cxf.binding.corba.wsdl.Union;
import org.apache.cxf.binding.corba.wsdl.Unionbranch;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaExternal;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.omg.CORBA.Any;
import org.omg.CORBA.NVList;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.Streamable;

public final class CorbaUtils {
    static final QName EMPTY_QNAME = new QName("", "");
    static final Map<QName, TCKind> PRIMITIVE_TYPECODES = new HashMap<QName, TCKind>();
    private static final Logger LOG = LogUtils.getL7dLogger(CorbaUtils.class);
    private static final ThreadLocal<LastExport> LAST_EXPORT_CACHE = new ThreadLocal();

    private CorbaUtils() {
    }

    public static QName getEmptyQName() {
        return EMPTY_QNAME;
    }

    public static TypeCode getTypeCode(ORB orb, QName type, CorbaTypeMap typeMap) {
        Stack<QName> seenTypes = new Stack<QName>();
        return CorbaUtils.getTypeCode(orb, type, null, typeMap, seenTypes);
    }

    public static TypeCode getTypeCode(ORB orb, QName type, CorbaTypeMap typeMap, Stack<QName> seenTypes) {
        return CorbaUtils.getTypeCode(orb, type, null, typeMap, seenTypes);
    }

    public static TypeCode getTypeCode(ORB orb, QName type, CorbaType obj, CorbaTypeMap typeMap) {
        Stack<QName> seenTypes = new Stack<QName>();
        return CorbaUtils.getTypeCode(orb, type, obj, typeMap, seenTypes);
    }

    public static TypeCode getTypeCode(ORB orb, QName type, CorbaType obj, CorbaTypeMap typeMap, Stack<QName> seenTypes) {
        if (type == null) {
            throw new CorbaBindingException("corba:typemap type or elemtype information required" + (obj == null ? "" : " for " + obj) + (seenTypes.empty() ? "" : ", Enclosing type: " + seenTypes.elementAt(0)));
        }
        TypeCode tc = null;
        tc = CorbaUtils.getPrimitiveTypeCode(orb, type);
        if (tc == null && type.equals(CorbaConstants.NT_CORBA_ANY)) {
            tc = orb.get_primitive_tc(TCKind.from_int((int)11));
        } else if (tc == null) {
            if (typeMap == null) {
                throw new CorbaBindingException("Unable to locate typemap for namespace \"" + type.getNamespaceURI() + "\"");
            }
            tc = typeMap.getTypeCode(type);
            if (tc == null) {
                if (obj == null && (obj = typeMap.getType(type.getLocalPart())) == null) {
                    throw new CorbaBindingException("Unable to locate object definition");
                }
                tc = CorbaUtils.getComplexTypeCode(orb, type, obj, typeMap, seenTypes);
                if (tc != null) {
                    typeMap.addTypeCode(type, tc);
                }
            }
        }
        if (tc == null) {
            throw new CorbaBindingException("Corba type node with qname " + type + " is not supported");
        }
        return tc;
    }

    public static TypeCode getPrimitiveTypeCode(ORB orb, QName type) {
        QName uriIdltype;
        TCKind kind = PRIMITIVE_TYPECODES.get(type);
        if (kind != null) {
            return orb.get_primitive_tc(kind);
        }
        if (type.getNamespaceURI() == null && (kind = PRIMITIVE_TYPECODES.get(uriIdltype = new QName("http://cxf.apache.org/bindings/corba", type.getLocalPart(), type.getPrefix()))) != null) {
            return orb.get_primitive_tc(kind);
        }
        return null;
    }

    public static TypeCode getComplexTypeCode(ORB orb, QName type, java.lang.Object obj, CorbaTypeMap typeMap, Stack<QName> seenTypes) {
        TypeCode tc = CorbaUtils.getAnonTypeCode(orb, type, obj, typeMap, seenTypes);
        if (tc == null) {
            if (obj instanceof Alias) {
                Alias aliasType = (Alias)obj;
                tc = orb.create_alias_tc(aliasType.getRepositoryID(), CorbaUtils.getTypeCodeName(aliasType.getName()), CorbaUtils.getTypeCode(orb, aliasType.getBasetype(), typeMap, seenTypes));
            } else if (obj instanceof Array) {
                Array arrayType = (Array)obj;
                tc = orb.create_array_tc((int)arrayType.getBound(), CorbaUtils.getTypeCode(orb, arrayType.getElemtype(), typeMap, seenTypes));
            } else if (obj instanceof Enum) {
                Enum enumType = (Enum)obj;
                String name = enumType.getName();
                List<Enumerator> enums = enumType.getEnumerator();
                String[] members = new String[enums.size()];
                for (int i = 0; i < members.length; ++i) {
                    members[i] = enums.get(i).getValue();
                }
                name = CorbaUtils.getTypeCodeName(name);
                tc = orb.create_enum_tc(enumType.getRepositoryID(), name, members);
            } else if (obj instanceof org.apache.cxf.binding.corba.wsdl.Exception) {
                org.apache.cxf.binding.corba.wsdl.Exception exceptType = (org.apache.cxf.binding.corba.wsdl.Exception)obj;
                List<MemberType> list = exceptType.getMember();
                StructMember[] members = new StructMember[list.size()];
                for (int i = 0; i < members.length; ++i) {
                    MemberType member = list.get(i);
                    members[i] = new StructMember(member.getName(), CorbaUtils.getTypeCode(orb, member.getIdltype(), typeMap, seenTypes), null);
                }
                String name = CorbaUtils.getTypeCodeName(exceptType.getName());
                tc = orb.create_exception_tc(exceptType.getRepositoryID(), name, members);
            } else if (obj instanceof Fixed) {
                Fixed fixedType = (Fixed)obj;
                tc = orb.create_fixed_tc((short)fixedType.getDigits(), (short)fixedType.getScale());
            } else if (obj instanceof org.apache.cxf.binding.corba.wsdl.Object) {
                org.apache.cxf.binding.corba.wsdl.Object objType = (org.apache.cxf.binding.corba.wsdl.Object)obj;
                tc = objType.getName().equals("CORBA.Object") ? orb.create_interface_tc(objType.getRepositoryID(), "Object") : orb.create_interface_tc(objType.getRepositoryID(), CorbaUtils.getTypeCodeName(objType.getName()));
            } else if (obj instanceof Sequence) {
                Sequence seqType = (Sequence)obj;
                tc = orb.create_sequence_tc((int)seqType.getBound(), CorbaUtils.getTypeCode(orb, seqType.getElemtype(), typeMap, seenTypes));
            } else if (obj instanceof Struct) {
                Struct structType = (Struct)obj;
                if (seenTypes.contains(new QName(structType.getName()))) {
                    tc = orb.create_recursive_tc(structType.getRepositoryID());
                } else {
                    seenTypes.push(new QName(structType.getName()));
                    List<MemberType> list = structType.getMember();
                    StructMember[] members = new StructMember[list.size()];
                    for (int i = 0; i < members.length; ++i) {
                        MemberType member = list.get(i);
                        members[i] = new StructMember(member.getName(), CorbaUtils.getTypeCode(orb, member.getIdltype(), typeMap, seenTypes), null);
                    }
                    String name = CorbaUtils.getTypeCodeName(structType.getName());
                    tc = orb.create_struct_tc(structType.getRepositoryID(), name, members);
                    seenTypes.pop();
                }
            } else if (obj instanceof Union) {
                tc = CorbaUtils.getUnionTypeCode(orb, obj, typeMap, seenTypes);
            }
        }
        return tc;
    }

    private static TypeCode getAnonTypeCode(ORB orb, QName type, java.lang.Object obj, CorbaTypeMap typeMap, Stack<QName> seenTypes) {
        TypeCode tc = null;
        if (obj instanceof Anonarray) {
            Anonarray anonArrayType = (Anonarray)obj;
            tc = orb.create_array_tc((int)anonArrayType.getBound(), CorbaUtils.getTypeCode(orb, anonArrayType.getElemtype(), typeMap, seenTypes));
        } else if (obj instanceof Anonfixed) {
            Anonfixed anonFixedType = (Anonfixed)obj;
            tc = orb.create_fixed_tc((short)anonFixedType.getDigits(), (short)anonFixedType.getScale());
        } else if (obj instanceof Anonsequence) {
            Anonsequence anonSeqType = (Anonsequence)obj;
            tc = orb.create_sequence_tc((int)anonSeqType.getBound(), CorbaUtils.getTypeCode(orb, anonSeqType.getElemtype(), typeMap, seenTypes));
        } else if (obj instanceof Anonstring) {
            Anonstring anonStringType = (Anonstring)obj;
            tc = orb.create_string_tc((int)anonStringType.getBound());
        } else if (obj instanceof Anonwstring) {
            Anonwstring anonWStringType = (Anonwstring)obj;
            tc = orb.create_wstring_tc((int)anonWStringType.getBound());
        }
        return tc;
    }

    public static TypeCode getUnionTypeCode(ORB orb, java.lang.Object obj, CorbaTypeMap typeMap, Stack<QName> seenTypes) {
        Union unionType = (Union)obj;
        if (seenTypes.contains(new QName(unionType.getName()))) {
            return orb.create_recursive_tc(unionType.getRepositoryID());
        }
        seenTypes.push(new QName(unionType.getName()));
        TypeCode discTC = CorbaUtils.getTypeCode(orb, unionType.getDiscriminator(), typeMap, seenTypes);
        LinkedHashMap<String, UnionMember> members = new LinkedHashMap<String, UnionMember>();
        List<Unionbranch> branches = unionType.getUnionbranch();
        for (Unionbranch branch : branches) {
            List<CaseType> cases = branch.getCase();
            for (CaseType cs : cases) {
                if (members.containsKey(cs.getLabel())) continue;
                UnionMember member = new UnionMember();
                member.name = branch.getName();
                member.type = CorbaUtils.getTypeCode(orb, branch.getIdltype(), typeMap, seenTypes);
                member.label = orb.create_any();
                switch (discTC.kind().value()) {
                    case 2: {
                        member.label.insert_short(Short.parseShort(cs.getLabel()));
                        break;
                    }
                    case 4: {
                        member.label.insert_ushort(Short.parseShort(cs.getLabel()));
                        break;
                    }
                    case 3: {
                        member.label.insert_long(Integer.parseInt(cs.getLabel()));
                        break;
                    }
                    case 5: {
                        member.label.insert_ulong(Integer.parseInt(cs.getLabel()));
                        break;
                    }
                    case 23: {
                        member.label.insert_longlong(Long.parseLong(cs.getLabel()));
                        break;
                    }
                    case 24: {
                        member.label.insert_ulonglong(Long.parseLong(cs.getLabel()));
                        break;
                    }
                    case 9: {
                        member.label.insert_char(cs.getLabel().charAt(0));
                        break;
                    }
                    case 8: {
                        member.label.insert_boolean(Boolean.parseBoolean(cs.getLabel()));
                        break;
                    }
                    case 17: {
                        OutputStream out = member.label.create_output_stream();
                        Enum enumVal = (Enum)CorbaUtils.getCorbaType(unionType.getDiscriminator(), typeMap);
                        List<Enumerator> enumerators = enumVal.getEnumerator();
                        for (int i = 0; i < enumerators.size(); ++i) {
                            Enumerator e = enumerators.get(i);
                            if (!e.getValue().equals(cs.getLabel())) continue;
                            out.write_long(i);
                        }
                        member.label.read_value(out.create_input_stream(), discTC);
                        break;
                    }
                    default: {
                        throw new CorbaBindingException("Unsupported discriminator type");
                    }
                }
                members.put(cs.getLabel(), member);
            }
        }
        seenTypes.pop();
        return orb.create_union_tc(unionType.getRepositoryID(), CorbaUtils.getTypeCodeName(unionType.getName()), discTC, members.values().toArray(new UnionMember[members.size()]));
    }

    public static String getTypeCodeName(String name) {
        int pos = name.lastIndexOf(".");
        if (pos != -1) {
            name = name.substring(pos + 1);
        }
        return name;
    }

    public static boolean isPrimitiveIdlType(QName idltype) {
        QName uriIdltype;
        TCKind kind = PRIMITIVE_TYPECODES.get(idltype);
        if (kind != null) {
            return true;
        }
        return idltype.getNamespaceURI() == null && (kind = PRIMITIVE_TYPECODES.get(uriIdltype = new QName("http://cxf.apache.org/bindings/corba", idltype.getLocalPart(), idltype.getPrefix()))) != null;
    }

    public static boolean isPrimitiveTypeCode(TypeCode tc) {
        return PRIMITIVE_TYPECODES.values().contains(tc.kind());
    }

    public static CorbaTypeImpl getCorbaType(QName idlType, CorbaTypeMap typeMap) {
        if (!CorbaUtils.isPrimitiveIdlType(idlType) && typeMap != null) {
            return typeMap.getType(idlType.getLocalPart());
        }
        return null;
    }

    public static CorbaTypeMap createCorbaTypeMap(List<TypeMappingType> tmTypes) {
        CorbaTypeMap map = null;
        if (tmTypes != null) {
            TypeMappingType tmType = tmTypes.get(0);
            map = new CorbaTypeMap(tmType.getTargetNamespace());
            List<CorbaTypeImpl> types = tmType.getStructOrExceptionOrUnion();
            LOG.fine("Found " + types.size() + " types defined in the typemap");
            for (CorbaTypeImpl corbaType : types) {
                String name = corbaType.getName();
                int pos = name.lastIndexOf(":");
                if (pos != -1) {
                    name = name.substring(pos + 1);
                    corbaType.setName(name);
                }
                map.addType(name, corbaType);
                LOG.fine("Adding type " + name);
            }
        }
        return map;
    }

    public static boolean isValidURL(String url) {
        if (url.startsWith("ior:") || url.startsWith("IOR:")) {
            return true;
        }
        if (url.startsWith("file:")) {
            return true;
        }
        if (url.startsWith("corbaloc:")) {
            return true;
        }
        return url.startsWith("corbaname:");
    }

    public static String getUniquePOAName(QName serviceName, String portName, String poaName) {
        String result = "{" + serviceName.getNamespaceURI() + "}" + serviceName.getLocalPart() + "#" + portName;
        if (poaName != null) {
            result = result + "#" + poaName;
        }
        return result;
    }

    public static boolean isIOR(String location) {
        return location.startsWith("ior:") || location.startsWith("IOR:");
    }

    public static String exportObjectReference(Object obj, ORB orb) {
        String ior = orb.object_to_string(obj);
        LAST_EXPORT_CACHE.set(new LastExport(ior, obj));
        return ior;
    }

    public static Object importObjectReference(ORB orb, String url) {
        Object result;
        if (url.startsWith("file:")) {
            return CorbaUtils.importObjectReferenceFromFile(orb, url.substring(5));
        }
        if ("IOR:".equalsIgnoreCase(url)) {
            throw new RuntimeException("Proxy not initialized. URL contains a invalid ior");
        }
        String trimmedUrl = url.trim();
        LastExport last = LAST_EXPORT_CACHE.get();
        if (last != null && trimmedUrl.equals(last.getIor())) {
            return last.getRef();
        }
        try {
            result = orb.string_to_object(trimmedUrl);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    public static Object importObjectReferenceFromFile(ORB orb, String url) {
        Object result;
        BufferedReader reader = null;
        try {
            File file = new File(url);
            if (!file.exists()) {
                throw new RuntimeException("Could not find file " + url + " to read the object reference");
            }
            reader = new BufferedReader(new FileReader(file));
            String ior = reader.readLine();
            if (ior == null) {
                throw new RuntimeException("Invalid object reference found in file " + url);
            }
            result = orb.string_to_object(ior.trim());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return result;
    }

    public static XmlSchemaType getXmlSchemaType(ServiceInfo serviceInfo, QName name) {
        XmlSchemaElement el;
        SchemaCollection col;
        XmlSchemaType result = null;
        if (name != null && serviceInfo != null && (result = (col = serviceInfo.getXmlSchemaCollection()).getTypeByQName(name)) == null && (el = col.getElementByQName(name)) != null) {
            result = el.getSchemaType();
        }
        return result;
    }

    public static boolean isElementFormQualified(ServiceInfo serviceInfo, String uri) {
        if (uri != null) {
            SchemaInfo schemaInfo = serviceInfo.getSchema(uri);
            if (schemaInfo != null) {
                return schemaInfo.isElementFormQualified();
            }
            Iterator<SchemaInfo> it = serviceInfo.getSchemas().iterator();
            if (it.hasNext()) {
                XmlSchema schema = it.next().getSchema();
                return CorbaUtils.isElementFormQualified(schema, uri);
            }
        }
        return false;
    }

    private static boolean isElementFormQualified(XmlSchema schema, String uri) {
        if (uri.equals(schema.getTargetNamespace())) {
            return schema.getElementFormDefault() == XmlSchemaForm.QUALIFIED;
        }
        Iterator i$ = schema.getExternals().iterator();
        if (i$.hasNext()) {
            XmlSchemaExternal extSchema = (XmlSchemaExternal)i$.next();
            return CorbaUtils.isElementFormQualified(extSchema.getSchema(), uri);
        }
        return false;
    }

    public static boolean isAttributeFormQualified(ServiceInfo serviceInfo, String uri) {
        if (uri != null) {
            SchemaInfo schemaInfo = serviceInfo.getSchema(uri);
            if (schemaInfo != null) {
                return schemaInfo.isAttributeFormQualified();
            }
            Iterator<SchemaInfo> it = serviceInfo.getSchemas().iterator();
            if (it.hasNext()) {
                XmlSchema schema = it.next().getSchema();
                return CorbaUtils.isAttributeFormQualified(schema, uri);
            }
        }
        return false;
    }

    private static boolean isAttributeFormQualified(XmlSchema schema, String uri) {
        if (uri.equals(schema.getTargetNamespace())) {
            return schema.getAttributeFormDefault() == XmlSchemaForm.QUALIFIED;
        }
        Iterator i$ = schema.getExternals().iterator();
        if (i$.hasNext()) {
            XmlSchemaExternal extSchema = (XmlSchemaExternal)i$.next();
            return CorbaUtils.isAttributeFormQualified(extSchema.getSchema(), uri);
        }
        return false;
    }

    public static QName processQName(QName qname, ServiceInfo serviceInfo) {
        QName result = qname;
        if (qname.getNamespaceURI() != null && !qname.getNamespaceURI().equals("") && !CorbaUtils.isElementFormQualified(serviceInfo, qname.getNamespaceURI())) {
            result = new QName("", qname.getLocalPart());
        }
        return result;
    }

    public static NVList nvListFromStreamables(ORB orb, CorbaStreamable[] streamables) {
        NVList list = null;
        if (streamables != null && streamables.length > 0) {
            list = orb.create_list(streamables.length);
            for (int i = 0; i < streamables.length; ++i) {
                Any value = orb.create_any();
                value.insert_Streamable((Streamable)streamables[i]);
                list.add_value(streamables[i].getName(), value, streamables[i].getMode());
            }
        } else {
            list = orb.create_list(0);
        }
        return list;
    }

    static {
        PRIMITIVE_TYPECODES.put(CorbaConstants.NT_CORBA_BOOLEAN, TCKind.from_int((int)8));
        PRIMITIVE_TYPECODES.put(CorbaConstants.NT_CORBA_CHAR, TCKind.from_int((int)9));
        PRIMITIVE_TYPECODES.put(CorbaConstants.NT_CORBA_WCHAR, TCKind.from_int((int)26));
        PRIMITIVE_TYPECODES.put(CorbaConstants.NT_CORBA_OCTET, TCKind.from_int((int)10));
        PRIMITIVE_TYPECODES.put(CorbaConstants.NT_CORBA_USHORT, TCKind.from_int((int)4));
        PRIMITIVE_TYPECODES.put(CorbaConstants.NT_CORBA_SHORT, TCKind.from_int((int)2));
        PRIMITIVE_TYPECODES.put(CorbaConstants.NT_CORBA_LONG, TCKind.from_int((int)3));
        PRIMITIVE_TYPECODES.put(CorbaConstants.NT_CORBA_ULONG, TCKind.from_int((int)5));
        PRIMITIVE_TYPECODES.put(CorbaConstants.NT_CORBA_LONGLONG, TCKind.from_int((int)23));
        PRIMITIVE_TYPECODES.put(CorbaConstants.NT_CORBA_ULONGLONG, TCKind.from_int((int)24));
        PRIMITIVE_TYPECODES.put(CorbaConstants.NT_CORBA_FLOAT, TCKind.from_int((int)6));
        PRIMITIVE_TYPECODES.put(CorbaConstants.NT_CORBA_DOUBLE, TCKind.from_int((int)7));
        PRIMITIVE_TYPECODES.put(CorbaConstants.NT_CORBA_STRING, TCKind.from_int((int)18));
        PRIMITIVE_TYPECODES.put(CorbaConstants.NT_CORBA_WSTRING, TCKind.from_int((int)27));
    }

    private static final class LastExport {
        private final String ior;
        private final Object ref;

        LastExport(String iors, Object oref) {
            this.ior = iors;
            this.ref = oref;
        }

        String getIor() {
            return this.ior;
        }

        Object getRef() {
            return this.ref;
        }
    }
}

