/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.MessageProcessingException;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ReaderInterceptor;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

public final class ResponseImpl
extends Response {
    private int status;
    private Object entity;
    private Annotation[] entityAnnotations;
    private MultivaluedMap<String, Object> metadata;
    private Message responseMessage;
    private boolean entityClosed;
    private boolean entityBufferred;
    private Object lastEntity;

    ResponseImpl(int s) {
        this.status = s;
    }

    ResponseImpl(int s, Object e) {
        this.status = s;
        this.entity = e;
    }

    void addMetadata(MultivaluedMap<String, Object> meta) {
        this.metadata = meta;
    }

    public void setStatus(int s) {
        this.status = s;
    }

    public void setEntity(Object e, Annotation[] anns) {
        this.entity = e;
        this.entityAnnotations = anns;
    }

    public void setEntityAnnotations(Annotation[] anns) {
        this.entityAnnotations = anns;
    }

    public Annotation[] getEntityAnnotations() {
        return this.entityAnnotations;
    }

    public void setMessage(Message message) {
        this.responseMessage = message;
    }

    public int getStatus() {
        return this.status;
    }

    public Response.StatusType getStatusInfo() {
        return new Response.StatusType(){

            public Response.Status.Family getFamily() {
                return Response.Status.Family.familyOf((int)ResponseImpl.this.status);
            }

            public String getReasonPhrase() {
                Response.Status statusEnum = Response.Status.fromStatusCode((int)ResponseImpl.this.status);
                return statusEnum != null ? statusEnum.getReasonPhrase() : "";
            }

            public int getStatusCode() {
                return ResponseImpl.this.status;
            }
        };
    }

    public Object getEntity() {
        return this.lastEntity != null ? this.lastEntity : this.entity;
    }

    public boolean hasEntity() {
        return this.getEntity() != null;
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return this.getHeaders();
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.metadata;
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        MetadataMap<String, String> headers = new MetadataMap<String, String>(this.metadata.size());
        for (Map.Entry entry : this.metadata.entrySet()) {
            headers.put((String)entry.getKey(), this.toListOfStrings((List)entry.getValue()));
        }
        return headers;
    }

    private String getHeader(String header) {
        Object value = this.metadata.getFirst((Object)header);
        return value == null ? null : value.toString();
    }

    public String getHeaderString(String header) {
        List methodValues = (List)this.metadata.get((Object)header);
        return HttpUtils.getHeaderString(this.toListOfStrings(methodValues));
    }

    private List<String> toListOfStrings(List<Object> values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> stringValues = new ArrayList<String>(values.size());
        for (Object value : values) {
            stringValues.add(value.toString());
        }
        return stringValues;
    }

    public Set<String> getAllowedMethods() {
        List methodValues = (List)this.metadata.get((Object)"Allow");
        if (methodValues == null) {
            return Collections.emptySet();
        }
        HashSet<String> methods = new HashSet<String>();
        for (Object o : methodValues) {
            methods.add(o.toString());
        }
        return methods;
    }

    public Map<String, NewCookie> getCookies() {
        List cookieValues = (List)this.metadata.get((Object)"Set-Cookie");
        if (cookieValues == null) {
            return Collections.emptyMap();
        }
        HashMap<String, NewCookie> cookies = new HashMap<String, NewCookie>();
        for (Object o : cookieValues) {
            NewCookie newCookie = NewCookie.valueOf((String)o.toString());
            cookies.put(newCookie.getName(), newCookie);
        }
        return cookies;
    }

    public Date getDate() {
        return this.doGetDate("Date");
    }

    private Date doGetDate(String dateHeader) {
        return HttpUtils.getHttpDate(this.getHeader(dateHeader));
    }

    public EntityTag getEntityTag() {
        String header = this.getHeader("ETag");
        return header == null ? null : EntityTag.valueOf((String)header);
    }

    public Locale getLanguage() {
        return HttpUtils.getLocale(this.getHeader("Content-Language"));
    }

    public Date getLastModified() {
        return this.doGetDate("Last-Modified");
    }

    public int getLength() {
        return HttpUtils.getContentLength(this.getHeader("Content-Length"));
    }

    public URI getLocation() {
        String header = this.getHeader("Location");
        return header == null ? null : URI.create(header);
    }

    public MediaType getMediaType() {
        String header = this.getHeader("Content-Type");
        return header == null ? null : JAXRSUtils.toMediaType(header);
    }

    public boolean hasLink(String relation) {
        return this.getLink(relation) != null;
    }

    public Link getLink(String relation) {
        Set<Map.Entry<String, Link>> entries = this.getAllLinks().entrySet();
        for (Map.Entry<String, Link> entry : entries) {
            if (!entry.getKey().contains(relation)) continue;
            return entry.getValue();
        }
        return null;
    }

    public Link.Builder getLinkBuilder(String relation) {
        return Link.fromLink((Link)this.getLink(relation));
    }

    public Set<Link> getLinks() {
        return new HashSet<Link>(this.getAllLinks().values());
    }

    private Map<String, Link> getAllLinks() {
        List linkValues = (List)this.metadata.get((Object)"Link");
        if (linkValues == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Link> links = new HashMap<String, Link>();
        for (Object o : linkValues) {
            Link link = Link.valueOf((String)o.toString());
            links.put(link.getRel(), link);
        }
        return links;
    }

    public <T> T readEntity(Class<T> cls) throws MessageProcessingException, IllegalStateException {
        return this.readEntity(cls, new Annotation[0]);
    }

    public <T> T readEntity(GenericType<T> genType) throws MessageProcessingException, IllegalStateException {
        return this.readEntity(genType, new Annotation[0]);
    }

    public <T> T readEntity(Class<T> cls, Annotation[] anns) throws MessageProcessingException, IllegalStateException {
        return this.doReadEntity(cls, cls, anns);
    }

    public <T> T readEntity(GenericType<T> genType, Annotation[] anns) throws MessageProcessingException, IllegalStateException {
        return this.doReadEntity(genType.getRawType(), genType.getType(), anns);
    }

    public <T> T doReadEntity(Class<T> cls, Type t, Annotation[] anns) throws MessageProcessingException, IllegalStateException {
        this.checkEntityIsClosed();
        if (this.lastEntity != null && cls.isAssignableFrom(this.lastEntity.getClass()) && !(this.lastEntity instanceof InputStream)) {
            return cls.cast(this.lastEntity);
        }
        if (this.entity instanceof InputStream) {
            List<ReaderInterceptor> readers;
            MediaType mediaType = this.getMediaType();
            if (mediaType == null) {
                mediaType = MediaType.WILDCARD_TYPE;
            }
            if ((readers = ProviderFactory.getInstance(this.responseMessage).createMessageBodyReaderInterceptor(cls, t, anns, mediaType, this.responseMessage.getExchange().getOutMessage())) != null) {
                try {
                    if (this.entityBufferred) {
                        ((InputStream)InputStream.class.cast(this.entity)).reset();
                    }
                    this.responseMessage.put(Message.PROTOCOL_HEADERS, this.getMetadata());
                    this.lastEntity = JAXRSUtils.readFromMessageBodyReader(readers, cls, t, anns, (InputStream)InputStream.class.cast(this.entity), mediaType, this.responseMessage);
                    if (!this.entityBufferred && this.responseStreamCanBeClosed(cls)) {
                        ((InputStream)InputStream.class.cast(this.entity)).close();
                        this.entity = null;
                    }
                    return this.castLastEntity();
                }
                catch (Exception ex) {
                    throw new MessageProcessingException((Throwable)ex);
                }
            }
            throw new MessageProcessingException("No message body reader for class: " + cls);
        }
        if (this.entity != null && cls.isAssignableFrom(this.entity.getClass())) {
            this.lastEntity = this.entity;
            return this.castLastEntity();
        }
        throw new IllegalStateException("The entity is not backed by an input stream, entity class is : " + (this.entity != null ? this.entity.getClass().getName() : null));
    }

    private <T> T castLastEntity() {
        return (T)this.lastEntity;
    }

    protected boolean responseStreamCanBeClosed(Class<?> cls) {
        return cls != InputStream.class && MessageUtils.isTrue(this.responseMessage.getContextualProperty("response.stream.auto.close"));
    }

    public boolean bufferEntity() throws MessageProcessingException {
        this.checkEntityIsClosed();
        if (!this.entityBufferred && this.entity instanceof InputStream) {
            try {
                InputStream oldEntity = (InputStream)this.entity;
                this.entity = IOUtils.loadIntoBAIS(oldEntity);
                oldEntity.close();
                this.entityBufferred = true;
            }
            catch (IOException ex) {
                throw new MessageProcessingException((Throwable)ex);
            }
        }
        return this.entityBufferred;
    }

    public void close() throws MessageProcessingException {
        if (!this.entityClosed) {
            if (!this.entityBufferred && this.entity instanceof InputStream) {
                try {
                    ((InputStream)this.entity).close();
                }
                catch (IOException ex) {
                    throw new MessageProcessingException((Throwable)ex);
                }
            }
            this.entity = null;
            this.entityClosed = true;
        }
    }

    private void checkEntityIsClosed() {
        if (this.entityClosed) {
            throw new IllegalStateException("Entity is not available");
        }
    }
}

