/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jibx.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.jibx.schema.ISchemaResolver;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class JibxSchemaResolver
implements ISchemaResolver {
    private String id;
    private String name;
    private XmlSchema schema;
    private Element element;
    private SchemaCollection collection;

    public JibxSchemaResolver(String id, XmlSchema schema, SchemaCollection collection, Element element) {
        this.id = id;
        this.setName(id);
        this.schema = schema;
        this.collection = collection;
        this.element = element;
    }

    public InputStream getContent() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.schema.write((OutputStream)bos);
        return new ByteArrayInputStream(bos.toByteArray());
    }

    public String getId() {
        return this.id;
    }

    public Element getElement() {
        return this.element;
    }

    private void setName(String uri) {
        this.name = uri;
    }

    public String getName() {
        return this.name;
    }

    public ISchemaResolver resolve(String loc, String tns) throws IOException {
        URIResolver resolver = this.collection.getXmlSchemaCollection().getSchemaResolver();
        InputSource source = resolver.resolveEntity(tns, loc, this.id);
        SchemaCollection schemaCol = new SchemaCollection();
        schemaCol.setSchemaResolver(resolver);
        XmlSchema read = schemaCol.getXmlSchemaCollection().read(source);
        String uri = loc;
        try {
            URL url = new URL(new URL(this.id), loc);
            uri = url.toURI().toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        return new JibxSchemaResolver(uri, read, schemaCol, null);
    }
}

