/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.js.rhino;

import java.io.File;
import java.net.URLDecoder;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.js.rhino.ProviderFactory;

public class JsServiceFactoryBean {
    private ProviderFactory providerFactory = new ProviderFactory();
    private String address;
    private boolean isBaseAddr;
    private String js;
    private Bus bus;

    public Bus getBus() {
        if (this.bus == null) {
            this.bus = BusFactory.getThreadDefaultBus();
        }
        return this.bus;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public void setAddress(String addr) {
        this.address = addr;
    }

    public String getAddress() {
        return this.address;
    }

    public void setIsBaseAddr(boolean isBase) {
        this.isBaseAddr = isBase;
    }

    public boolean getIsBaseAddr() {
        return this.isBaseAddr;
    }

    public void setJs(String file) {
        this.js = file;
    }

    public String getJs() {
        return this.js;
    }

    public void create() throws Exception {
        BusFactory.setDefaultBus(this.bus);
        String jsFileString = this.getClass().getResource(this.js).toURI().getPath();
        jsFileString = URLDecoder.decode(jsFileString, "UTF-8");
        File file = new File(jsFileString);
        this.providerFactory.createAndPublish(file, this.address, this.isBaseAddr);
    }
}

