/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml;

import java.net.URI;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.ext.form.Form;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.provider.FormEncodingProvider;
import org.apache.cxf.jaxrs.utils.FormUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.saml.AbstractSamlBase64InHandler;

public class SamlFormInHandler
extends AbstractSamlBase64InHandler {
    private static final String SAML_ELEMENT = "SAMLToken";
    private static final String SAML_RELAY_STATE = "RelayState";
    private FormEncodingProvider<Form> provider = new FormEncodingProvider(true);

    @Override
    public Response handleRequest(Message message, ClassResourceInfo resourceClass) {
        UriInfoImpl ui;
        Form form = this.readFormData(message);
        String assertion = (String)form.getData().getFirst((Object)SAML_ELEMENT);
        this.handleToken(message, assertion);
        String samlRequestURI = (String)form.getData().getFirst((Object)SAML_RELAY_STATE);
        if (samlRequestURI != null && !samlRequestURI.startsWith((ui = new UriInfoImpl(message)).getBaseUri().toString())) {
            return Response.status((int)302).location(URI.create(samlRequestURI)).build();
        }
        form.getData().remove((Object)SAML_ELEMENT);
        form.getData().remove((Object)SAML_RELAY_STATE);
        try {
            FormUtils.restoreForm(this.provider, form, message);
        }
        catch (Exception ex) {
            this.throwFault(ex.getMessage(), ex);
        }
        return null;
    }

    private Form readFormData(Message message) {
        try {
            return FormUtils.readForm(this.provider, message);
        }
        catch (Exception ex) {
            this.throwFault("Error reading the form", ex);
            return null;
        }
    }
}

