/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.toolspec.parser;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.apache.cxf.tools.common.toolspec.parser.ErrorVisitor;
import org.apache.cxf.tools.common.toolspec.parser.TokenConsumer;
import org.apache.cxf.tools.common.toolspec.parser.TokenInputStream;
import org.w3c.dom.Element;

public class Argument
implements TokenConsumer {
    private static final Logger LOG = LogUtils.getL7dLogger(Argument.class);
    protected ToolSpec toolspec;
    private final Element element;
    private int numMatches;

    public Argument(Element el) {
        this.element = el;
    }

    @Override
    public boolean accept(TokenInputStream args, Element result, ErrorVisitor errors) {
        int minOccurs;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Accepting token stream for argument: " + this);
        }
        if ((minOccurs = "unbounded".equals(this.element.getAttribute("minOccurs")) ? 0 : Integer.parseInt(this.element.getAttribute("minOccurs"))) == 0) {
            this.addElement(args, result);
            return true;
        }
        if (minOccurs > args.available()) {
            return false;
        }
        if (args.peekPre().endsWith(",") && args.peekPre().startsWith("-")) {
            if (args.hasNext()) {
                args.readNext();
            } else {
                return false;
            }
        }
        for (int i = 0; i < minOccurs; ++i) {
            if (args.peek().startsWith("-")) {
                errors.add(new ErrorVisitor.UnexpectedOption(args.peek()));
                return false;
            }
            this.addElement(args, result);
        }
        return true;
    }

    private void addElement(TokenInputStream args, Element result) {
        Element argEl = result.getOwnerDocument().createElementNS("http://cxf.apache.org/Xutil/Command", "argument");
        argEl.setAttribute("name", this.getName());
        if (!args.isOutOfBound()) {
            argEl.appendChild(result.getOwnerDocument().createTextNode(args.read()));
        }
        result.appendChild(argEl);
        ++this.numMatches;
    }

    private boolean isAtleastMinimum() {
        boolean result = true;
        int minOccurs = 0;
        result = !"".equals(this.element.getAttribute("minOccurs")) ? this.numMatches >= Integer.parseInt(this.element.getAttribute("minOccurs")) : this.numMatches >= minOccurs;
        return result;
    }

    private boolean isNoGreaterThanMaximum() {
        boolean result = true;
        if ("unbounded".equals(this.element.getAttribute("maxOccurs")) || "".equals(this.element.getAttribute("maxOccurs"))) {
            return true;
        }
        if (!"".equals(this.element.getAttribute("maxOccurs"))) {
            result = this.numMatches <= Integer.parseInt(this.element.getAttribute("maxOccurs"));
        }
        return result;
    }

    @Override
    public boolean isSatisfied(ErrorVisitor errors) {
        if (errors.getErrors().size() > 0) {
            return false;
        }
        if (!this.isAtleastMinimum()) {
            errors.add(new ErrorVisitor.MissingArgument(this.getName()));
            return false;
        }
        if (!this.isNoGreaterThanMaximum()) {
            errors.add(new ErrorVisitor.DuplicateArgument(this.getName()));
            return false;
        }
        return true;
    }

    public void setToolSpec(ToolSpec toolSpec) {
        this.toolspec = toolSpec;
    }

    public String getName() {
        return this.element.getAttribute("id");
    }

    public String toString() {
        return this.getName();
    }
}

