/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.wsdl11;

import java.util.Map;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.cxf.transport.jms.AddressType;
import org.apache.cxf.transport.jms.DestinationStyleType;
import org.apache.cxf.transport.jms.JMSNamingPropertyType;
import org.apache.cxf.wsdl.AbstractWSDLPlugin;

public class JmsTransportPlugin
extends AbstractWSDLPlugin {
    public static final String NS_JMS_ADDRESS = "http://cxf.apache.org/transports/jms";
    public static final QName JMS_ADDRESS = new QName("http://cxf.apache.org/transports/jms", "address");
    public static final String JMS_ADDR_DEST_STYLE = "destinationStyle";
    public static final String JMS_ADDR_JNDI_URL = "jndiProviderURL";
    public static final String JMS_ADDR_JNDI_FAC = "jndiConnectionFactoryName";
    public static final String JMS_ADDR_JNDI_DEST = "jndiDestinationName";
    public static final String JMS_ADDR_MSG_TYPE = "messageType";
    public static final String JMS_ADDR_INIT_CTX = "initialContextFactory";
    public static final String JMS_ADDR_SUBSCRIBER_NAME = "durableSubscriberName";
    public static final String JMS_ADDR_MSGID_TO_CORRID = "useMessageIDAsCorrelationID";

    @Override
    public ExtensibilityElement createExtension(Map<String, Object> args) throws WSDLException {
        AddressType jmsAddress = null;
        jmsAddress = (AddressType)this.registry.createExtension(Port.class, JMS_ADDRESS);
        String destType = "queue";
        if (this.optionSet(args, JMS_ADDR_DEST_STYLE)) {
            destType = this.getOption(args, JMS_ADDR_DEST_STYLE);
        }
        jmsAddress.setDestinationStyle(DestinationStyleType.fromValue(destType));
        String finitValue = "org.apache.activemq.jndi.ActiveMQInitialContextFactory";
        JMSNamingPropertyType finit = new JMSNamingPropertyType();
        finit.setName("java.naming.factory.initial");
        if (this.optionSet(args, JMS_ADDR_INIT_CTX)) {
            finitValue = this.getOption(args, JMS_ADDR_INIT_CTX);
        }
        finit.setValue(finitValue);
        String providerURL = "tcp://localhost:61616";
        JMSNamingPropertyType provider = new JMSNamingPropertyType();
        provider.setName("java.naming.provider.url");
        if (this.optionSet(args, JMS_ADDR_JNDI_URL)) {
            providerURL = this.getOption(args, JMS_ADDR_JNDI_URL);
        }
        provider.setValue(providerURL);
        String destName = "dynamicQueues/test.cxf.jmstransport.queue";
        if (this.optionSet(args, JMS_ADDR_JNDI_DEST)) {
            destName = this.getOption(args, JMS_ADDR_JNDI_DEST);
        }
        jmsAddress.setJndiDestinationName(destName);
        String factory = "ConnectionFactory";
        if (this.optionSet(args, JMS_ADDR_JNDI_FAC)) {
            factory = this.getOption(args, JMS_ADDR_JNDI_FAC);
        }
        jmsAddress.setJndiConnectionFactoryName(factory);
        jmsAddress.getJMSNamingProperty().add(finit);
        jmsAddress.getJMSNamingProperty().add(provider);
        return jmsAddress;
    }
}

