/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.local;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.io.AbstractWrappedOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.local.LocalConduit;
import org.apache.cxf.transport.local.LocalTransportFactory;
import org.apache.cxf.workqueue.SynchronousExecutor;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class LocalDestination
extends AbstractDestination {
    private static final Logger LOG = LogUtils.getL7dLogger(LocalDestination.class);
    private LocalTransportFactory localDestinationFactory;

    public LocalDestination(LocalTransportFactory localDestinationFactory, EndpointReferenceType epr, EndpointInfo ei) {
        super(epr, ei);
        this.localDestinationFactory = localDestinationFactory;
    }

    @Override
    public void shutdown() {
        this.localDestinationFactory.remove(this);
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    protected Conduit getInbuiltBackChannel(Message inMessage) {
        Conduit conduit = (Conduit)inMessage.get(LocalConduit.IN_CONDUIT);
        if (conduit instanceof LocalConduit) {
            return new SynchronousConduit((LocalConduit)conduit);
        }
        return null;
    }

    class SynchronousConduit
    extends AbstractConduit {
        private LocalConduit conduit;

        public SynchronousConduit(LocalConduit conduit) {
            super(null);
            this.conduit = conduit;
        }

        @Override
        public void prepare(Message message) throws IOException {
            if (!Boolean.TRUE.equals(message.getExchange().get(LocalConduit.DIRECT_DISPATCH))) {
                Exchange exchange = (Exchange)message.getExchange().get(LocalConduit.IN_EXCHANGE);
                LocalDestinationOutputStream cout = new LocalDestinationOutputStream(exchange, message);
                message.setContent(OutputStream.class, cout);
            } else {
                CachedOutputStream stream = new CachedOutputStream();
                message.setContent(OutputStream.class, stream);
                message.setContent(CachedOutputStream.class, stream);
                stream.holdTempFile();
            }
        }

        @Override
        public void close(Message message) throws IOException {
            Integer i = (Integer)message.get(Message.RESPONSE_CODE);
            if (i == null) {
                int code = message.getExchange().isOneWay() && !MessageUtils.isPartialResponse(message) || MessageUtils.isEmptyPartialResponse(message) ? 202 : 200;
                message.put(Message.RESPONSE_CODE, code);
            }
            if (Boolean.TRUE.equals(message.getExchange().get(LocalConduit.DIRECT_DISPATCH))) {
                Exchange exchange = (Exchange)message.getExchange().get(LocalConduit.IN_EXCHANGE);
                MessageImpl copy = new MessageImpl();
                copy.putAll(message);
                message.getContent(OutputStream.class).close();
                CachedOutputStream stream = message.getContent(CachedOutputStream.class);
                message.setContent(OutputStream.class, stream);
                MessageImpl.copyContent(message, copy);
                copy.setContent(InputStream.class, stream.getInputStream());
                stream.releaseTempFileHold();
                if (exchange != null && exchange.getInMessage() == null) {
                    exchange.setInMessage(copy);
                }
                this.conduit.getMessageObserver().onMessage(copy);
                return;
            }
            super.close(message);
        }

        @Override
        protected Logger getLogger() {
            return LOG;
        }

        private final class LocalDestinationOutputStream
        extends AbstractWrappedOutputStream {
            private final Exchange exchange;
            private final Message message;

            private LocalDestinationOutputStream(Exchange exchange, Message message) {
                this.exchange = exchange;
                this.message = message;
            }

            @Override
            public void close() throws IOException {
                if (!this.written) {
                    this.dispatchToClient(true);
                }
                super.close();
            }

            @Override
            protected void onFirstWrite() throws IOException {
                this.dispatchToClient(false);
            }

            protected void dispatchToClient(boolean empty) throws IOException {
                Executor ex;
                final MessageImpl m = new MessageImpl();
                LocalDestination.this.localDestinationFactory.copy(this.message, m);
                if (!empty) {
                    PipedInputStream stream = new PipedInputStream();
                    this.wrappedStream = new PipedOutputStream(stream);
                    m.setContent(InputStream.class, stream);
                }
                Runnable receiver = new Runnable(){

                    @Override
                    public void run() {
                        if (LocalDestinationOutputStream.this.exchange != null) {
                            LocalDestinationOutputStream.this.exchange.setInMessage(m);
                        }
                        SynchronousConduit.this.conduit.getMessageObserver().onMessage(m);
                    }
                };
                Executor executor = ex = this.message.getExchange() != null ? this.message.getExchange().get(Executor.class) : null;
                if (ex == null || SynchronousExecutor.isA(ex)) {
                    ex = LocalDestination.this.localDestinationFactory.getExecutor();
                    if (ex != null) {
                        ex.execute(receiver);
                    } else {
                        new Thread(receiver).start();
                    }
                } else {
                    ex.execute(receiver);
                }
            }
        }
    }
}

