/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.RM10Constants;
import org.apache.cxf.ws.rm.RM11Constants;
import org.apache.cxf.ws.rm.RMProperties;

public final class RMContextUtils {
    protected RMContextUtils() {
    }

    public static String generateUUID() {
        return ContextUtils.generateUUID();
    }

    public static boolean isServerSide(Message message) {
        return message.getExchange().getDestination() != null;
    }

    public static boolean isRMProtocolMessage(String action) {
        return RM10Constants.ACTIONS.contains(action) || RM11Constants.ACTIONS.contains(action);
    }

    public static RMProperties retrieveRMProperties(Message message, boolean outbound) {
        if (outbound) {
            return (RMProperties)message.get(RMContextUtils.getRMPropertiesKey(true));
        }
        Message m = null;
        if (MessageUtils.isOutbound(message)) {
            m = message.getExchange().getInMessage();
            if (null == m) {
                m = message.getExchange().getInFaultMessage();
            }
        } else {
            m = message;
        }
        if (null != m) {
            return (RMProperties)m.get(RMContextUtils.getRMPropertiesKey(false));
        }
        return null;
    }

    public static void storeRMProperties(Message message, RMProperties rmps, boolean outbound) {
        String key = RMContextUtils.getRMPropertiesKey(outbound);
        message.put(key, rmps);
    }

    public static AddressingProperties retrieveMAPs(Message message, boolean isProviderContext, boolean isOutbound) {
        return ContextUtils.retrieveMAPs(message, isProviderContext, isOutbound);
    }

    public static void storeMAPs(AddressingProperties maps, Message message, boolean isOutbound, boolean isRequestor) {
        ContextUtils.storeMAPs(maps, message, isOutbound, isRequestor);
    }

    public static String getRMPropertiesKey(boolean outbound) {
        return outbound ? "org.apache.cxf.ws.rm.outbound" : "org.apache.cxf.ws.rm.inbound";
    }

    public static ProtocolVariation getProtocolVariation(Message message) {
        return (ProtocolVariation)((Object)message.get("org.apache.cxf.ws.rm.protocol"));
    }

    public static void setProtocolVariation(Message message, ProtocolVariation protocol) {
        message.put("org.apache.cxf.ws.rm.protocol", protocol);
    }
}

