/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ASMHelper;
import org.apache.cxf.common.util.CachedClass;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.ReflectionInvokationHandler;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.JavaUtils;
import org.apache.cxf.jaxb.JAXBBeanInfo;
import org.apache.cxf.jaxb.JAXBContextProxy;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXBUtils {
    public static final String JAXB_URI = "http://java.sun.com/xml/ns/jaxb";
    private static final char[] XML_NAME_PUNCTUATION_CHARS = new char[]{'-', '.', ':', '\u00b7', '\u0387', '\u06dd', '\u06de', '_'};
    private static final String XML_NAME_PUNCTUATION_STRING = new String(XML_NAME_PUNCTUATION_CHARS);
    private static final Map<String, String> BUILTIN_DATATYPES_MAP;
    private static final Map<String, Class<?>> HOLDER_TYPES_MAP;
    private static final Logger LOG;
    private static ClassLoader jaxbXjcLoader;

    private JAXBUtils() {
    }

    public static String builtInTypeToJavaType(String type) {
        return BUILTIN_DATATYPES_MAP.get(type);
    }

    public static Class<?> holderClass(String type) {
        return HOLDER_TYPES_MAP.get(type);
    }

    public static boolean isJavaKeyword(String word) {
        return JavaUtils.isJavaKeyword(word);
    }

    public static String namespaceURIToPackage(String namespaceURI) {
        try {
            return JAXBUtils.nameSpaceURIToPackage(new URI(namespaceURI));
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    public static String nameSpaceURIToPackage(URI uri) {
        int index;
        String path;
        StringBuilder packageName = new StringBuilder();
        String authority = uri.getAuthority();
        if (authority == null && "urn".equals(uri.getScheme())) {
            authority = uri.getSchemeSpecificPart();
        }
        if (null != authority && !"".equals(authority)) {
            String token;
            StringTokenizer st;
            if ("urn".equals(uri.getScheme())) {
                packageName.append(authority);
                for (int i = 0; i < packageName.length(); ++i) {
                    if (packageName.charAt(i) != '-') continue;
                    packageName.setCharAt(i, '.');
                }
                authority = packageName.toString();
                packageName.setLength(0);
                st = new StringTokenizer(authority, ":");
                while (st.hasMoreTokens()) {
                    token = st.nextToken();
                    if (packageName.length() > 0) {
                        packageName.insert(0, ".");
                        packageName.insert(0, JAXBUtils.normalizePackageNamePart(token));
                        continue;
                    }
                    packageName.insert(0, token);
                }
                authority = packageName.toString();
                packageName.setLength(0);
            }
            if ((st = new StringTokenizer(authority, ".")).hasMoreTokens()) {
                token = null;
                while (st.hasMoreTokens()) {
                    token = st.nextToken();
                    if (packageName.length() == 0) {
                        if ("www".equals(token)) {
                            continue;
                        }
                    } else {
                        packageName.insert(0, ".");
                    }
                    packageName.insert(0, JAXBUtils.normalizePackageNamePart(token));
                }
            }
        }
        if ((path = uri.getPath()) == null) {
            path = "";
        }
        if ((index = path.lastIndexOf(46)) < 0) {
            index = path.length();
        }
        StringTokenizer st = new StringTokenizer(path.substring(0, index), "/");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (packageName.length() > 0) {
                packageName.append('.');
            }
            packageName.append(JAXBUtils.normalizePackageNamePart(token));
        }
        return packageName.toString();
    }

    private static String normalizePackageNamePart(String name) {
        int i;
        StringBuilder sname = new StringBuilder(name.toLowerCase());
        for (i = 0; i < sname.length(); ++i) {
            sname.setCharAt(i, Character.toLowerCase(sname.charAt(i)));
        }
        for (i = 0; i < sname.length(); ++i) {
            if (Character.isJavaIdentifierPart(sname.charAt(i))) continue;
            sname.setCharAt(i, '_');
        }
        if (JAXBUtils.isJavaKeyword(sname.toString())) {
            sname.insert(0, '_');
        }
        if (!Character.isJavaIdentifierStart(sname.charAt(0))) {
            sname.insert(0, '_');
        }
        return sname.toString();
    }

    public static String nameToIdentifier(String name, IdentifierType type) {
        if (null == name || name.length() == 0) {
            return name;
        }
        boolean legalIdentifier = false;
        StringBuilder buf = new StringBuilder(name);
        legalIdentifier = Character.isJavaIdentifierStart(buf.charAt(0));
        for (int i = 1; i < name.length() && legalIdentifier; ++i) {
            legalIdentifier = legalIdentifier && Character.isJavaIdentifierPart(buf.charAt(i));
        }
        boolean conventionalIdentifier = JAXBUtils.isConventionalIdentifier(buf, type);
        if (legalIdentifier && conventionalIdentifier) {
            if (JAXBUtils.isJavaKeyword(name) && type == IdentifierType.VARIABLE) {
                name = JAXBUtils.normalizePackageNamePart(name.toString());
            }
            return name;
        }
        ArrayList<String> words = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(name, XML_NAME_PUNCTUATION_STRING);
        while (st.hasMoreTokens()) {
            words.add(st.nextToken());
        }
        for (int i = 0; i < words.size(); ++i) {
            JAXBUtils.splitWord(words, i);
        }
        return JAXBUtils.makeConventionalIdentifier(words, type);
    }

    private static void splitWord(List<String> words, int listIndex) {
        String word = words.get(listIndex);
        if (word.length() <= 1) {
            return;
        }
        int index = listIndex + 1;
        StringBuilder sword = new StringBuilder(word);
        int first = 0;
        char firstChar = sword.charAt(first);
        if (Character.isLowerCase(firstChar)) {
            sword.setCharAt(first, Character.toUpperCase(firstChar));
        }
        int i = 1;
        while (i < sword.length()) {
            if (Character.isDigit(firstChar)) {
                while (i < sword.length() && Character.isDigit(sword.charAt(i))) {
                    ++i;
                }
            } else if (JAXBUtils.isCasedLetter(firstChar)) {
                boolean previousIsLower = Character.isLowerCase(firstChar);
                while (!(i >= sword.length() || !JAXBUtils.isCasedLetter(sword.charAt(i)) || Character.isUpperCase(sword.charAt(i)) && previousIsLower)) {
                    previousIsLower = Character.isLowerCase(sword.charAt(i));
                    ++i;
                }
            } else {
                while (i < sword.length() && (JAXBUtils.isMark(sword.charAt(i)) || !JAXBUtils.isCasedLetter(sword.charAt(i)))) {
                    ++i;
                }
            }
            String newWord = sword.substring(first, i);
            words.add(index, newWord);
            ++index;
            if (i >= sword.length()) break;
            first = i;
            firstChar = sword.charAt(first);
        }
        if (index > listIndex + 1) {
            words.remove(listIndex);
        }
    }

    private static boolean isMark(char c) {
        return Character.isJavaIdentifierPart(c) && !Character.isLetter(c) && !Character.isDigit(c);
    }

    private static boolean isCasedLetter(char c) {
        return Character.isUpperCase(c) || Character.isLowerCase(c);
    }

    private static boolean isConventionalIdentifier(StringBuilder buf, IdentifierType type) {
        if (null == buf || buf.length() == 0) {
            return false;
        }
        boolean result = false;
        if (IdentifierType.CONSTANT == type) {
            for (int i = 0; i < buf.length(); ++i) {
                if (!Character.isLowerCase(buf.charAt(i))) continue;
                return false;
            }
            result = true;
        } else if (IdentifierType.VARIABLE == type) {
            result = Character.isLowerCase(buf.charAt(0));
        } else {
            int pos = 3;
            if (!(IdentifierType.GETTER != type || buf.length() >= pos && "get".equals(buf.subSequence(0, 3)))) {
                return false;
            }
            if (!(IdentifierType.SETTER != type || buf.length() >= pos && "set".equals(buf.subSequence(0, 3)))) {
                return false;
            }
            pos = 0;
            result = Character.isUpperCase(buf.charAt(pos));
        }
        return result;
    }

    private static String makeConventionalIdentifier(List<String> words, IdentifierType type) {
        StringBuilder buf = new StringBuilder();
        boolean firstWord = true;
        if (IdentifierType.GETTER == type) {
            buf.append("get");
        } else if (IdentifierType.SETTER == type) {
            buf.append("set");
        }
        for (String w : words) {
            int l = buf.length();
            if (l > 0 && IdentifierType.CONSTANT == type) {
                buf.append('_');
                ++l;
            }
            buf.append(w);
            if (IdentifierType.CONSTANT == type) {
                for (int i = l; i < buf.length(); ++i) {
                    if (!Character.isLowerCase(buf.charAt(i))) continue;
                    buf.setCharAt(i, Character.toUpperCase(buf.charAt(i)));
                }
            } else if (IdentifierType.VARIABLE == type) {
                if (firstWord && Character.isUpperCase(buf.charAt(l))) {
                    buf.setCharAt(l, Character.toLowerCase(buf.charAt(l)));
                }
            } else if (firstWord && Character.isLowerCase(buf.charAt(l))) {
                buf.setCharAt(l, Character.toUpperCase(buf.charAt(l)));
            }
            firstWord = false;
        }
        return buf.toString();
    }

    public static Class<?> getValidClass(Class<?> cls) {
        if (cls.isEnum()) {
            return cls;
        }
        if (cls.isArray()) {
            return cls;
        }
        if (cls == Object.class || cls == String.class || "javax.xml.ws.Holder".equals(cls.getName())) {
            cls = null;
        } else if (cls.isPrimitive() || cls.isAnnotation()) {
            cls = null;
        } else if (cls.isInterface()) {
            return cls;
        }
        if (cls != null) {
            if (cls.getName().equals("javax.xml.ws.wsaddressing.W3CEndpointReference")) {
                return cls;
            }
            try {
                if (cls.getConstructor(new Class[0]) == null) {
                    cls = null;
                }
            }
            catch (NoSuchMethodException ex) {
                cls = null;
            }
        }
        return cls;
    }

    private static synchronized ClassLoader getXJCClassLoader() {
        block6: {
            if (jaxbXjcLoader == null) {
                try {
                    Class.forName("com.sun.tools.internal.xjc.api.XJC");
                    jaxbXjcLoader = ClassLoader.getSystemClassLoader();
                }
                catch (Exception t2) {
                    String s = System.getProperty("java.home");
                    if (StringUtils.isEmpty(s)) break block6;
                    File home = new File(s);
                    File jar = new File(home, "lib/tools.jar");
                    if (!jar.exists()) {
                        jar = new File(home, "../lib/tools.jar");
                    }
                    if (!jar.exists()) break block6;
                    try {
                        jaxbXjcLoader = new URLClassLoader(new URL[]{jar.toURI().toURL()});
                        Class.forName("com.sun.tools.internal.xjc.api.XJC", false, jaxbXjcLoader);
                    }
                    catch (Exception e) {
                        jaxbXjcLoader = null;
                    }
                }
            }
        }
        return jaxbXjcLoader;
    }

    public static JAXBContext createRIContext(Class<?>[] clss, String defaultNS) throws JAXBException {
        try {
            Class<?> cls;
            HashMap<String, String> map;
            block5: {
                map = new HashMap<String, String>();
                try {
                    cls = Class.forName("com.sun.xml.bind.v2.ContextFactory");
                    if (defaultNS != null) {
                        map.put("com.sun.xml.bind.defaultNamespaceRemap", defaultNS);
                    }
                }
                catch (ClassNotFoundException e) {
                    cls = Class.forName("com.sun.xml.internal.bind.v2.ContextFactory", true, JAXBUtils.getXJCClassLoader());
                    if (defaultNS == null) break block5;
                    map.put("com.sun.xml.internal.bind.defaultNamespaceRemap", defaultNS);
                }
            }
            Method meth = cls.getMethod("createContext", clss.getClass(), Map.class);
            return (JAXBContext)meth.invoke(null, clss, map);
        }
        catch (Exception e) {
            throw new JAXBException((Throwable)e);
        }
    }

    public static void setNamespaceWrapper(Map<String, String> nspref, Marshaller marshaller) throws PropertyException {
        Object mapper = null;
        if (marshaller.getClass().getName().contains(".internal.")) {
            mapper = JAXBUtils.createNamespaceWrapper(nspref);
            if (mapper == null) {
                LOG.log(Level.INFO, "Could not create namespace mapper for JDK internal JAXB implementation.");
            } else {
                marshaller.setProperty("com.sun.xml.internal.bind.namespacePrefixMapper", mapper);
            }
        } else {
            try {
                Class<?> cls = Class.forName("org.apache.cxf.jaxb.NamespaceMapper");
                mapper = cls.getConstructor(Map.class).newInstance(nspref);
            }
            catch (Exception ex) {
                LOG.log(Level.INFO, "Could not create NamespaceMapper", ex);
            }
            marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", mapper);
        }
    }

    public static BridgeWrapper createBridge(Set<Class<?>> ctxClasses, QName qname, Class<?> refcls, Annotation[] anns) throws JAXBException {
        try {
            Class<?> refClass;
            Class<?> cls;
            String pkg = "com.sun.xml.bind.";
            try {
                cls = Class.forName("com.sun.xml.bind.api.JAXBRIContext");
                refClass = Class.forName(pkg + "api.TypeReference");
            }
            catch (ClassNotFoundException e) {
                cls = Class.forName("com.sun.xml.internal.bind.api.JAXBRIContext", true, JAXBUtils.getXJCClassLoader());
                pkg = "com.sun.xml.internal.bind.";
                refClass = Class.forName(pkg + "api.TypeReference", true, JAXBUtils.getXJCClassLoader());
            }
            Object ref = refClass.getConstructor(QName.class, Type.class, anns.getClass()).newInstance(qname, refcls, anns);
            ArrayList typeRefs = new ArrayList();
            typeRefs.add(ref);
            ArrayList clses = new ArrayList(ctxClasses);
            clses.add(refClass.getField("type").get(ref).getClass());
            if (!refcls.isInterface()) {
                clses.add(refcls);
            }
            Object ctx = null;
            for (Method m : cls.getDeclaredMethods()) {
                if (!m.getName().equals("newInstance") || m.getParameterTypes().length != 6) continue;
                ctx = m.invoke(null, clses.toArray(new Class[clses.size()]), typeRefs, null, null, true, null);
            }
            Object bridge = ctx.getClass().getMethod("createBridge", refClass).invoke(ctx, ref);
            return ReflectionInvokationHandler.createProxyWrapper(bridge, BridgeWrapper.class);
        }
        catch (Exception ex) {
            throw new JAXBException((Throwable)ex);
        }
    }

    public static SchemaCompiler createSchemaCompiler() throws JAXBException {
        try {
            Object sc = null;
            try {
                Class<?> cls = Class.forName("com.sun.tools.xjc.api.XJC");
                sc = cls.getMethod("createSchemaCompiler", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable e) {
                Class<?> cls = Class.forName("com.sun.tools.internal.xjc.api.XJC", true, JAXBUtils.getXJCClassLoader());
                sc = cls.getMethod("createSchemaCompiler", new Class[0]).invoke(null, new Object[0]);
            }
            return ReflectionInvokationHandler.createProxyWrapper(sc, SchemaCompiler.class);
        }
        catch (Exception ex) {
            throw new JAXBException((Throwable)ex);
        }
    }

    public static Object createFileCodeWriter(File f) throws JAXBException {
        try {
            Class<?> cls;
            try {
                cls = Class.forName("com.sun.codemodel.writer.FileCodeWriter");
            }
            catch (ClassNotFoundException e) {
                cls = Class.forName("com.sun.codemodel.internal.writer.FileCodeWriter", true, JAXBUtils.getXJCClassLoader());
            }
            return cls.getConstructor(File.class).newInstance(f);
        }
        catch (Exception ex) {
            throw new JAXBException((Throwable)ex);
        }
    }

    public static Class<?> getParamClass(SchemaCompiler sc, String method) {
        Object o = ((ReflectionInvokationHandler)Proxy.getInvocationHandler(sc)).getTarget();
        for (Method m : o.getClass().getMethods()) {
            if (!m.getName().equals(method) || m.getParameterTypes().length != 1) continue;
            return m.getParameterTypes()[0];
        }
        return null;
    }

    public static JAXBBeanInfo getBeanInfo(JAXBContextProxy context, Class<?> cls) {
        Object o = context.getBeanInfo(cls);
        if (o == null) {
            return null;
        }
        return ReflectionInvokationHandler.createProxyWrapper(o, JAXBBeanInfo.class);
    }

    public static List<DOMResult> generateJaxbSchemas(JAXBContext context, final Map<String, DOMResult> builtIns) throws IOException {
        final ArrayList<DOMResult> results = new ArrayList<DOMResult>();
        context.generateSchema(new SchemaOutputResolver(){

            public Result createOutput(String ns, String file) throws IOException {
                DOMResult result = new DOMResult();
                if (builtIns.containsKey(ns)) {
                    DOMResult dr = (DOMResult)builtIns.get(ns);
                    result.setSystemId(dr.getSystemId());
                    results.add(dr);
                    return result;
                }
                result.setSystemId(file);
                results.add(result);
                return result;
            }
        });
        return results;
    }

    public static String getPackageNamespace(Class<?> cls) {
        XmlSchema schemaAnn;
        Package p = Package.getPackage(PackageUtils.getPackageName(cls));
        if (p != null && (schemaAnn = p.getAnnotation(XmlSchema.class)) != null) {
            return schemaAnn.namespace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public static void scanPackages(Set<Class<?>> classes, Map<Package, CachedClass> objectFactoryCache) {
        Object pkg;
        HashMap<String, InputStream> packages = new HashMap<String, InputStream>();
        HashMap<String, ClassLoader> packageLoaders = new HashMap<String, ClassLoader>();
        HashSet objectFactories = new HashSet();
        for (Class<?> jcls : classes) {
            String pkgName = PackageUtils.getPackageName(jcls);
            if (packages.containsKey(pkgName)) continue;
            pkg = jcls.getPackage();
            packages.put(pkgName, jcls.getResourceAsStream("jaxb.index"));
            packageLoaders.put(pkgName, jcls.getClassLoader());
            String objectFactoryClassName = pkgName + "." + "ObjectFactory";
            Class<?> ofactory = null;
            CachedClass cachedFactory = null;
            if (pkg != null && objectFactoryCache != null) {
                Map<Package, CachedClass> map = objectFactoryCache;
                synchronized (map) {
                    cachedFactory = objectFactoryCache.get(pkg);
                }
            }
            if (cachedFactory != null) {
                ofactory = cachedFactory.getCachedClass();
            }
            if (ofactory == null) {
                try {
                    ofactory = Class.forName(objectFactoryClassName, false, jcls.getClassLoader());
                    objectFactories.add(ofactory);
                    JAXBUtils.addToObjectFactoryCache((Package)pkg, ofactory, objectFactoryCache);
                }
                catch (ClassNotFoundException e) {
                    JAXBUtils.addToObjectFactoryCache((Package)pkg, null, objectFactoryCache);
                }
                continue;
            }
            objectFactories.add(ofactory);
        }
        for (Map.Entry entry : packages.entrySet()) {
            if (entry.getValue() == null) continue;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)entry.getValue(), "UTF-8"));
            pkg = (String)entry.getKey();
            ClassLoader loader = (ClassLoader)packageLoaders.get(pkg);
            if (!StringUtils.isEmpty((String)pkg)) {
                pkg = (String)pkg + ".";
            }
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).indexOf("#") != -1) {
                    line = line.substring(0, line.indexOf("#"));
                }
                if (!StringUtils.isEmpty(line)) {
                    try {
                        Class<?> ncls = Class.forName((String)pkg + line, false, loader);
                        classes.add(ncls);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                line = reader.readLine();
            }
            Object var15_17 = null;
            try {
                ((InputStream)entry.getValue()).close();
            }
            catch (Exception e2) {}
            continue;
            {
                catch (Exception e) {
                    var15_17 = null;
                    try {
                        ((InputStream)entry.getValue()).close();
                    }
                    catch (Exception e2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var15_17 = null;
                try {
                    ((InputStream)entry.getValue()).close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        classes.addAll(objectFactories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToObjectFactoryCache(Package objectFactoryPkg, Class<?> ofactory, Map<Package, CachedClass> objectFactoryCache) {
        if (objectFactoryPkg == null || objectFactoryCache == null) {
            return;
        }
        Map<Package, CachedClass> map = objectFactoryCache;
        synchronized (map) {
            objectFactoryCache.put(objectFactoryPkg, new CachedClass(ofactory));
        }
    }

    private static synchronized Object createNamespaceWrapper(Map<String, String> map) {
        ASMHelper helper = new ASMHelper();
        String className = "org.apache.cxf.jaxb.NamespaceMapperInternal";
        Class<?> cls = helper.findClass(className, JAXBUtils.class);
        if (cls == null) {
            ClassWriter cw = helper.createClassWriter();
            if (cw == null) {
                return null;
            }
            cls = JAXBUtils.createNamespaceWrapperInternal(helper, cw);
        }
        try {
            return cls.getConstructor(Map.class).newInstance(map);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Class<?> createNamespaceWrapperInternal(ASMHelper helper, ClassWriter cw) {
        Class<Object> cls;
        String className = "org.apache.cxf.jaxb.NamespaceMapperInternal";
        cw.visit(49, 49, "org/apache/cxf/jaxb/NamespaceMapperInternal", null, "com/sun/xml/internal/bind/marshaller/NamespacePrefixMapper", null);
        cw.visitSource("NamespaceMapper.java", null);
        FieldVisitor fv = cw.visitField(18, "nspref", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/String;Ljava/lang/String;>;", null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Ljava/util/Map;)V", "(Ljava/util/Map<Ljava/lang/String;Ljava/lang/String;>;)V", null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(30, l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "com/sun/xml/internal/bind/marshaller/NamespacePrefixMapper", "<init>", "()V");
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLineNumber(31, l1);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, "org/apache/cxf/jaxb/NamespaceMapperInternal", "nspref", "Ljava/util/Map;");
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLineNumber(32, l2);
        mv.visitInsn(177);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitLocalVariable("this", "Lorg/apache/cxf/jaxb/NamespaceMapperInternal;", null, l0, l3, 0);
        mv.visitLocalVariable("nspref", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/String;Ljava/lang/String;>;", l0, l3, 1);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getPreferredPrefix", "(Ljava/lang/String;Ljava/lang/String;Z)Ljava/lang/String;", null, null);
        mv.visitCode();
        l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(38, l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "org/apache/cxf/jaxb/NamespaceMapperInternal", "nspref", "Ljava/util/Map;");
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitTypeInsn(192, "java/lang/String");
        mv.visitVarInsn(58, 4);
        l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLineNumber(39, l1);
        mv.visitVarInsn(25, 4);
        l2 = new Label();
        mv.visitJumpInsn(198, l2);
        l3 = new Label();
        mv.visitLabel(l3);
        mv.visitLineNumber(40, l3);
        mv.visitVarInsn(25, 4);
        mv.visitInsn(176);
        mv.visitLabel(l2);
        mv.visitLineNumber(42, l2);
        mv.visitVarInsn(25, 2);
        mv.visitInsn(176);
        Label l4 = new Label();
        mv.visitLabel(l4);
        mv.visitLocalVariable("this", "Lorg/apache/cxf/jaxb/NamespaceMapperInternal;", null, l0, l4, 0);
        mv.visitLocalVariable("namespaceUri", "Ljava/lang/String;", null, l0, l4, 1);
        mv.visitLocalVariable("suggestion", "Ljava/lang/String;", null, l0, l4, 2);
        mv.visitLocalVariable("requirePrefix", "Z", null, l0, l4, 3);
        mv.visitLocalVariable("prefix", "Ljava/lang/String;", null, l1, l4, 4);
        mv.visitMaxs(2, 5);
        mv.visitEnd();
        cw.visitEnd();
        byte[] bts = cw.toByteArray();
        try {
            cls = Class.forName("com.sun.xml.bind.api.JAXBRIContext");
        }
        catch (ClassNotFoundException e) {
            try {
                cls = Class.forName("com.sun.xml.internal.bind.api.JAXBRIContext", true, JAXBUtils.getXJCClassLoader());
            }
            catch (ClassNotFoundException e1) {
                cls = JAXBUtils.class;
            }
        }
        return helper.loadClass(className, cls, bts);
    }

    static {
        LOG = LogUtils.getL7dLogger(JAXBUtils.class, "CommonUtilityMessages");
        BUILTIN_DATATYPES_MAP = new HashMap<String, String>();
        BUILTIN_DATATYPES_MAP.put("string", "java.lang.String");
        BUILTIN_DATATYPES_MAP.put("integer", "java.math.BigInteger");
        BUILTIN_DATATYPES_MAP.put("int", "int");
        BUILTIN_DATATYPES_MAP.put("long", "long");
        BUILTIN_DATATYPES_MAP.put("short", "short");
        BUILTIN_DATATYPES_MAP.put("decimal", "java.math.BigDecimal");
        BUILTIN_DATATYPES_MAP.put("float", "float");
        BUILTIN_DATATYPES_MAP.put("double", "double");
        BUILTIN_DATATYPES_MAP.put("boolean", "boolean");
        BUILTIN_DATATYPES_MAP.put("byte", "byte");
        BUILTIN_DATATYPES_MAP.put("QName", "javax.xml.namespace.QName");
        BUILTIN_DATATYPES_MAP.put("dateTime", "javax.xml.datatype.XMLGregorianCalendar");
        BUILTIN_DATATYPES_MAP.put("base64Binary", "byte[]");
        BUILTIN_DATATYPES_MAP.put("hexBinary", "byte[]");
        BUILTIN_DATATYPES_MAP.put("unsignedInt", "long");
        BUILTIN_DATATYPES_MAP.put("unsignedShort", "short");
        BUILTIN_DATATYPES_MAP.put("unsignedByte", "byte");
        BUILTIN_DATATYPES_MAP.put("time", "javax.xml.datatype.XMLGregorianCalendar");
        BUILTIN_DATATYPES_MAP.put("date", "javax.xml.datatype.XMLGregorianCalendar");
        BUILTIN_DATATYPES_MAP.put("gYear", "javax.xml.datatype.XMLGregorianCalendar");
        BUILTIN_DATATYPES_MAP.put("gYearMonth", "javax.xml.datatype.XMLGregorianCalendar");
        BUILTIN_DATATYPES_MAP.put("gMonth", "javax.xml.datatype.XMLGregorianCalendar");
        BUILTIN_DATATYPES_MAP.put("gMonthDay", "javax.xml.datatype.XMLGregorianCalendar");
        BUILTIN_DATATYPES_MAP.put("gDay", "javax.xml.datatype.XMLGregorianCalendar");
        BUILTIN_DATATYPES_MAP.put("duration", "javax.xml.datatype.Duration");
        BUILTIN_DATATYPES_MAP.put("NOTATION", "javax.xml.namespace.QName");
        BUILTIN_DATATYPES_MAP.put("string", "java.lang.String");
        HOLDER_TYPES_MAP = new HashMap();
        HOLDER_TYPES_MAP.put("int", Integer.class);
        HOLDER_TYPES_MAP.put("long", Long.class);
        HOLDER_TYPES_MAP.put("short", Short.class);
        HOLDER_TYPES_MAP.put("float", Float.class);
        HOLDER_TYPES_MAP.put("double", Double.class);
        HOLDER_TYPES_MAP.put("boolean", Boolean.class);
        HOLDER_TYPES_MAP.put("byte", Byte.class);
    }

    public static interface JDefinedClass {
        public String name();

        public String fullName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface JPackage {
        public String name();

        @ReflectionInvokationHandler.WrapReturn(value=JDefinedClass.class, iterator=true)
        public Iterator<JDefinedClass> classes();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface JCodeModel {
        public void build(Object var1) throws IOException;

        @ReflectionInvokationHandler.WrapReturn(value=JPackage.class, iterator=true)
        public Iterator<JPackage> packages();
    }

    public static interface Options {
        public void addGrammar(InputSource var1);

        public void addBindFile(InputSource var1);

        public String getBuildID();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface JType {
        public boolean isArray();

        @ReflectionInvokationHandler.WrapReturn(value=JType.class)
        public JType elementType();

        public boolean isPrimitive();

        public String binaryName();

        public String fullName();

        public String name();

        @ReflectionInvokationHandler.WrapReturn(value=JType.class, iterator=true)
        public Iterator<JType> classes();
    }

    public static interface TypeAndAnnotation {
        @ReflectionInvokationHandler.WrapReturn(value=JType.class)
        public JType getTypeClass();
    }

    public static interface Mapping {
        @ReflectionInvokationHandler.WrapReturn(value=TypeAndAnnotation.class)
        public TypeAndAnnotation getType();
    }

    public static interface S2JJAXBModel {
        @ReflectionInvokationHandler.WrapReturn(value=JCodeModel.class)
        public JCodeModel generateCode(Object var1, Object var2);

        @ReflectionInvokationHandler.WrapReturn(value=Mapping.class)
        public Mapping get(QName var1);

        @ReflectionInvokationHandler.WrapReturn(value=TypeAndAnnotation.class)
        public TypeAndAnnotation getJavaType(QName var1);
    }

    public static interface SchemaCompiler {
        public void setErrorListener(Object var1);

        public void setClassNameAllocator(Object var1);

        @ReflectionInvokationHandler.WrapReturn(value=S2JJAXBModel.class)
        public S2JJAXBModel bind();

        public void parseSchema(InputSource var1);

        public void parseSchema(String var1, Element var2);

        @ReflectionInvokationHandler.WrapReturn(value=Options.class)
        public Options getOptions();
    }

    public static interface BridgeWrapper {
        public Object unmarshal(XMLStreamReader var1, AttachmentUnmarshaller var2) throws JAXBException;

        public Object unmarshal(InputStream var1) throws JAXBException;

        public Object unmarshal(Node var1, AttachmentUnmarshaller var2) throws JAXBException;

        public void marshal(Object var1, XMLStreamWriter var2, AttachmentMarshaller var3) throws JAXBException;

        public void marshal(Object var1, StreamResult var2) throws JAXBException;

        public void marshal(Object var1, Node var2, AttachmentMarshaller var3) throws JAXBException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IdentifierType {
        CLASS,
        INTERFACE,
        GETTER,
        SETTER,
        VARIABLE,
        CONSTANT;

    }
}

