/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.micrometer;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.tracing.micrometer.CxfObservationDocumentation;

final class CxfObservationConventionUtil {
    private static final Logger LOG = LogUtils.getL7dLogger(CxfObservationConventionUtil.class);

    private CxfObservationConventionUtil() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    static KeyValues getLowCardinalityKeyValues(Message msg) {
        String endpointAdress;
        KeyValue rpcSystem = CxfObservationDocumentation.LowCardinalityKeys.RPC_SYSTEM.withValue("cxf");
        KeyValue rpcService = CxfObservationDocumentation.LowCardinalityKeys.RPC_SERVICE.withValue(msg.getExchange().getService().getName().getLocalPart());
        KeyValues keyValues = KeyValues.of((KeyValue[])new KeyValue[]{rpcSystem, rpcService});
        BindingOperationInfo bindingOperationInfo = msg.getExchange().getBindingOperationInfo();
        if (bindingOperationInfo != null) {
            keyValues = keyValues.and(new KeyValue[]{CxfObservationDocumentation.LowCardinalityKeys.RPC_METHOD.withValue(bindingOperationInfo.getName().getLocalPart())});
        }
        if ((endpointAdress = CxfObservationConventionUtil.url(msg)) != null) {
            try {
                URI uri = URI.create(endpointAdress);
                KeyValue serverAddress = CxfObservationDocumentation.LowCardinalityKeys.SERVER_ADDRESS.withValue(uri.getHost());
                KeyValue serverPort = CxfObservationDocumentation.LowCardinalityKeys.SERVER_PORT.withValue(String.valueOf(uri.getPort()));
                return keyValues.and(new KeyValue[]{serverAddress, serverPort});
            }
            catch (Exception ex) {
                LOG.log(Level.FINE, ex, () -> "Exception occurred while trying to parse the URI from [" + endpointAdress + "] address");
                return keyValues;
            }
        }
        return keyValues;
    }

    private static String url(Message message) {
        String address = (String)message.getExchange().get((Object)Message.ENDPOINT_ADDRESS);
        if (address != null) {
            return address;
        }
        return (String)message.get((Object)"org.apache.cxf.request.url");
    }

    static String getContextualName(Exchange exchange) {
        BindingOperationInfo bindingOperationInfo = exchange.getBindingOperationInfo();
        if (bindingOperationInfo != null) {
            String serviceName = bindingOperationInfo.getBinding().getService().getName().getLocalPart();
            String operationName = bindingOperationInfo.getOperationInfo().getName().getLocalPart();
            return serviceName + "/" + operationName;
        }
        if (exchange.getOutMessage() != null) {
            return (String)exchange.getOutMessage().get((Object)"org.apache.cxf.request.method");
        }
        return null;
    }
}

