/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.BusFactory;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transport.servlet.AbstractHTTPServlet;
import org.apache.cxf.transport.servlet.ServletContextResourceResolver;
import org.apache.cxf.transport.servlet.ServletController;
import org.apache.cxf.transport.servlet.servicelist.ServiceListGeneratorServlet;

public class CXFNonSpringServlet
extends AbstractHTTPServlet {
    private DestinationRegistry destinationRegistry;
    private Bus bus;
    private ServletController controller;

    public CXFNonSpringServlet() {
    }

    public CXFNonSpringServlet(DestinationRegistry destinationRegistry) {
        this.destinationRegistry = destinationRegistry;
    }

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        if (this.bus == null) {
            this.loadBus(sc);
        }
        ResourceManager resourceManager = (ResourceManager)this.bus.getExtension(ResourceManager.class);
        resourceManager.addResourceResolver((ResourceResolver)new ServletContextResourceResolver(sc.getServletContext()));
        if (this.destinationRegistry == null) {
            this.destinationRegistry = CXFNonSpringServlet.getDestinationRegistryFromBus(this.bus);
        }
        this.controller = this.createServletController(sc);
    }

    private static DestinationRegistry getDestinationRegistryFromBus(Bus bus) {
        DestinationFactoryManager dfm = (DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class);
        try {
            DestinationFactory df = dfm.getDestinationFactory("http://cxf.apache.org/transports/http/configuration");
            if (df instanceof HTTPTransportFactory) {
                HTTPTransportFactory transportFactory = (HTTPTransportFactory)df;
                return transportFactory.getRegistry();
            }
        }
        catch (BusException busException) {
            // empty catch block
        }
        return null;
    }

    protected void loadBus(ServletConfig sc) {
        this.bus = BusFactory.newInstance().createBus();
    }

    private ServletController createServletController(ServletConfig servletConfig) {
        ServiceListGeneratorServlet serviceListGeneratorServlet = new ServiceListGeneratorServlet(this.destinationRegistry, this.bus);
        ServletController newController = new ServletController(this.destinationRegistry, servletConfig, serviceListGeneratorServlet);
        return newController;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invoke(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader loader = (ClassLoader)this.bus.getExtension(ClassLoader.class);
            if (loader != null) {
                Thread.currentThread().setContextClassLoader(loader);
            }
            BusFactory.setThreadDefaultBus((Bus)this.bus);
            this.controller.invoke(request, response);
        }
        finally {
            BusFactory.setThreadDefaultBus(null);
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }
}

