/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.WSSPolicyException;
import org.apache.cxf.ws.security.policy.custom.AlgorithmSuiteLoader;
import org.apache.cxf.ws.security.policy.custom.DefaultAlgorithmSuiteLoader;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AlgorithmSuiteBuilder
implements AssertionBuilder<Element> {
    private Bus bus;

    public AlgorithmSuiteBuilder(Bus bus) {
        this.bus = bus;
    }

    public Assertion build(Element element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        Element policyElement;
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        AlgorithmSuiteLoader loader = (AlgorithmSuiteLoader)this.bus.getExtension(AlgorithmSuiteLoader.class);
        if (loader == null) {
            loader = new DefaultAlgorithmSuiteLoader();
        }
        if ((policyElement = DOMUtils.getFirstElement((Node)element)) == null) {
            throw new IllegalArgumentException("sp:AlgorithmSuite/wsp:Policy must have a value");
        }
        AlgorithmSuite algorithmSuite = null;
        try {
            algorithmSuite = loader.getAlgorithmSuite(policyElement, consts);
        }
        catch (WSSPolicyException e) {
            throw new IllegalArgumentException((Throwable)((Object)e));
        }
        if (algorithmSuite == null && consts != SP11Constants.INSTANCE) {
            String algorithmSuiteName = DOMUtils.getFirstElement((Node)policyElement).getLocalName();
            throw new IllegalArgumentException("Algorithm suite \"" + algorithmSuiteName + "\" is not registered");
        }
        return algorithmSuite;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.ALGORITHM_SUITE, SP12Constants.ALGORITHM_SUITE};
    }
}

