/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.interceptors;

import java.util.Collection;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.security.policy.SP12Constants;

public class SecurityVerificationOutInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    public static final SecurityVerificationOutInterceptor INSTANCE = new SecurityVerificationOutInterceptor();
    private static final Logger LOG = LogUtils.getL7dLogger(SecurityVerificationOutInterceptor.class);

    public SecurityVerificationOutInterceptor() {
        super("pre-logical");
    }

    public void handleMessage(SoapMessage message) throws Fault {
        AssertionInfoMap aim;
        if (MessageUtils.isRequestor((Message)message) && (aim = (AssertionInfoMap)message.get(AssertionInfoMap.class)) != null) {
            Collection aisTransport = (Collection)aim.get((Object)SP12Constants.TRANSPORT_BINDING);
            Collection aisAssymetric = (Collection)aim.get((Object)SP12Constants.ASYMMETRIC_BINDING);
            Collection aisSymetric = (Collection)aim.get((Object)SP12Constants.SYMMETRIC_BINDING);
            if (!(aisTransport != null && !aisTransport.isEmpty() || aisAssymetric != null && !aisAssymetric.isEmpty() || aisSymetric != null && !aisSymetric.isEmpty())) {
                Collection aisSignedParts = (Collection)aim.get((Object)SP12Constants.SIGNED_PARTS);
                this.checkAssertion(aisSignedParts, SP12Constants.SIGNED_PARTS);
                Collection aisSignedElements = (Collection)aim.get((Object)SP12Constants.SIGNED_ELEMENTS);
                this.checkAssertion(aisSignedElements, SP12Constants.SIGNED_ELEMENTS);
                Collection aisEncryptedParts = (Collection)aim.get((Object)SP12Constants.ENCRYPTED_PARTS);
                this.checkAssertion(aisEncryptedParts, SP12Constants.ENCRYPTED_PARTS);
                Collection aisEncryptedElements = (Collection)aim.get((Object)SP12Constants.ENCRYPTED_ELEMENTS);
                this.checkAssertion(aisEncryptedElements, SP12Constants.ENCRYPTED_ELEMENTS);
                Collection aisContentEncryptedElements = (Collection)aim.get((Object)SP12Constants.CONTENT_ENCRYPTED_ELEMENTS);
                this.checkAssertion(aisContentEncryptedElements, SP12Constants.CONTENT_ENCRYPTED_ELEMENTS);
            }
        }
    }

    private void checkAssertion(Collection<AssertionInfo> ais, QName assertion) {
        if (ais != null && !ais.isEmpty()) {
            String error = String.format("%s assertion cannot be fulfilled without binding. At least one binding assertion (%s, %s, %s) must be specified in policy.", assertion.getLocalPart(), SP12Constants.TRANSPORT_BINDING.getLocalPart(), SP12Constants.ASYMMETRIC_BINDING.getLocalPart(), SP12Constants.SYMMETRIC_BINDING.getLocalPart());
            AssertionInfo info = ais.iterator().next();
            info.setNotAsserted(error);
            LOG.severe(error);
            throw new PolicyException(info);
        }
    }
}

