/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.audit;

import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.logging.Level;
import org.apache.deltaspike.data.api.audit.CreatedOn;
import org.apache.deltaspike.data.api.audit.ModifiedOn;
import org.apache.deltaspike.data.impl.audit.AuditPropertyException;
import org.apache.deltaspike.data.impl.audit.AuditProvider;
import org.apache.deltaspike.data.impl.property.Property;
import org.apache.deltaspike.data.impl.property.query.AnnotatedPropertyCriteria;
import org.apache.deltaspike.data.impl.property.query.PropertyQueries;
import org.apache.deltaspike.data.impl.property.query.PropertyQuery;

class TimestampsProvider
extends AuditProvider {
    TimestampsProvider() {
    }

    @Override
    public void prePersist(Object entity) {
        this.updateTimestamps(entity, true);
    }

    @Override
    public void preUpdate(Object entity) {
        this.updateTimestamps(entity, false);
    }

    private void updateTimestamps(Object entity, boolean create) {
        long systime = System.currentTimeMillis();
        LinkedList properties = new LinkedList();
        PropertyQuery query = PropertyQueries.createQuery(entity.getClass()).addCriteria(new AnnotatedPropertyCriteria(ModifiedOn.class));
        properties.addAll(query.getWritableResultList());
        if (create) {
            query = PropertyQueries.createQuery(entity.getClass()).addCriteria(new AnnotatedPropertyCriteria(CreatedOn.class));
            properties.addAll(query.getWritableResultList());
        }
        for (Property property : properties) {
            this.setProperty(entity, property, systime, create);
        }
    }

    private void setProperty(Object entity, Property<Object> property, long systime, boolean create) {
        try {
            if (!this.isCorrectContext(property, create)) {
                return;
            }
            Object now = this.now(property.getJavaClass(), systime);
            property.setValue(entity, now);
            log.log(Level.FINER, "Updated property {0} with {1}", new Object[]{this.propertyName(entity, property), now});
        }
        catch (Exception e) {
            String message = "Failed to set property " + this.propertyName(entity, property) + ", is this a temporal type?";
            throw new AuditPropertyException(message, e);
        }
    }

    private boolean isCorrectContext(Property<Object> property, boolean create) {
        ModifiedOn annotation;
        return !create || !property.getAnnotatedElement().isAnnotationPresent(ModifiedOn.class) || (annotation = property.getAnnotatedElement().getAnnotation(ModifiedOn.class)).onCreate();
    }

    private Object now(Class<?> field, long systime) throws Exception {
        if (this.isCalendarClass(field)) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(systime);
            return cal;
        }
        if (this.isDateClass(field)) {
            return field.getConstructor(Long.TYPE).newInstance(systime);
        }
        throw new IllegalArgumentException("Annotated field is not a date class: " + field);
    }

    private boolean isCalendarClass(Class<?> field) {
        return Calendar.class.isAssignableFrom(field);
    }

    private boolean isDateClass(Class<?> field) {
        return Date.class.isAssignableFrom(field);
    }
}

