/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.graph;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.persistence.EntityManager;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ExceptionUtils;
import org.apache.deltaspike.data.api.EntityGraph;
import org.apache.deltaspike.data.impl.graph.EntityGraphException;

public final class EntityGraphHelper {
    private static final Class<?> ENTITY_GRAPH_CLASS = ClassUtils.tryToLoadClassForName((String)"javax.persistence.EntityGraph");
    private static final Class<?> SUBGRAPH_CLASS = ClassUtils.tryToLoadClassForName((String)"javax.persistence.Subgraph");
    private static final Method EG_ADD_ATTRIBUTE_NODES;
    private static final Method EG_ADD_SUBGRAPH;
    private static final Method SUBGRAPH_ADD_ATTRIBUTE_NODES;
    private static final Method SUBGRAPH_ADD_SUBGRAPH;
    private static final Method EM_GET_ENTITY_GRAPH;
    private static final Method EM_CREATE_ENTITY_GRAPH;

    private EntityGraphHelper() {
    }

    public static boolean isAvailable() {
        return ENTITY_GRAPH_CLASS != null;
    }

    private static Object uncheckedInvoke(Method method, Object target, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException e) {
            throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw ExceptionUtils.throwAsRuntimeException((Throwable)e.getCause());
        }
    }

    public static Object getEntityGraph(EntityManager em, Class<?> entityClass, EntityGraph entityGraphAnn) {
        EntityGraphHelper.ensureAvailable();
        String graphName = entityGraphAnn.value();
        if (graphName.isEmpty()) {
            return EntityGraphHelper.buildEntityGraph(em, entityClass, entityGraphAnn.paths());
        }
        return EntityGraphHelper.uncheckedInvoke(EM_GET_ENTITY_GRAPH, em, graphName);
    }

    private static Object createEntityGraph(EntityManager em, Class<?> entityClass) {
        return EntityGraphHelper.uncheckedInvoke(EM_CREATE_ENTITY_GRAPH, em, entityClass);
    }

    private static void ensureAvailable() {
        if (!EntityGraphHelper.isAvailable()) {
            throw new EntityGraphException("Class java.persistence.EntityGraph is not available. Does your PersistenceProvider support JPA 2.1?");
        }
    }

    private static Object addSubgraph(Object graph, String attributeName) {
        if (ENTITY_GRAPH_CLASS.isInstance(graph)) {
            return EntityGraphHelper.uncheckedInvoke(EG_ADD_SUBGRAPH, graph, attributeName);
        }
        if (SUBGRAPH_CLASS.isInstance(graph)) {
            return EntityGraphHelper.uncheckedInvoke(SUBGRAPH_ADD_SUBGRAPH, graph, attributeName);
        }
        return null;
    }

    private static void addAttributeNodes(Object graph, String attributeName) {
        if (ENTITY_GRAPH_CLASS.isInstance(graph)) {
            EntityGraphHelper.uncheckedInvoke(EG_ADD_ATTRIBUTE_NODES, graph, new Object[]{new String[]{attributeName}});
        } else if (SUBGRAPH_CLASS.isInstance(graph)) {
            EntityGraphHelper.uncheckedInvoke(SUBGRAPH_ADD_ATTRIBUTE_NODES, graph, new Object[]{new String[]{attributeName}});
        }
    }

    private static Object buildEntityGraph(EntityManager em, Class<?> entityClass, String[] attributePaths) {
        Object graph = EntityGraphHelper.createEntityGraph(em, entityClass);
        ArrayList<String> paths = new ArrayList<String>(Arrays.asList(attributePaths));
        Collections.sort(paths);
        Collections.reverse(paths);
        for (String path : attributePaths) {
            if (path.contains(".")) {
                String[] segments = path.split("\\.");
                Object parent = EntityGraphHelper.addSubgraph(graph, segments[0]);
                for (int i = 1; i < segments.length - 1; ++i) {
                    EntityGraphHelper.addSubgraph(parent, segments[i]);
                }
                EntityGraphHelper.addAttributeNodes(parent, segments[segments.length - 1]);
                continue;
            }
            EntityGraphHelper.addAttributeNodes(graph, path);
        }
        return graph;
    }

    static {
        if (ENTITY_GRAPH_CLASS == null) {
            EG_ADD_ATTRIBUTE_NODES = null;
            EG_ADD_SUBGRAPH = null;
            SUBGRAPH_ADD_ATTRIBUTE_NODES = null;
            SUBGRAPH_ADD_SUBGRAPH = null;
            EM_GET_ENTITY_GRAPH = null;
            EM_CREATE_ENTITY_GRAPH = null;
        } else {
            try {
                EG_ADD_ATTRIBUTE_NODES = ENTITY_GRAPH_CLASS.getMethod("addAttributeNodes", String[].class);
                EG_ADD_SUBGRAPH = ENTITY_GRAPH_CLASS.getMethod("addSubgraph", String.class);
                SUBGRAPH_ADD_ATTRIBUTE_NODES = SUBGRAPH_CLASS.getMethod("addAttributeNodes", String[].class);
                SUBGRAPH_ADD_SUBGRAPH = SUBGRAPH_CLASS.getMethod("addSubgraph", String.class);
                EM_GET_ENTITY_GRAPH = EntityManager.class.getMethod("getEntityGraph", String.class);
                EM_CREATE_ENTITY_GRAPH = EntityManager.class.getMethod("createEntityGraph", Class.class);
            }
            catch (NoSuchMethodException e) {
                throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }
    }
}

