/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.meta;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.deltaspike.data.impl.RepositoryDefinitionException;
import org.apache.deltaspike.data.impl.meta.RepositoryComponent;
import org.apache.deltaspike.data.impl.meta.RepositoryEntity;
import org.apache.deltaspike.data.impl.meta.RepositoryMethod;
import org.apache.deltaspike.data.impl.meta.extractor.AnnotationMetadataExtractor;
import org.apache.deltaspike.data.impl.meta.extractor.MetadataExtractor;
import org.apache.deltaspike.data.impl.meta.extractor.TypeMetadataExtractor;

public class RepositoryComponents {
    private final Map<Class<?>, RepositoryComponent> repos = new ConcurrentHashMap();
    private final List<MetadataExtractor> extractors = Arrays.asList(new AnnotationMetadataExtractor(), new TypeMetadataExtractor());

    public void add(Class<?> repoClass) {
        RepositoryEntity entityClass = this.extractEntityMetaData(repoClass);
        RepositoryComponent repo = new RepositoryComponent(repoClass, entityClass);
        this.repos.put(repoClass, repo);
    }

    public RepositoryComponent lookupComponent(List<Class<?>> candidateClasses) {
        for (Class<?> repoClass : candidateClasses) {
            if (!this.repos.containsKey(repoClass)) continue;
            return this.repos.get(repoClass);
        }
        throw new RuntimeException("Unknown Repository classes " + candidateClasses);
    }

    public RepositoryComponent lookupComponent(Class<?> repoClass) {
        if (this.repos.containsKey(repoClass)) {
            return this.repos.get(repoClass);
        }
        throw new RuntimeException("Unknown Repository class " + repoClass.getName());
    }

    public RepositoryMethod lookupMethod(Class<?> repoClass, Method method) {
        return this.lookupComponent(repoClass).lookupMethod(method);
    }

    private RepositoryEntity extractEntityMetaData(Class<?> repoClass) {
        for (MetadataExtractor extractor : this.extractors) {
            RepositoryEntity entity = extractor.extract(repoClass);
            if (entity == null) continue;
            return entity;
        }
        throw new RepositoryDefinitionException(repoClass);
    }

    public Map<Class<?>, RepositoryComponent> getRepositories() {
        return this.repos;
    }

    public void addAll(Map<Class<?>, RepositoryComponent> repositories) {
        this.repos.putAll(repositories);
    }
}

