/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.cdise.tck;

import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.deltaspike.cdise.api.CdiContainer;
import org.apache.deltaspike.cdise.api.CdiContainerLoader;
import org.apache.deltaspike.cdise.api.ContextControl;
import org.apache.deltaspike.cdise.tck.beans.Car;
import org.apache.deltaspike.cdise.tck.beans.CarRepair;
import org.apache.deltaspike.cdise.tck.beans.TestUser;
import org.apache.deltaspike.cdise.tck.control.LockedCDIImplementation;
import org.apache.deltaspike.cdise.tck.control.LockedVersionRange;
import org.apache.deltaspike.cdise.tck.control.VersionControlRule;
import org.apache.deltaspike.test.utils.CdiImplementation;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class ContainerCtrlTckTest {
    private static final Logger log = Logger.getLogger(ContainerCtrlTckTest.class.getName());
    private static final int NUM_THREADS = 10;
    @Rule
    public VersionControlRule versionControlRule = new VersionControlRule();

    @Test
    public void testContainerBoot() {
        CdiContainer cc = CdiContainerLoader.getCdiContainer();
        Assert.assertNotNull((Object)cc);
        cc.boot();
        cc.getContextControl().startContexts();
        BeanManager bm = cc.getBeanManager();
        Assert.assertNotNull((Object)bm);
        Set beans = bm.getBeans(CarRepair.class, new Annotation[0]);
        Bean bean = bm.resolve(beans);
        CarRepair carRepair = (CarRepair)bm.getReference(bean, CarRepair.class, bm.createCreationalContext((Contextual)bean));
        Assert.assertNotNull((Object)carRepair);
        Assert.assertNotNull((Object)carRepair.getCar());
        Assert.assertNotNull((Object)carRepair.getCar().getUser());
        cc.shutdown();
    }

    @Test
    public void testParallelThreadExecution() throws Exception {
        int i;
        CdiContainer cc = CdiContainerLoader.getCdiContainer();
        Assert.assertNotNull((Object)cc);
        cc.boot();
        cc.getContextControl().startContexts();
        final BeanManager bm = cc.getBeanManager();
        Assert.assertNotNull((Object)bm);
        final AtomicInteger numErrors = new AtomicInteger(0);
        final ContextControl contextControl = cc.getContextControl();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    contextControl.startContext(SessionScoped.class);
                    contextControl.startContext(RequestScoped.class);
                    Set beans = bm.getBeans(CarRepair.class, new Annotation[0]);
                    Bean bean = bm.resolve(beans);
                    CarRepair carRepair = (CarRepair)bm.getReference(bean, CarRepair.class, bm.createCreationalContext((Contextual)bean));
                    Assert.assertNotNull((Object)carRepair);
                    for (int i = 0; i < 100000; ++i) {
                        Assert.assertNotNull((Object)carRepair.getCar());
                        Assert.assertNotNull((Object)carRepair.getCar().getUser());
                        Assert.assertNull((Object)carRepair.getCar().getUser().getName());
                    }
                    contextControl.stopContext(RequestScoped.class);
                    contextControl.stopContext(SessionScoped.class);
                }
                catch (Throwable e) {
                    log.log(Level.SEVERE, "An exception happened on a new worker thread", e);
                    numErrors.incrementAndGet();
                }
            }
        };
        Thread[] threads = new Thread[10];
        for (i = 0; i < 10; ++i) {
            threads[i] = new Thread(runnable);
        }
        for (i = 0; i < 10; ++i) {
            threads[i].start();
        }
        for (i = 0; i < 10; ++i) {
            threads[i].join();
        }
        Assert.assertEquals((String)"An error happened while executing parallel threads", (long)0L, (long)numErrors.get());
        cc.shutdown();
    }

    @Test
    public void testRestartContexts() {
        CdiContainer cdiContainer = CdiContainerLoader.getCdiContainer();
        Assert.assertNotNull((Object)cdiContainer);
        cdiContainer.boot();
        cdiContainer.getContextControl().startContexts();
        BeanManager beanManager = cdiContainer.getBeanManager();
        Assert.assertNotNull((Object)beanManager);
        Set beans = beanManager.getBeans(CarRepair.class, new Annotation[0]);
        Bean bean = beanManager.resolve(beans);
        CarRepair carRepair = (CarRepair)beanManager.getReference(bean, CarRepair.class, beanManager.createCreationalContext((Contextual)bean));
        Assert.assertNotNull((Object)carRepair);
        Car car = carRepair.getCar();
        Assert.assertNotNull((Object)car);
        Assert.assertNotNull((Object)car.getUser());
        carRepair.getCar().getUser().setName("tester");
        Assert.assertEquals((Object)"tester", (Object)car.getUser().getName());
        Assert.assertFalse((boolean)CarRepair.isPreDestroyCalled());
        Assert.assertFalse((boolean)Car.isPreDestroyCalled());
        Assert.assertFalse((boolean)TestUser.isPreDestroyCalled());
        cdiContainer.getContextControl().stopContexts();
        Assert.assertTrue((boolean)CarRepair.isPreDestroyCalled());
        Assert.assertTrue((boolean)Car.isPreDestroyCalled());
        Assert.assertTrue((boolean)TestUser.isPreDestroyCalled());
        try {
            car.getUser();
            Assert.fail();
        }
        catch (ContextNotActiveException e) {
            // empty catch block
        }
        cdiContainer.getContextControl().startContexts();
        carRepair = (CarRepair)beanManager.getReference(bean, CarRepair.class, beanManager.createCreationalContext((Contextual)bean));
        Assert.assertNotNull((Object)carRepair.getCar());
        Assert.assertNotNull((Object)carRepair.getCar().getUser());
        Assert.assertNull((Object)carRepair.getCar().getUser().getName());
        cdiContainer.shutdown();
    }

    @Test
    @LockedCDIImplementation(versions={@LockedVersionRange(implementation=CdiImplementation.WELD11, versionRange="[1.1.14,1.2)"), @LockedVersionRange(implementation=CdiImplementation.WELD20, versionRange="[2.0.1.Final,2.1)")})
    public void testShutdownWithInactiveContexts() {
        CdiContainer cdiContainer = CdiContainerLoader.getCdiContainer();
        Assert.assertNotNull((Object)cdiContainer);
        cdiContainer.boot();
        cdiContainer.getContextControl().startContexts();
        BeanManager beanManager = cdiContainer.getBeanManager();
        Assert.assertNotNull((Object)beanManager);
        Set beans = beanManager.getBeans(CarRepair.class, new Annotation[0]);
        Bean bean = beanManager.resolve(beans);
        CarRepair carRepair = (CarRepair)beanManager.getReference(bean, CarRepair.class, beanManager.createCreationalContext((Contextual)bean));
        Assert.assertNotNull((Object)carRepair);
        Car car = carRepair.getCar();
        Assert.assertNotNull((Object)car);
        Assert.assertNotNull((Object)car.getUser());
        carRepair.getCar().getUser().setName("tester");
        Assert.assertEquals((Object)"tester", (Object)car.getUser().getName());
        Assert.assertFalse((boolean)CarRepair.isPreDestroyCalled());
        Assert.assertFalse((boolean)Car.isPreDestroyCalled());
        Assert.assertFalse((boolean)TestUser.isPreDestroyCalled());
        cdiContainer.getContextControl().stopContexts();
        Assert.assertTrue((boolean)CarRepair.isPreDestroyCalled());
        Assert.assertTrue((boolean)Car.isPreDestroyCalled());
        Assert.assertTrue((boolean)TestUser.isPreDestroyCalled());
        cdiContainer.shutdown();
    }
}

