/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.cdise.tck.control;

import org.apache.deltaspike.cdise.tck.control.LockedCDIImplementation;
import org.apache.deltaspike.cdise.tck.control.LockedVersionRange;
import org.apache.deltaspike.test.utils.CdiContainerUnderTest;
import org.apache.deltaspike.test.utils.CdiImplementation;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class VersionControlRule
implements TestRule {
    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                LockedCDIImplementation lockedCDIImplAnnotation = (LockedCDIImplementation)description.getAnnotation(LockedCDIImplementation.class);
                if (lockedCDIImplAnnotation == null) {
                    base.evaluate();
                } else {
                    this.checkAnnotation(lockedCDIImplAnnotation, base);
                }
            }

            private void checkAnnotation(LockedCDIImplementation lockedCDIImplAnnotation, Statement base2) throws Throwable {
                CdiImplementation[] implementations;
                for (CdiImplementation cdiImpl : implementations = lockedCDIImplAnnotation.cdiImplementations()) {
                    String versionRange = this.getLockedVersionRange(lockedCDIImplAnnotation, cdiImpl);
                    if (!CdiContainerUnderTest.isCdiVersion((CdiImplementation)cdiImpl, (String)versionRange)) continue;
                    base2.evaluate();
                }
            }

            private String getLockedVersionRange(LockedCDIImplementation lockedCDIImplAnnotation, CdiImplementation cdiImpl) {
                LockedVersionRange[] versions;
                for (LockedVersionRange versionRange : versions = lockedCDIImplAnnotation.versions()) {
                    if (!versionRange.implementation().equals((Object)cdiImpl)) continue;
                    return versionRange.versionRange();
                }
                return null;
            }
        };
    }
}

