/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.registry.confluent.debezium;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.avro.AvroRowDataDeserializationSchema;
import org.apache.flink.formats.avro.AvroToRowDataConverters;
import org.apache.flink.formats.avro.registry.confluent.ConfluentRegistryAvroDeserializationSchema;
import org.apache.flink.formats.avro.typeutils.AvroSchemaConverter;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;

@Internal
public final class DebeziumAvroDeserializationSchema
implements DeserializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private static final String OP_READ = "r";
    private static final String OP_CREATE = "c";
    private static final String OP_UPDATE = "u";
    private static final String OP_DELETE = "d";
    private static final String REPLICA_IDENTITY_EXCEPTION = "The \"before\" field of %s message is null, if you are using Debezium Postgres Connector, please check the Postgres table has been set REPLICA IDENTITY to FULL level.";
    private final AvroRowDataDeserializationSchema avroDeserializer;
    private final TypeInformation<RowData> producedTypeInfo;

    public DebeziumAvroDeserializationSchema(RowType rowType, TypeInformation<RowData> producedTypeInfo, String schemaRegistryUrl, @Nullable Map<String, ?> registryConfigs) {
        this.producedTypeInfo = producedTypeInfo;
        RowType debeziumAvroRowType = DebeziumAvroDeserializationSchema.createDebeziumAvroRowType(TypeConversions.fromLogicalToDataType((LogicalType)rowType));
        this.avroDeserializer = new AvroRowDataDeserializationSchema(ConfluentRegistryAvroDeserializationSchema.forGeneric(AvroSchemaConverter.convertToSchema((LogicalType)debeziumAvroRowType), schemaRegistryUrl, registryConfigs), AvroToRowDataConverters.createRowConverter((RowType)debeziumAvroRowType), producedTypeInfo);
    }

    @VisibleForTesting
    DebeziumAvroDeserializationSchema(TypeInformation<RowData> producedTypeInfo, AvroRowDataDeserializationSchema avroDeserializer) {
        this.producedTypeInfo = producedTypeInfo;
        this.avroDeserializer = avroDeserializer;
    }

    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        this.avroDeserializer.open(context);
    }

    public RowData deserialize(byte[] message) throws IOException {
        throw new RuntimeException("Please invoke DeserializationSchema#deserialize(byte[], Collector<RowData>) instead.");
    }

    public void deserialize(byte[] message, Collector<RowData> out) throws IOException {
        block8: {
            if (message == null || message.length == 0) {
                return;
            }
            try {
                GenericRowData row = (GenericRowData)this.avroDeserializer.deserialize(message);
                GenericRowData before = (GenericRowData)row.getField(0);
                GenericRowData after = (GenericRowData)row.getField(1);
                String op = row.getField(2).toString();
                if (OP_CREATE.equals(op) || OP_READ.equals(op)) {
                    after.setRowKind(RowKind.INSERT);
                    out.collect((Object)after);
                    break block8;
                }
                if (OP_UPDATE.equals(op)) {
                    if (before == null) {
                        throw new IllegalStateException(String.format(REPLICA_IDENTITY_EXCEPTION, "UPDATE"));
                    }
                    before.setRowKind(RowKind.UPDATE_BEFORE);
                    after.setRowKind(RowKind.UPDATE_AFTER);
                    out.collect((Object)before);
                    out.collect((Object)after);
                    break block8;
                }
                if (OP_DELETE.equals(op)) {
                    if (before == null) {
                        throw new IllegalStateException(String.format(REPLICA_IDENTITY_EXCEPTION, "DELETE"));
                    }
                    before.setRowKind(RowKind.DELETE);
                    out.collect((Object)before);
                    break block8;
                }
                throw new IOException(String.format("Unknown \"op\" value \"%s\". The Debezium Avro message is '%s'", op, new String(message)));
            }
            catch (Throwable t) {
                throw new IOException("Can't deserialize Debezium Avro message.", t);
            }
        }
    }

    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.producedTypeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DebeziumAvroDeserializationSchema that = (DebeziumAvroDeserializationSchema)o;
        return Objects.equals(this.avroDeserializer, that.avroDeserializer) && Objects.equals(this.producedTypeInfo, that.producedTypeInfo);
    }

    public int hashCode() {
        return Objects.hash(this.avroDeserializer, this.producedTypeInfo);
    }

    public static RowType createDebeziumAvroRowType(DataType databaseSchema) {
        return (RowType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"before", (DataType)((DataType)databaseSchema.nullable())), DataTypes.FIELD((String)"after", (DataType)((DataType)databaseSchema.nullable())), DataTypes.FIELD((String)"op", (DataType)DataTypes.STRING())}).getLogicalType();
    }
}

