/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.OperationContext;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.RequestOptions;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageException;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageExtendedErrorInformation;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.ExecutionEngine;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.RequestLocationMode;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.StorageRequest;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.Utility;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.CloudTableClient;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.EntityResolver;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.MimeHelper;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.MimePart;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.QueryTableOperation;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.TableEntity;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.TableOperation;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.TableOperationType;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.TableRequest;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.TableRequestOptions;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.TableResult;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.TableServiceException;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.TableStorageErrorDeserializer;

public class TableBatchOperation
extends ArrayList<TableOperation> {
    private static final long serialVersionUID = -1192644463287355790L;
    private boolean hasQuery = false;
    private String partitionKey = null;
    private boolean containsWrites = false;

    @Override
    public void add(int index, TableOperation element) {
        Utility.assertNotNull("element", element);
        this.checkSingleQueryPerBatch(element, this.size());
        if (element.getOperationType() == TableOperationType.RETRIEVE) {
            this.lockToPartitionKey(((QueryTableOperation)element).getPartitionKey());
        } else {
            this.lockToPartitionKey(element.getEntity().getPartitionKey());
        }
        super.add(index, element);
    }

    @Override
    public boolean add(TableOperation element) {
        Utility.assertNotNull("element", element);
        this.checkSingleQueryPerBatch(element, this.size());
        if (element.getOperationType() == TableOperationType.RETRIEVE) {
            this.lockToPartitionKey(((QueryTableOperation)element).getPartitionKey());
        } else {
            this.lockToPartitionKey(element.getEntity().getPartitionKey());
        }
        return super.add(element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends TableOperation> c) {
        int size = this.size();
        for (TableOperation tableOperation : c) {
            Utility.assertNotNull("operation", tableOperation);
            this.checkSingleQueryPerBatch(tableOperation, size);
            if (tableOperation.getEntity() == null) {
                this.lockToPartitionKey(((QueryTableOperation)tableOperation).getPartitionKey());
            } else {
                this.lockToPartitionKey(tableOperation.getEntity().getPartitionKey());
            }
            ++size;
        }
        return super.addAll(index, c);
    }

    @Override
    public boolean addAll(Collection<? extends TableOperation> c) {
        int size = this.size();
        for (TableOperation tableOperation : c) {
            Utility.assertNotNull("operation", tableOperation);
            this.checkSingleQueryPerBatch(tableOperation, size);
            if (tableOperation.getEntity() == null) {
                this.lockToPartitionKey(((QueryTableOperation)tableOperation).getPartitionKey());
            } else {
                this.lockToPartitionKey(tableOperation.getEntity().getPartitionKey());
            }
            ++size;
        }
        return super.addAll(c);
    }

    @Override
    public void clear() {
        super.clear();
        this.checkResetEntityLocks();
    }

    public void delete(TableEntity entity) {
        this.lockToPartitionKey(entity.getPartitionKey());
        this.add(TableOperation.delete(entity));
    }

    public void insert(TableEntity entity) {
        this.insert(entity, false);
    }

    public void insert(TableEntity entity, boolean echoContent) {
        this.lockToPartitionKey(entity.getPartitionKey());
        this.add(TableOperation.insert(entity, echoContent));
    }

    public void insertOrMerge(TableEntity entity) {
        this.lockToPartitionKey(entity.getPartitionKey());
        this.add(TableOperation.insertOrMerge(entity));
    }

    public void insertOrReplace(TableEntity entity) {
        this.lockToPartitionKey(entity.getPartitionKey());
        this.add(TableOperation.insertOrReplace(entity));
    }

    public void merge(TableEntity entity) {
        this.lockToPartitionKey(entity.getPartitionKey());
        this.add(TableOperation.merge(entity));
    }

    public void retrieve(String partitionKey, String rowKey, Class<? extends TableEntity> clazzType) {
        this.lockToPartitionKey(partitionKey);
        this.add(TableOperation.retrieve(partitionKey, rowKey, clazzType));
    }

    public void retrieve(String partitionKey, String rowKey, EntityResolver<?> resolver) {
        this.lockToPartitionKey(partitionKey);
        this.add(TableOperation.retrieve(partitionKey, rowKey, resolver));
    }

    @Override
    public TableOperation remove(int index) {
        TableOperation op = (TableOperation)super.remove(index);
        this.checkResetEntityLocks();
        return op;
    }

    @Override
    public boolean remove(Object o) {
        boolean ret = super.remove(o);
        this.checkResetEntityLocks();
        return ret;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ret = super.removeAll(c);
        this.checkResetEntityLocks();
        return ret;
    }

    public void replace(TableEntity entity) {
        this.lockToPartitionKey(entity.getPartitionKey());
        this.add(TableOperation.replace(entity));
    }

    private void checkResetEntityLocks() {
        if (this.size() == 0) {
            this.partitionKey = null;
            this.hasQuery = false;
            this.containsWrites = false;
        }
    }

    private void checkSingleQueryPerBatch(TableOperation op, int size) {
        if (this.hasQuery) {
            throw new IllegalArgumentException("A batch transaction with a retrieve operation cannot contain any other operations.");
        }
        if (op.getOperationType() == TableOperationType.RETRIEVE) {
            if (size > 0) {
                throw new IllegalArgumentException("A batch transaction with a retrieve operation cannot contain any other operations.");
            }
            this.hasQuery = true;
        }
        this.containsWrites = op.getOperationType() != TableOperationType.RETRIEVE;
    }

    private void lockToPartitionKey(String partitionKey) {
        if (this.partitionKey == null) {
            this.partitionKey = partitionKey;
        } else if (partitionKey.length() != partitionKey.length() || !this.partitionKey.equals(partitionKey)) {
            throw new IllegalArgumentException("All entities in a given batch must have the same partition key.");
        }
    }

    protected ArrayList<TableResult> execute(CloudTableClient client, String tableName, TableRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNullOrEmpty("TableName", tableName);
        if (this.size() == 0) {
            throw new IllegalArgumentException("Cannot execute an empty batch operation.");
        }
        return ExecutionEngine.executeWithRetry(client, this, this.executeImpl(client, tableName, options, opContext), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudTableClient, TableBatchOperation, ArrayList<TableResult>> executeImpl(CloudTableClient client, String tableName, final TableRequestOptions options, final OperationContext opContext) throws StorageException {
        final String batchID = String.format("batch_%s", UUID.randomUUID().toString());
        String changeSet = String.format("changeset_%s", UUID.randomUUID().toString());
        ByteArrayOutputStream sendStream = new ByteArrayOutputStream();
        try {
            MimeHelper.writeBatchToStream(sendStream, options, tableName, client.getTransformedEndPoint(opContext).getPrimaryUri(), this, batchID, changeSet, opContext);
            final byte[] batchBytes = sendStream.toByteArray();
            StorageRequest<CloudTableClient, TableBatchOperation, ArrayList<TableResult>> batchRequest = new StorageRequest<CloudTableClient, TableBatchOperation, ArrayList<TableResult>>((RequestOptions)options, client.getStorageUri()){

                @Override
                public void setRequestLocationMode() {
                    this.setRequestLocationMode(TableBatchOperation.this.containsWrites ? RequestLocationMode.PRIMARY_ONLY : RequestLocationMode.PRIMARY_OR_SECONDARY);
                }

                @Override
                public HttpURLConnection buildRequest(CloudTableClient client, TableBatchOperation batch, OperationContext context) throws Exception {
                    this.setSendStream(new ByteArrayInputStream(batchBytes));
                    this.setLength(Long.valueOf(batchBytes.length));
                    return TableRequest.batch(client.getTransformedEndPoint(context).getUri(this.getCurrentLocation()), options, null, context, batchID);
                }

                @Override
                public void signRequest(HttpURLConnection connection, CloudTableClient client, OperationContext context) throws Exception {
                    StorageRequest.signTableRequest(connection, client, -1L, context);
                }

                @Override
                public ArrayList<TableResult> preProcessResponse(TableBatchOperation batch, CloudTableClient client, OperationContext context) throws Exception {
                    if (this.getResult().getStatusCode() != 202) {
                        this.setNonExceptionedRetryableFailure(true);
                    }
                    return null;
                }

                @Override
                public ArrayList<TableResult> postProcessResponse(HttpURLConnection connection, TableBatchOperation batch, CloudTableClient client, OperationContext context, ArrayList<TableResult> storageObject) throws Exception {
                    InputStream streamRef = connection.getInputStream();
                    ArrayList<MimePart> responseParts = null;
                    String contentType = connection.getHeaderField("Content-Type");
                    String[] headerVals = contentType.split("multipart/mixed; boundary=");
                    if (headerVals == null || headerVals.length != 2) {
                        throw new StorageException("OutOfRangeInput", "An incorrect Content-Type was returned from the server.", 306, null, null);
                    }
                    responseParts = MimeHelper.readBatchResponseStream(streamRef, headerVals[1], opContext, options.getTablePayloadFormat());
                    ArrayList<TableResult> result = new ArrayList<TableResult>();
                    for (int m3 = 0; m3 < batch.size(); ++m3) {
                        TableOperation currOp = (TableOperation)batch.get(m3);
                        MimePart currMimePart = responseParts.get(m3);
                        boolean failFlag = false;
                        if (currOp.getOperationType() == TableOperationType.INSERT) {
                            if (currOp.getEchoContent() && currMimePart.httpStatusCode != 201) {
                                failFlag = true;
                            } else if (!currOp.getEchoContent() && currMimePart.httpStatusCode != 204) {
                                failFlag = true;
                            }
                        } else if (currOp.getOperationType() == TableOperationType.RETRIEVE) {
                            if (currMimePart.httpStatusCode == 404) {
                                result.add(new TableResult(currMimePart.httpStatusCode));
                                return result;
                            }
                            if (currMimePart.httpStatusCode != 200) {
                                failFlag = true;
                            }
                        } else if (currMimePart.httpStatusCode != 204) {
                            failFlag = true;
                        }
                        if (failFlag) {
                            throw new TableServiceException(currMimePart.httpStatusCode, currMimePart.httpStatusMessage, currOp, new StringReader(currMimePart.payload), options.getTablePayloadFormat());
                        }
                        ByteArrayInputStream byteStream = null;
                        if (currOp.getOperationType() == TableOperationType.INSERT && currOp.getEchoContent() || currOp.getOperationType() == TableOperationType.RETRIEVE) {
                            byteStream = new ByteArrayInputStream(currMimePart.payload.getBytes());
                        }
                        result.add(currOp.parseResponse(byteStream, currMimePart.httpStatusCode, currMimePart.headers.get("ETag"), opContext, options));
                    }
                    return result;
                }

                @Override
                public StorageExtendedErrorInformation parseErrorDetails() {
                    return TableStorageErrorDeserializer.parseErrorDetails(this);
                }
            };
            return batchRequest;
        }
        catch (IOException e) {
            StorageException translatedException = StorageException.translateClientException(e);
            throw translatedException;
        }
        catch (URISyntaxException e) {
            StorageException translatedException = StorageException.translateClientException(e);
            throw translatedException;
        }
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        super.removeRange(fromIndex, toIndex);
        this.checkResetEntityLocks();
    }
}

