/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.Key;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.flink.fs.azure.shaded.com.fasterxml.jackson.core.JsonParseException;
import org.apache.flink.fs.azure.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.fs.azure.shaded.com.fasterxml.jackson.core.JsonToken;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.OperationContext;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageException;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.EncryptionData;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.JsonUtilities;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.Utility;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.CEKReturn;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.EdmType;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.EntityProperty;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.EntityResolver;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.ODataPayload;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.PropertyPair;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.TableEntity;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.TablePayloadFormat;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.TableRequestOptions;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.TableResult;

final class TableDeserializer {
    TableDeserializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends TableEntity, R> ODataPayload<?> parseQueryResponse(InputStream inStream, TableRequestOptions options, Class<T> clazzType, EntityResolver<R> resolver, OperationContext opContext) throws JsonParseException, IOException, InstantiationException, IllegalAccessException, StorageException {
        ODataPayload corePayload = null;
        ODataPayload resolvedPayload = null;
        ODataPayload commonPayload = null;
        JsonParser parser = Utility.getJsonParser(inStream);
        try {
            if (resolver != null) {
                commonPayload = resolvedPayload = new ODataPayload();
            } else {
                corePayload = new ODataPayload();
                commonPayload = corePayload;
            }
            if (!parser.hasCurrentToken()) {
                parser.nextToken();
            }
            JsonUtilities.assertIsStartObjectJsonToken(parser);
            parser.nextToken();
            HashMap<String, PropertyPair> classProperties = null;
            if (options.getTablePayloadFormat() == TablePayloadFormat.JsonNoMetadata && clazzType != null) {
                classProperties = PropertyPair.generatePropertyPairs(clazzType);
            }
            while (parser.getCurrentToken() != null) {
                if (parser.getCurrentToken() == JsonToken.FIELD_NAME && parser.getCurrentName().equals("value")) {
                    parser.nextToken();
                    JsonUtilities.assertIsStartArrayJsonToken(parser);
                    parser.nextToken();
                    while (parser.getCurrentToken() == JsonToken.START_OBJECT) {
                        TableResult res = TableDeserializer.parseJsonEntity(parser, clazzType, classProperties, resolver, options, opContext);
                        if (corePayload != null) {
                            corePayload.tableResults.add(res);
                        }
                        if (resolver != null) {
                            resolvedPayload.results.add(res.getResult());
                        } else {
                            corePayload.results.add((TableEntity)res.getResult());
                        }
                        parser.nextToken();
                    }
                    JsonUtilities.assertIsEndArrayJsonToken(parser);
                }
                parser.nextToken();
            }
        }
        finally {
            parser.close();
        }
        return commonPayload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends TableEntity, R> TableResult parseSingleOpResponse(InputStream inStream, TableRequestOptions options, int httpStatusCode, Class<T> clazzType, EntityResolver<R> resolver, OperationContext opContext) throws JsonParseException, IOException, InstantiationException, IllegalAccessException, StorageException {
        JsonParser parser = Utility.getJsonParser(inStream);
        try {
            TableResult res = TableDeserializer.parseJsonEntity(parser, clazzType, null, resolver, options, opContext);
            res.setHttpStatusCode(httpStatusCode);
            TableResult tableResult = res;
            return tableResult;
        }
        finally {
            parser.close();
        }
    }

    private static <T extends TableEntity, R> TableResult parseJsonEntity(JsonParser parser, Class<T> clazzType, HashMap<String, PropertyPair> classProperties, EntityResolver<R> resolver, TableRequestOptions options, OperationContext opContext) throws JsonParseException, IOException, StorageException, InstantiationException, IllegalAccessException {
        TableResult res = new TableResult();
        HashMap<String, EntityProperty> properties = new HashMap<String, EntityProperty>();
        if (!parser.hasCurrentToken()) {
            parser.nextToken();
        }
        JsonUtilities.assertIsStartObjectJsonToken(parser);
        parser.nextToken();
        while (parser.getCurrentName().startsWith("odata.")) {
            String name = parser.getCurrentName().substring("odata.".length());
            parser.nextToken();
            if (name.equals("etag")) {
                String etag = parser.getValueAsString();
                res.setEtag(etag);
            }
            parser.nextToken();
        }
        if (resolver == null && clazzType == null) {
            return res;
        }
        while (parser.getCurrentToken() != JsonToken.END_OBJECT) {
            String key = "";
            String val = "";
            EdmType edmType = null;
            if (options.getTablePayloadFormat() != TablePayloadFormat.JsonNoMetadata && parser.getCurrentName().endsWith("@odata.type")) {
                parser.nextToken();
                edmType = EdmType.parse(parser.getValueAsString());
                parser.nextValue();
                key = parser.getCurrentName();
                val = parser.getValueAsString();
            } else {
                key = parser.getCurrentName();
                parser.nextToken();
                val = parser.getValueAsString();
                edmType = TableDeserializer.evaluateEdmType(parser.getCurrentToken(), parser.getValueAsString());
            }
            EntityProperty newProp = new EntityProperty(val, edmType);
            newProp.setDateBackwardCompatibility(options.getDateBackwardCompatibility());
            properties.put(key, newProp);
            parser.nextToken();
        }
        String partitionKey = null;
        String rowKey = null;
        Date timestamp = null;
        String etag = null;
        EntityProperty tempProp = (EntityProperty)properties.remove("PartitionKey");
        if (tempProp != null) {
            partitionKey = tempProp.getValueAsString();
        }
        if ((tempProp = (EntityProperty)properties.remove("RowKey")) != null) {
            rowKey = tempProp.getValueAsString();
        }
        if ((tempProp = (EntityProperty)properties.remove("Timestamp")) != null) {
            tempProp.setDateBackwardCompatibility(false);
            timestamp = tempProp.getValueAsDate();
            if (res.getEtag() == null) {
                etag = TableDeserializer.getETagFromTimestamp(tempProp.getValueAsString());
                res.setEtag(etag);
            }
        }
        Key cek = null;
        Boolean isJavaV1 = true;
        EncryptionData encryptionData = new EncryptionData();
        HashSet<String> encryptedPropertyDetailsSet = null;
        if (options.getEncryptionPolicy() != null) {
            EntityProperty propertyDetailsProperty = (EntityProperty)properties.get("_ClientEncryptionMetadata2");
            EntityProperty entityProperty = (EntityProperty)properties.get("_ClientEncryptionMetadata1");
            if (propertyDetailsProperty != null && !propertyDetailsProperty.getIsNull() && entityProperty != null && !entityProperty.getIsNull()) {
                CEKReturn cekReturn = options.getEncryptionPolicy().decryptMetadataAndReturnCEK(partitionKey, rowKey, entityProperty, propertyDetailsProperty, encryptionData);
                cek = cekReturn.key;
                isJavaV1 = cekReturn.isJavaV1;
                properties.put("_ClientEncryptionMetadata2", propertyDetailsProperty);
                encryptedPropertyDetailsSet = TableDeserializer.parsePropertyDetails(propertyDetailsProperty);
            } else if (options.requireEncryption() != null && options.requireEncryption().booleanValue()) {
                throw new StorageException("DecryptionError", "Encryption data does not exist. If you do not want to decrypt the data, please do not set the require encryption flag on request options", null);
            }
        }
        if (options.getTablePayloadFormat() == TablePayloadFormat.JsonNoMetadata && (options.getPropertyResolver() != null || clazzType != null)) {
            for (Map.Entry entry : properties.entrySet()) {
                EntityProperty newProp;
                PropertyPair propPair;
                EntityProperty newProp2;
                if ("_ClientEncryptionMetadata1".equals(entry.getKey())) {
                    newProp2 = new EntityProperty(((EntityProperty)entry.getValue()).getValueAsString(), EdmType.STRING);
                    properties.put((String)entry.getKey(), newProp2);
                    continue;
                }
                if ("_ClientEncryptionMetadata2".equals(entry.getKey())) {
                    if (options.getEncryptionPolicy() != null) continue;
                    newProp2 = new EntityProperty(((EntityProperty)entry.getValue()).getValueAsString(), EdmType.BINARY);
                    properties.put((String)entry.getKey(), newProp2);
                    continue;
                }
                if (options.getPropertyResolver() != null) {
                    EdmType edmType;
                    String key = (String)entry.getKey();
                    String value = ((EntityProperty)entry.getValue()).getValueAsString();
                    try {
                        edmType = options.getPropertyResolver().propertyResolver(partitionKey, rowKey, key, value);
                    }
                    catch (Exception e) {
                        throw new StorageException("InternalError", "The custom property resolver delegate threw an exception. Check the inner exception for more details.", 306, null, e);
                    }
                    try {
                        EntityProperty newProp22 = new EntityProperty(value, TableDeserializer.isEncrypted(encryptedPropertyDetailsSet, key) ? EdmType.BINARY : edmType);
                        newProp22.setDateBackwardCompatibility(options.getDateBackwardCompatibility());
                        properties.put((String)entry.getKey(), newProp22);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new StorageException("InvalidType", String.format("Failed to parse property '%s' with value '%s' as type '%s'", new Object[]{key, value, edmType}), 306, null, e);
                    }
                }
                if (clazzType == null) continue;
                if (classProperties == null) {
                    classProperties = PropertyPair.generatePropertyPairs(clazzType);
                }
                if ((propPair = classProperties.get(entry.getKey())) == null) continue;
                if (TableDeserializer.isEncrypted(encryptedPropertyDetailsSet, (String)entry.getKey())) {
                    EntityProperty newProp3 = new EntityProperty(((EntityProperty)entry.getValue()).getValueAsString(), EdmType.BINARY);
                } else {
                    newProp = new EntityProperty(((EntityProperty)entry.getValue()).getValueAsString(), propPair.type);
                }
                newProp.setDateBackwardCompatibility(options.getDateBackwardCompatibility());
                properties.put((String)entry.getKey(), newProp);
            }
        }
        if (options.getEncryptionPolicy() != null && cek != null) {
            properties = options.getEncryptionPolicy().decryptEntity(properties, encryptedPropertyDetailsSet, partitionKey, rowKey, cek, encryptionData, isJavaV1);
        }
        res.setProperties(properties);
        if (resolver != null) {
            res.setResult(resolver.resolve(partitionKey, rowKey, timestamp, properties, res.getEtag()));
        } else if (clazzType != null) {
            TableEntity entity = (TableEntity)clazzType.newInstance();
            entity.setEtag(res.getEtag());
            entity.setPartitionKey(partitionKey);
            entity.setRowKey(rowKey);
            entity.setTimestamp(timestamp);
            entity.readEntity(properties, opContext);
            res.setResult(entity);
        }
        return res;
    }

    private static String getETagFromTimestamp(String timestampString) throws UnsupportedEncodingException {
        timestampString = URLEncoder.encode(timestampString, "UTF-8");
        return "W/\"datetime'" + timestampString + "'\"";
    }

    private static EdmType evaluateEdmType(JsonToken token, String value) {
        EdmType edmType = null;
        edmType = token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE ? EdmType.BOOLEAN : (token == JsonToken.VALUE_NUMBER_FLOAT ? EdmType.DOUBLE : (token == JsonToken.VALUE_NUMBER_INT ? EdmType.INT32 : EdmType.STRING));
        return edmType;
    }

    private static boolean isEncrypted(HashSet<String> encryptedPropertyDetailsSet, String key) {
        return encryptedPropertyDetailsSet != null && encryptedPropertyDetailsSet.contains(key);
    }

    private static HashSet<String> parsePropertyDetails(EntityProperty propertyDetailsProperty) throws UnsupportedEncodingException {
        HashSet<String> encryptedPropertyDetailsSet = null;
        if (propertyDetailsProperty != null && !propertyDetailsProperty.getIsNull()) {
            byte[] binaryVal = propertyDetailsProperty.getValueAsByteArray();
            String stringProperty = new String(binaryVal, 0, binaryVal.length, "UTF-8").replaceAll(" ", "").replaceAll("\"", "");
            encryptedPropertyDetailsSet = new HashSet<String>(Arrays.asList(stringProperty.substring(1, stringProperty.length() - 1).split(",")));
        }
        return encryptedPropertyDetailsSet;
    }
}

