/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.diagnostics;

import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.contracts.diagnostics.ConfigurationValidator;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidConfigurationValueException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.diagnostics.ConfigurationBasicValidator;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class IntegerConfigurationBasicValidator
extends ConfigurationBasicValidator<Integer>
implements ConfigurationValidator {
    private final int min;
    private final int max;
    private final int outlier;

    public IntegerConfigurationBasicValidator(int min2, int max, int defaultVal, String configKey, boolean throwIfInvalid) {
        this(min2, min2, max, defaultVal, configKey, throwIfInvalid);
    }

    public IntegerConfigurationBasicValidator(int outlier, int min2, int max, int defaultVal, String configKey, boolean throwIfInvalid) {
        super(configKey, defaultVal, throwIfInvalid);
        this.min = min2;
        this.max = max;
        this.outlier = outlier;
    }

    @Override
    public Integer validate(String configValue) throws InvalidConfigurationValueException {
        Integer result = (Integer)super.validate(configValue);
        if (result != null) {
            return result;
        }
        try {
            result = Integer.parseInt(configValue);
            if (this.getThrowIfInvalid() && result != this.outlier && (result < this.min || result > this.max)) {
                throw new InvalidConfigurationValueException(this.getConfigKey());
            }
            if (result == this.outlier) {
                return result;
            }
            if (result < this.min) {
                return this.min;
            }
            if (result > this.max) {
                return this.max;
            }
        }
        catch (NumberFormatException ex) {
            throw new InvalidConfigurationValueException(this.getConfigKey(), ex);
        }
        return result;
    }
}

