/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.security;

import java.io.IOException;
import java.net.URI;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.Text;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.Credentials;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.UserGroupInformation;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.token.DtFetcher;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.token.Token;

public class AbfsDtFetcher
implements DtFetcher {
    private static final String FETCH_FAILED = "Filesystem not generating Delegation Tokens";

    @Override
    public Text getServiceName() {
        return new Text(this.getScheme());
    }

    protected String getScheme() {
        return "abfs";
    }

    @Override
    public boolean isTokenRequired() {
        return UserGroupInformation.isSecurityEnabled();
    }

    @Override
    public Token<?> addDelegationTokens(Configuration conf, Credentials creds, String renewer, String url) throws Exception {
        FileSystem fs;
        Token<?> token;
        if (!url.startsWith(this.getServiceName().toString())) {
            url = this.getServiceName().toString() + "://" + url;
        }
        if ((token = (fs = FileSystem.get(URI.create(url), conf)).getDelegationToken(renewer)) == null) {
            throw new IOException("Filesystem not generating Delegation Tokens: " + url);
        }
        creds.addToken(token.getService(), token);
        return token;
    }
}

