/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services;

import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsClientThrottlingAnalyzer;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsCounters;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsRestOperationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AbfsClientThrottlingIntercept {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsClientThrottlingIntercept.class);
    private static final String RANGE_PREFIX = "bytes=";
    private static AbfsClientThrottlingIntercept singleton = null;
    private AbfsClientThrottlingAnalyzer readThrottler = new AbfsClientThrottlingAnalyzer("read");
    private AbfsClientThrottlingAnalyzer writeThrottler = new AbfsClientThrottlingAnalyzer("write");
    private static boolean isAutoThrottlingEnabled = false;

    private AbfsClientThrottlingIntercept() {
    }

    public static synchronized void initializeSingleton(boolean enableAutoThrottling) {
        if (!enableAutoThrottling) {
            return;
        }
        if (singleton == null) {
            singleton = new AbfsClientThrottlingIntercept();
            isAutoThrottlingEnabled = true;
            LOG.debug("Client-side throttling is enabled for the ABFS file system.");
        }
    }

    static void updateMetrics(AbfsRestOperationType operationType, AbfsHttpOperation abfsHttpOperation) {
        if (!isAutoThrottlingEnabled || abfsHttpOperation == null) {
            return;
        }
        int status = abfsHttpOperation.getStatusCode();
        long contentLength = 0L;
        boolean isFailedOperation = status < 200 || status >= 500;
        switch (operationType) {
            case Append: {
                contentLength = abfsHttpOperation.getBytesSent();
                if (contentLength <= 0L) break;
                AbfsClientThrottlingIntercept.singleton.writeThrottler.addBytesTransferred(contentLength, isFailedOperation);
                break;
            }
            case ReadFile: {
                String range = abfsHttpOperation.getConnection().getRequestProperty("Range");
                contentLength = AbfsClientThrottlingIntercept.getContentLengthIfKnown(range);
                if (contentLength <= 0L) break;
                AbfsClientThrottlingIntercept.singleton.readThrottler.addBytesTransferred(contentLength, isFailedOperation);
                break;
            }
        }
    }

    static void sendingRequest(AbfsRestOperationType operationType, AbfsCounters abfsCounters) {
        if (!isAutoThrottlingEnabled) {
            return;
        }
        switch (operationType) {
            case ReadFile: {
                if (!AbfsClientThrottlingIntercept.singleton.readThrottler.suspendIfNecessary() || abfsCounters == null) break;
                abfsCounters.incrementCounter(AbfsStatistic.READ_THROTTLES, 1L);
                break;
            }
            case Append: {
                if (!AbfsClientThrottlingIntercept.singleton.writeThrottler.suspendIfNecessary() || abfsCounters == null) break;
                abfsCounters.incrementCounter(AbfsStatistic.WRITE_THROTTLES, 1L);
                break;
            }
        }
    }

    private static long getContentLengthIfKnown(String range) {
        String[] offsets;
        long contentLength = 0L;
        if (range != null && range.startsWith(RANGE_PREFIX) && (offsets = range.substring(RANGE_PREFIX.length()).split("-")).length == 2) {
            contentLength = Long.parseLong(offsets[1]) - Long.parseLong(offsets[0]) + 1L;
        }
        return contentLength;
    }
}

