/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateTimeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DateTimeUtils.class);
    private static final String DATE_TIME_PATTERN = "E, dd MMM yyyy HH:mm:ss z";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long parseLastModifiedTime(String lastModifiedTime) {
        long parsedTime = 0L;
        try {
            Date utcDate = new SimpleDateFormat(DATE_TIME_PATTERN, Locale.US).parse(lastModifiedTime);
            parsedTime = utcDate.getTime();
            return parsedTime;
        }
        catch (ParseException e) {
            LOG.error("Failed to parse the date {}", (Object)lastModifiedTime);
        }
        finally {
            return parsedTime;
        }
    }

    public static boolean isRecentlyModified(String lastModifiedTime, Instant expectedLMTUpdateTime) {
        long currentEpochTime;
        long lmtEpochTime = DateTimeUtils.parseLastModifiedTime(lastModifiedTime);
        return lmtEpochTime > (currentEpochTime = expectedLMTUpdateTime.toEpochMilli()) || currentEpochTime - lmtEpochTime <= 300000L;
    }

    private DateTimeUtils() {
    }
}

