/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileStatus;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.LocalFileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.PathIOException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.PathIsDirectoryException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.PathIsNotDirectoryException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.PathNotFoundException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.RemoteIterator;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.functional.RemoteIterators;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class PathData
implements Comparable<PathData> {
    protected final URI uri;
    public final FileSystem fs;
    public final Path path;
    public FileStatus stat;
    public boolean exists;
    private boolean inferredSchemeFromPath = false;
    private static final Pattern potentialUri = Pattern.compile("^[a-zA-Z][a-zA-Z0-9+-.]+:");
    private static final Pattern windowsNonUriAbsolutePath1 = Pattern.compile("^/?[a-zA-Z]:\\\\");
    private static final Pattern windowsNonUriAbsolutePath2 = Pattern.compile("^/?[a-zA-Z]:/");

    public PathData(String pathString, Configuration conf) throws IOException {
        this(FileSystem.get(PathData.stringToUri(pathString), conf), pathString);
    }

    public PathData(URI localPath, Configuration conf) throws IOException {
        this(FileSystem.getLocal(conf), localPath.getPath());
    }

    private PathData(FileSystem fs, String pathString) throws IOException {
        this(fs, pathString, PathData.lookupStat(fs, pathString, true));
    }

    private static boolean checkIfSchemeInferredFromPath(String pathString) throws IOException {
        if (windowsNonUriAbsolutePath1.matcher(pathString).find()) {
            if (pathString.indexOf(47) != -1) {
                throw new IOException("Invalid path string " + pathString);
            }
            return true;
        }
        if (windowsNonUriAbsolutePath2.matcher(pathString).find()) {
            return true;
        }
        if (potentialUri.matcher(pathString).find()) {
            return false;
        }
        return false;
    }

    private PathData(FileSystem fs, String pathString, FileStatus stat) throws IOException {
        this.fs = fs;
        this.uri = PathData.stringToUri(pathString);
        this.path = fs.makeQualified(new Path(this.uri));
        this.setStat(stat);
        if (Path.WINDOWS) {
            this.inferredSchemeFromPath = PathData.checkIfSchemeInferredFromPath(pathString);
        }
    }

    private static FileStatus lookupStat(FileSystem fs, String pathString, boolean ignoreFNF) throws IOException {
        FileStatus status;
        block2: {
            status = null;
            try {
                status = fs.getFileStatus(new Path(pathString));
            }
            catch (FileNotFoundException e) {
                if (ignoreFNF) break block2;
                throw new PathNotFoundException(pathString);
            }
        }
        return status;
    }

    private void setStat(FileStatus stat) {
        this.stat = stat;
        this.exists = stat != null;
    }

    public FileStatus refreshStatus() throws IOException {
        FileStatus status = null;
        try {
            status = PathData.lookupStat(this.fs, this.toString(), false);
            this.setStat(status);
        }
        catch (Throwable throwable) {
            this.setStat(status);
            throw throwable;
        }
        return status;
    }

    private void checkIfExists(FileTypeRequirement typeRequirement) throws PathIOException {
        if (!this.exists) {
            throw new PathNotFoundException(this.toString());
        }
        if (typeRequirement == FileTypeRequirement.SHOULD_BE_DIRECTORY && !this.stat.isDirectory()) {
            throw new PathIsNotDirectoryException(this.toString());
        }
        if (typeRequirement == FileTypeRequirement.SHOULD_NOT_BE_DIRECTORY && this.stat.isDirectory()) {
            throw new PathIsDirectoryException(this.toString());
        }
    }

    public PathData suffix(String extension) throws IOException {
        return new PathData(this.fs, this + extension);
    }

    public boolean parentExists() throws IOException {
        return this.representsDirectory() ? this.fs.exists(this.path) : this.fs.exists(this.path.getParent());
    }

    public boolean representsDirectory() {
        String uriPath = this.uri.getPath();
        String name = uriPath.substring(uriPath.lastIndexOf("/") + 1);
        return name.isEmpty() || name.equals(".") || name.equals("..");
    }

    public PathData[] getDirectoryContents() throws IOException {
        this.checkIfExists(FileTypeRequirement.SHOULD_BE_DIRECTORY);
        FileStatus[] stats = this.fs.listStatus(this.path);
        Object[] items = new PathData[stats.length];
        for (int i = 0; i < stats.length; ++i) {
            String child = this.getStringForChildPath(stats[i].getPath());
            items[i] = new PathData(this.fs, child, stats[i]);
        }
        Arrays.sort(items);
        return items;
    }

    public RemoteIterator<PathData> getDirectoryContentsIterator() throws IOException {
        this.checkIfExists(FileTypeRequirement.SHOULD_BE_DIRECTORY);
        RemoteIterator<FileStatus> stats = this.fs.listStatusIterator(this.path);
        return RemoteIterators.mappingRemoteIterator(stats, file -> new PathData(this.fs, this.getStringForChildPath(file.getPath()), (FileStatus)file));
    }

    public PathData getPathDataForChild(PathData child) throws IOException {
        this.checkIfExists(FileTypeRequirement.SHOULD_BE_DIRECTORY);
        return new PathData(this.fs, this.getStringForChildPath(child.path));
    }

    private String getStringForChildPath(Path childPath) {
        String basename = childPath.getName();
        if (".".equals(this.toString())) {
            return basename;
        }
        String separator = this.uri.getPath().endsWith("/") ? "" : "/";
        return PathData.uriToString(this.uri, this.inferredSchemeFromPath) + separator + basename;
    }

    public static PathData[] expandAsGlob(String pattern, Configuration conf) throws IOException {
        Path globPath = new Path(pattern);
        FileSystem fs = globPath.getFileSystem(conf);
        FileStatus[] stats = fs.globStatus(globPath);
        Object[] items = null;
        if (stats == null) {
            pattern = pattern.replaceAll("\\\\(.)", "$1");
            items = new PathData[]{new PathData(fs, pattern, null)};
        } else {
            URI globUri = globPath.toUri();
            PathType globType = globUri.getScheme() != null ? PathType.HAS_SCHEME : (!globUri.getPath().isEmpty() && new Path(globUri.getPath()).isAbsolute() ? PathType.SCHEMELESS_ABSOLUTE : PathType.RELATIVE);
            items = new PathData[stats.length];
            int i = 0;
            for (FileStatus stat : stats) {
                URI matchUri = stat.getPath().toUri();
                String globMatch = null;
                switch (globType) {
                    case HAS_SCHEME: {
                        if (globUri.getAuthority() == null) {
                            matchUri = PathData.removeAuthority(matchUri);
                        }
                        globMatch = PathData.uriToString(matchUri, false);
                        break;
                    }
                    case SCHEMELESS_ABSOLUTE: {
                        globMatch = matchUri.getPath();
                        break;
                    }
                    case RELATIVE: {
                        URI cwdUri = fs.getWorkingDirectory().toUri();
                        globMatch = PathData.relativize(cwdUri, matchUri, stat.isDirectory());
                    }
                }
                items[i++] = new PathData(fs, globMatch, stat);
            }
        }
        Arrays.sort(items);
        return items;
    }

    private static URI removeAuthority(URI uri) {
        try {
            uri = new URI(uri.getScheme(), "", uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
        return uri;
    }

    private static String relativize(URI cwdUri, URI srcUri, boolean isDir) {
        String uriPath = srcUri.getPath();
        String cwdPath = cwdUri.getPath();
        if (cwdPath.equals(uriPath)) {
            return ".";
        }
        int lastSep = PathData.findLongestDirPrefix(cwdPath, uriPath, isDir);
        StringBuilder relPath = new StringBuilder();
        if (lastSep < uriPath.length()) {
            relPath.append(uriPath.substring(lastSep + 1));
        }
        if (lastSep < cwdPath.length()) {
            while (lastSep != -1) {
                if (relPath.length() != 0) {
                    relPath.insert(0, "/");
                }
                relPath.insert(0, "..");
                lastSep = cwdPath.indexOf("/", lastSep + 1);
            }
        }
        return relPath.toString();
    }

    private static int findLongestDirPrefix(String cwd, String path, boolean isDir) {
        if (!cwd.endsWith("/")) {
            cwd = cwd + "/";
        }
        if (isDir && !path.endsWith("/")) {
            path = path + "/";
        }
        int len = Math.min(cwd.length(), path.length());
        int lastSep = -1;
        for (int i = 0; i < len && cwd.charAt(i) == path.charAt(i); ++i) {
            if (cwd.charAt(i) != '/') continue;
            lastSep = i;
        }
        return lastSep;
    }

    public String toString() {
        return PathData.uriToString(this.uri, this.inferredSchemeFromPath);
    }

    private static String uriToString(URI uri, boolean inferredSchemeFromPath) {
        String scheme = uri.getScheme();
        String decodedRemainder = uri.getSchemeSpecificPart();
        if (scheme == null || inferredSchemeFromPath) {
            if (Path.isWindowsAbsolutePath(decodedRemainder, true)) {
                decodedRemainder = decodedRemainder.substring(1);
            }
            return decodedRemainder;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(scheme).append(":").append(decodedRemainder);
        return buffer.toString();
    }

    public File toFile() {
        if (!(this.fs instanceof LocalFileSystem)) {
            throw new IllegalArgumentException("Not a local path: " + this.path);
        }
        return ((LocalFileSystem)this.fs).pathToFile(this.path);
    }

    private static String normalizeWindowsPath(String pathString) throws IOException {
        boolean slashed;
        if (!Path.WINDOWS) {
            return pathString;
        }
        boolean bl = slashed = pathString.length() >= 1 && pathString.charAt(0) == '/';
        if (windowsNonUriAbsolutePath1.matcher(pathString).find()) {
            if (pathString.indexOf(47) != -1) {
                throw new IOException("Invalid path string " + pathString);
            }
            pathString = pathString.replace('\\', '/');
            return "file:" + (slashed ? "" : "/") + pathString;
        }
        if (windowsNonUriAbsolutePath2.matcher(pathString).find()) {
            return "file:" + (slashed ? "" : "/") + pathString;
        }
        if (pathString.indexOf(58) == -1 && pathString.indexOf(92) != -1) {
            pathString = pathString.replace('\\', '/');
        }
        return pathString;
    }

    private static URI stringToUri(String pathString) throws IOException {
        String scheme = null;
        String authority = null;
        int start = 0;
        pathString = PathData.normalizeWindowsPath(pathString);
        int colon = pathString.indexOf(58);
        int slash = pathString.indexOf(47);
        if (colon > 0 && slash == colon + 1) {
            scheme = pathString.substring(0, colon);
            start = colon + 1;
        }
        if (pathString.startsWith("//", start) && pathString.length() - start > 2) {
            int nextSlash = pathString.indexOf(47, start += 2);
            int authEnd = nextSlash > 0 ? nextSlash : pathString.length();
            authority = pathString.substring(start, authEnd);
            start = authEnd;
        }
        String path = pathString.substring(start, pathString.length());
        try {
            return new URI(scheme, authority, path, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public int compareTo(PathData o) {
        return this.path.compareTo(o.path);
    }

    public boolean equals(Object o) {
        return o != null && o instanceof PathData && this.path.equals(((PathData)o).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    protected static enum PathType {
        HAS_SCHEME,
        SCHEMELESS_ABSOLUTE,
        RELATIVE;

    }

    protected static enum FileTypeRequirement {
        SHOULD_NOT_BE_DIRECTORY,
        SHOULD_BE_DIRECTORY;

    }
}

