/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import org.apache.flink.cep.nfa.DeweyNumber;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class DeweyNumberTest
extends TestLogger {
    @Test
    public void testDeweyNumberGeneration() {
        DeweyNumber start = new DeweyNumber(1);
        DeweyNumber increased = start.increase();
        DeweyNumber increaseAddStage = increased.addStage();
        DeweyNumber startAddStage = start.addStage();
        DeweyNumber startAddStageIncreased = startAddStage.increase();
        DeweyNumber startAddStageIncreasedAddStage = startAddStageIncreased.addStage();
        Assert.assertEquals((Object)DeweyNumber.fromString((String)"1"), (Object)start);
        Assert.assertEquals((Object)DeweyNumber.fromString((String)"2"), (Object)increased);
        Assert.assertEquals((Object)DeweyNumber.fromString((String)"2.0"), (Object)increaseAddStage);
        Assert.assertEquals((Object)DeweyNumber.fromString((String)"1.0"), (Object)startAddStage);
        Assert.assertEquals((Object)DeweyNumber.fromString((String)"1.1"), (Object)startAddStageIncreased);
        Assert.assertEquals((Object)DeweyNumber.fromString((String)"1.1.0"), (Object)startAddStageIncreasedAddStage);
        Assert.assertTrue((boolean)startAddStage.isCompatibleWith(start));
        Assert.assertTrue((boolean)startAddStageIncreased.isCompatibleWith(startAddStage));
        Assert.assertTrue((boolean)startAddStageIncreasedAddStage.isCompatibleWith(startAddStageIncreased));
        Assert.assertFalse((boolean)startAddStageIncreasedAddStage.isCompatibleWith(startAddStage));
        Assert.assertFalse((boolean)increaseAddStage.isCompatibleWith(startAddStage));
        Assert.assertFalse((boolean)startAddStage.isCompatibleWith(increaseAddStage));
        Assert.assertFalse((boolean)startAddStageIncreased.isCompatibleWith(startAddStageIncreasedAddStage));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testZeroSplitsDeweyNumber() {
        DeweyNumber.fromString((String)".");
    }
}

