/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.cep.Event;
import org.apache.flink.cep.SubEvent;
import org.apache.flink.cep.nfa.NFA;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.cep.pattern.conditions.SimpleCondition;
import org.apache.flink.cep.utils.NFATestUtilities;
import org.apache.flink.cep.utils.NFAUtils;
import org.apache.flink.shaded.guava30.com.google.common.collect.Lists;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.TestLogger;
import org.junit.Test;

public class IterativeConditionsITCase
extends TestLogger {
    private final Event startEvent1 = new Event(40, "start", 1.0);
    private final Event startEvent2 = new Event(40, "start", 2.0);
    private final Event startEvent3 = new Event(40, "start", 3.0);
    private final Event startEvent4 = new Event(40, "start", 4.0);
    private final SubEvent middleEvent1 = new SubEvent(41, "foo1", 1.0, 10.0);
    private final SubEvent middleEvent2 = new SubEvent(42, "foo2", 2.0, 10.0);
    private final SubEvent middleEvent3 = new SubEvent(43, "foo3", 3.0, 10.0);
    private final SubEvent middleEvent4 = new SubEvent(43, "foo4", 1.0, 10.0);
    private final Event nextOne = new Event(44, "next-one", 1.0);
    private final Event endEvent = new Event(46, "end", 1.0);

    @Test
    public void testIterativeWithBranchingPatternEager() throws Exception {
        List<List<Event>> actual = this.testIterativeWithBranchingPattern(true);
        NFATestUtilities.comparePatterns(actual, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{this.startEvent1, this.endEvent, this.middleEvent1, this.middleEvent2, this.middleEvent4}), Lists.newArrayList((Object[])new Event[]{this.startEvent1, this.endEvent, this.middleEvent2, this.middleEvent1}), Lists.newArrayList((Object[])new Event[]{this.startEvent1, this.endEvent, this.middleEvent1}), Lists.newArrayList((Object[])new Event[]{this.startEvent2, this.endEvent, this.middleEvent3, this.middleEvent4}), Lists.newArrayList((Object[])new Event[]{this.startEvent2, this.endEvent, this.middleEvent3})}));
    }

    @Test
    public void testIterativeWithBranchingPatternCombinations() throws Exception {
        List<List<Event>> actual = this.testIterativeWithBranchingPattern(false);
        NFATestUtilities.comparePatterns(actual, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{this.startEvent1, this.endEvent, this.middleEvent1, this.middleEvent2, this.middleEvent4}), Lists.newArrayList((Object[])new Event[]{this.startEvent1, this.endEvent, this.middleEvent2, this.middleEvent1}), Lists.newArrayList((Object[])new Event[]{this.startEvent1, this.endEvent, this.middleEvent3, this.middleEvent1}), Lists.newArrayList((Object[])new Event[]{this.startEvent2, this.endEvent, this.middleEvent3, this.middleEvent4}), Lists.newArrayList((Object[])new Event[]{this.startEvent1, this.endEvent, this.middleEvent4, this.middleEvent1}), Lists.newArrayList((Object[])new Event[]{this.startEvent1, this.endEvent, this.middleEvent1}), Lists.newArrayList((Object[])new Event[]{this.startEvent2, this.endEvent, this.middleEvent3})}));
    }

    private List<List<Event>> testIterativeWithBranchingPattern(boolean eager) throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)this.startEvent1, 1L));
        inputEvents.add(new StreamRecord((Object)this.middleEvent1, 2L));
        inputEvents.add(new StreamRecord((Object)this.middleEvent2, 3L));
        inputEvents.add(new StreamRecord((Object)this.startEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)this.middleEvent3, 5L));
        inputEvents.add(new StreamRecord((Object)this.middleEvent4, 5L));
        inputEvents.add(new StreamRecord((Object)this.nextOne, 6L));
        inputEvents.add(new StreamRecord((Object)this.endEvent, 8L));
        Pattern pattern = eager ? Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("start"))).followedBy("middle").subtype(SubEvent.class).where((IterativeCondition)new MySubeventIterCondition()).oneOrMore().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("end"))) : Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("start"))).followedBy("middle").subtype(SubEvent.class).where((IterativeCondition)new MySubeventIterCondition()).oneOrMore().allowCombinations().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("end")));
        NFA nfa = NFAUtils.compile(pattern, false);
        return NFATestUtilities.feedNFA(inputEvents, nfa);
    }

    @Test
    public void testIterativeWithLoopingStartingEager() throws Exception {
        List<List<Event>> actual = this.testIterativeWithLoopingStarting(true);
        NFATestUtilities.comparePatterns(actual, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{this.startEvent1, this.startEvent2, this.endEvent}), Lists.newArrayList((Object[])new Event[]{this.startEvent1, this.endEvent}), Lists.newArrayList((Object[])new Event[]{this.startEvent2, this.endEvent}), Lists.newArrayList((Object[])new Event[]{this.startEvent3, this.endEvent}), Lists.newArrayList((Object[])new Event[]{this.endEvent})}));
    }

    @Test
    public void testIterativeWithLoopingStartingCombination() throws Exception {
        List<List<Event>> actual = this.testIterativeWithLoopingStarting(false);
        NFATestUtilities.comparePatterns(actual, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{this.startEvent1, this.startEvent2, this.endEvent}), Lists.newArrayList((Object[])new Event[]{this.startEvent1, this.startEvent3, this.endEvent}), Lists.newArrayList((Object[])new Event[]{this.startEvent1, this.endEvent}), Lists.newArrayList((Object[])new Event[]{this.startEvent2, this.endEvent}), Lists.newArrayList((Object[])new Event[]{this.startEvent3, this.endEvent}), Lists.newArrayList((Object[])new Event[]{this.endEvent})}));
    }

    private List<List<Event>> testIterativeWithLoopingStarting(boolean eager) throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)this.startEvent1, 1L));
        inputEvents.add(new StreamRecord((Object)this.startEvent2, 2L));
        inputEvents.add(new StreamRecord((Object)this.startEvent3, 3L));
        inputEvents.add(new StreamRecord((Object)this.endEvent, 4L));
        Pattern pattern = eager ? Pattern.begin((String)"start").where((IterativeCondition)new MyEventIterCondition()).oneOrMore().optional().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("end"))) : Pattern.begin((String)"start").where((IterativeCondition)new MyEventIterCondition()).oneOrMore().allowCombinations().optional().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("end")));
        NFA nfa = NFAUtils.compile(pattern, false);
        return NFATestUtilities.feedNFA(inputEvents, nfa);
    }

    @Test
    public void testIterativeWithPrevPatternDependency() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)this.startEvent1, 1L));
        inputEvents.add(new StreamRecord((Object)this.startEvent2, 2L));
        inputEvents.add(new StreamRecord((Object)this.endEvent, 4L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("start"))).oneOrMore().followedBy("end").where((IterativeCondition)new IterativeCondition<Event>(){
            private static final long serialVersionUID = 7056763917392056548L;

            public boolean filter(Event value, IterativeCondition.Context<Event> ctx) throws Exception {
                if (!value.getName().equals("end")) {
                    return false;
                }
                double sum = 0.0;
                for (Event event : ctx.getEventsForPattern("start")) {
                    sum += event.getPrice();
                }
                return Double.compare(sum, 2.0) >= 0;
            }
        });
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{this.startEvent1, this.startEvent2, this.endEvent}), Lists.newArrayList((Object[])new Event[]{this.startEvent2, this.endEvent})}));
    }

    @Test
    public void testIterativeWithABACPattern() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)this.startEvent1, 1L));
        inputEvents.add(new StreamRecord((Object)this.middleEvent1, 2L));
        inputEvents.add(new StreamRecord((Object)this.startEvent2, 2L));
        inputEvents.add(new StreamRecord((Object)this.startEvent3, 2L));
        inputEvents.add(new StreamRecord((Object)this.middleEvent2, 2L));
        inputEvents.add(new StreamRecord((Object)this.startEvent4, 2L));
        inputEvents.add(new StreamRecord((Object)this.middleEvent3, 2L));
        inputEvents.add(new StreamRecord((Object)this.middleEvent4, 2L));
        inputEvents.add(new StreamRecord((Object)this.endEvent, 4L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("start"))).followedByAny("middle1").subtype(SubEvent.class).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().startsWith("foo"))).followedBy("middle2").where((IterativeCondition)new IterativeCondition<Event>(){
            private static final long serialVersionUID = -1223388426808292695L;

            public boolean filter(Event value, IterativeCondition.Context<Event> ctx) throws Exception {
                if (!value.getName().equals("start")) {
                    return false;
                }
                double sum = 0.0;
                for (Event e : ctx.getEventsForPattern("middle2")) {
                    sum += e.getPrice();
                }
                return Double.compare(sum += value.getPrice(), 5.0) <= 0;
            }
        }).oneOrMore().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("end")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{this.startEvent1, this.startEvent2, this.startEvent3, this.middleEvent1, this.endEvent}), Lists.newArrayList((Object[])new Event[]{this.startEvent1, this.middleEvent1, this.startEvent2, this.endEvent}), Lists.newArrayList((Object[])new Event[]{this.startEvent1, this.middleEvent2, this.startEvent4, this.endEvent}), Lists.newArrayList((Object[])new Event[]{this.startEvent2, this.middleEvent2, this.startEvent4, this.endEvent}), Lists.newArrayList((Object[])new Event[]{this.startEvent3, this.middleEvent2, this.startEvent4, this.endEvent})}));
    }

    @Test
    public void testIterativeWithPrevPatternDependencyAfterBranching() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)this.startEvent1, 1L));
        inputEvents.add(new StreamRecord((Object)this.startEvent2, 2L));
        inputEvents.add(new StreamRecord((Object)this.middleEvent1, 4L));
        inputEvents.add(new StreamRecord((Object)this.startEvent3, 5L));
        inputEvents.add(new StreamRecord((Object)this.middleEvent2, 6L));
        inputEvents.add(new StreamRecord((Object)this.endEvent, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("start"))).oneOrMore().followedByAny("middle1").subtype(SubEvent.class).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().startsWith("foo"))).followedByAny("end").where((IterativeCondition)new IterativeCondition<Event>(){
            private static final long serialVersionUID = 7056763917392056548L;

            public boolean filter(Event value, IterativeCondition.Context<Event> ctx) throws Exception {
                if (!value.getName().equals("end")) {
                    return false;
                }
                double sum = 0.0;
                for (Event event : ctx.getEventsForPattern("start")) {
                    sum += event.getPrice();
                }
                return Double.compare(sum, 2.0) >= 0;
            }
        });
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{this.startEvent1, this.startEvent2, this.middleEvent1, this.endEvent}), Lists.newArrayList((Object[])new Event[]{this.startEvent2, this.middleEvent1, this.endEvent}), Lists.newArrayList((Object[])new Event[]{this.startEvent1, this.startEvent2, this.middleEvent2, this.endEvent}), Lists.newArrayList((Object[])new Event[]{this.startEvent1, this.startEvent2, this.startEvent3, this.middleEvent2, this.endEvent}), Lists.newArrayList((Object[])new Event[]{this.startEvent2, this.startEvent3, this.middleEvent2, this.endEvent}), Lists.newArrayList((Object[])new Event[]{this.startEvent2, this.middleEvent2, this.endEvent}), Lists.newArrayList((Object[])new Event[]{this.startEvent3, this.middleEvent2, this.endEvent})}));
    }

    private static class MyEventIterCondition
    extends IterativeCondition<Event> {
        private static final long serialVersionUID = 6215754202506583964L;

        private MyEventIterCondition() {
        }

        public boolean filter(Event value, IterativeCondition.Context<Event> ctx) throws Exception {
            if (!value.getName().equals("start")) {
                return false;
            }
            double sum = 0.0;
            for (Event event : ctx.getEventsForPattern("start")) {
                sum += event.getPrice();
            }
            return Double.compare(sum += value.getPrice(), 5.0) < 0;
        }
    }

    private static class MySubeventIterCondition
    extends IterativeCondition<SubEvent> {
        private static final long serialVersionUID = 6215754202506583964L;

        private MySubeventIterCondition() {
        }

        public boolean filter(SubEvent value, IterativeCondition.Context<SubEvent> ctx) throws Exception {
            if (!value.getName().startsWith("foo")) {
                return false;
            }
            double sum = 0.0;
            for (Event event : ctx.getEventsForPattern("middle")) {
                sum += event.getPrice();
            }
            return Double.compare(sum += value.getPrice(), 5.0) < 0;
        }
    }
}

