/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.cep.Event;
import org.apache.flink.cep.SubEvent;
import org.apache.flink.cep.nfa.ComputationState;
import org.apache.flink.cep.nfa.NFA;
import org.apache.flink.cep.nfa.NFAState;
import org.apache.flink.cep.nfa.aftermatch.AfterMatchSkipStrategy;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBuffer;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferAccessor;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.pattern.Quantifier;
import org.apache.flink.cep.pattern.WithinType;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.cep.pattern.conditions.SimpleCondition;
import org.apache.flink.cep.time.TimerService;
import org.apache.flink.cep.utils.NFATestHarness;
import org.apache.flink.cep.utils.NFATestUtilities;
import org.apache.flink.cep.utils.NFAUtils;
import org.apache.flink.cep.utils.TestSharedBuffer;
import org.apache.flink.cep.utils.TestTimerService;
import org.apache.flink.shaded.guava30.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class NFAITCase
extends TestLogger {
    private SharedBuffer<Event> sharedBuffer;
    private SharedBufferAccessor<Event> sharedBufferAccessor;

    @Before
    public void init() {
        this.sharedBuffer = TestSharedBuffer.createTestBuffer(Event.createTypeSerializer());
        this.sharedBufferAccessor = this.sharedBuffer.getAccessor();
    }

    @After
    public void clear() throws Exception {
        this.sharedBufferAccessor.close();
    }

    @Test
    public void testNoConditionNFA() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event a = new Event(40, "a", 1.0);
        Event b = new Event(41, "b", 2.0);
        Event c = new Event(42, "c", 3.0);
        Event d = new Event(43, "d", 4.0);
        Event e = new Event(44, "e", 5.0);
        inputEvents.add(new StreamRecord((Object)a, 1L));
        inputEvents.add(new StreamRecord((Object)b, 2L));
        inputEvents.add(new StreamRecord((Object)c, 3L));
        inputEvents.add(new StreamRecord((Object)d, 4L));
        inputEvents.add(new StreamRecord((Object)e, 5L));
        Pattern pattern = Pattern.begin((String)"start").followedBy("end");
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a, b}), Lists.newArrayList((Object[])new Event[]{b, c}), Lists.newArrayList((Object[])new Event[]{c, d}), Lists.newArrayList((Object[])new Event[]{d, e})}));
    }

    @Test
    public void testNoConditionLoopingNFA() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event a = new Event(40, "a", 1.0);
        Event b = new Event(41, "b", 2.0);
        Event c = new Event(42, "c", 3.0);
        Event d = new Event(43, "d", 4.0);
        Event e = new Event(44, "e", 5.0);
        inputEvents.add(new StreamRecord((Object)a, 1L));
        inputEvents.add(new StreamRecord((Object)b, 2L));
        inputEvents.add(new StreamRecord((Object)c, 3L));
        inputEvents.add(new StreamRecord((Object)d, 4L));
        inputEvents.add(new StreamRecord((Object)e, 5L));
        Pattern pattern = Pattern.begin((String)"start").followedBy("end").oneOrMore();
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a, b, c, d, e}), Lists.newArrayList((Object[])new Event[]{a, b, c, d}), Lists.newArrayList((Object[])new Event[]{a, b, c}), Lists.newArrayList((Object[])new Event[]{a, b}), Lists.newArrayList((Object[])new Event[]{b, c, d, e}), Lists.newArrayList((Object[])new Event[]{b, c, d}), Lists.newArrayList((Object[])new Event[]{b, c}), Lists.newArrayList((Object[])new Event[]{c, d, e}), Lists.newArrayList((Object[])new Event[]{c, d}), Lists.newArrayList((Object[])new Event[]{d, e})}));
    }

    @Test
    public void testAnyWithNoConditionNFA() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event a = new Event(40, "a", 1.0);
        Event b = new Event(41, "b", 2.0);
        Event c = new Event(42, "c", 3.0);
        Event d = new Event(43, "d", 4.0);
        Event e = new Event(44, "e", 5.0);
        inputEvents.add(new StreamRecord((Object)a, 1L));
        inputEvents.add(new StreamRecord((Object)b, 2L));
        inputEvents.add(new StreamRecord((Object)c, 3L));
        inputEvents.add(new StreamRecord((Object)d, 4L));
        inputEvents.add(new StreamRecord((Object)e, 5L));
        Pattern pattern = Pattern.begin((String)"start").followedByAny("end");
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a, b}), Lists.newArrayList((Object[])new Event[]{a, c}), Lists.newArrayList((Object[])new Event[]{a, d}), Lists.newArrayList((Object[])new Event[]{a, e}), Lists.newArrayList((Object[])new Event[]{b, c}), Lists.newArrayList((Object[])new Event[]{b, d}), Lists.newArrayList((Object[])new Event[]{b, e}), Lists.newArrayList((Object[])new Event[]{c, d}), Lists.newArrayList((Object[])new Event[]{c, e}), Lists.newArrayList((Object[])new Event[]{d, e})}));
    }

    @Test
    public void testSimplePatternNFA() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(41, "start", 1.0);
        SubEvent middleEvent = new SubEvent(42, "foo", 1.0, 10.0);
        Event endEvent = new Event(43, "end", 1.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)new Event(43, "foobar", 1.0), 2L));
        inputEvents.add(new StreamRecord((Object)new SubEvent(41, "barfoo", 1.0, 5.0), 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent, 3L));
        inputEvents.add(new StreamRecord((Object)new Event(43, "start", 1.0), 4L));
        inputEvents.add(new StreamRecord((Object)endEvent, 5L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("start"))).followedBy("middle").subtype(SubEvent.class).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getVolume() > 5.0)).followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("end")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent, endEvent})}));
    }

    @Test
    public void testStrictContinuityWithResults() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event end = new Event(42, "b", 4.0);
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)end, 5L));
        Pattern pattern = Pattern.begin((String)"middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).next("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{middleEvent1, end})}));
    }

    @Test
    public void testStrictContinuityNoResults() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "c", 3.0);
        Event end = new Event(43, "b", 4.0);
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)end, 5L));
        Pattern pattern = Pattern.begin((String)"middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).next("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList());
    }

    @Test
    public void testSimplePatternWithTimeWindowNFAWithinFirstAndLast() throws Exception {
        ArrayList<StreamRecord<Event>> events = new ArrayList<StreamRecord<Event>>();
        events.add(new StreamRecord((Object)new Event(1, "start", 1.0), 1L));
        Event startEvent = new Event(2, "start", 1.0);
        events.add(new StreamRecord((Object)startEvent, 2L));
        Event middleEvent = new Event(3, "middle", 1.0);
        events.add(new StreamRecord((Object)middleEvent, 3L));
        events.add(new StreamRecord((Object)new Event(4, "foobar", 1.0), 4L));
        Event endEvent = new Event(5, "end", 1.0);
        events.add(new StreamRecord((Object)endEvent, 11L));
        events.add(new StreamRecord((Object)new Event(6, "end", 1.0), 13L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("start"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("middle"))).followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("end"))).within(Time.milliseconds((long)10L));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(events, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent, endEvent})}));
    }

    @Test
    public void testSimplePatternWithTimeWindowNFAWithinPreviousAndCurrent() throws Exception {
        ArrayList<StreamRecord<Event>> events = new ArrayList<StreamRecord<Event>>();
        Event startEvent1 = new Event(1, "start", 1.0);
        events.add(new StreamRecord((Object)startEvent1, 1L));
        Event startEvent2 = new Event(2, "start", 1.0);
        events.add(new StreamRecord((Object)startEvent2, 2L));
        Event middleEvent = new Event(3, "middle", 1.0);
        events.add(new StreamRecord((Object)middleEvent, 3L));
        events.add(new StreamRecord((Object)new Event(4, "foobar", 1.0), 4L));
        Event endEvent = new Event(5, "end", 1.0);
        events.add(new StreamRecord((Object)endEvent, 11L));
        events.add(new StreamRecord((Object)new Event(6, "end", 1.0), 13L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("start"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("middle"))).followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("end"))).within(Time.milliseconds((long)9L), WithinType.PREVIOUS_AND_CURRENT);
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(events, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent1, middleEvent, endEvent}), Lists.newArrayList((Object[])new Event[]{startEvent2, middleEvent, endEvent})}));
    }

    @Test
    public void testSimplePatternWithTimeoutHandlingWithinFirstAndLast() throws Exception {
        ArrayList<StreamRecord> events = new ArrayList<StreamRecord>();
        ArrayList resultingPatterns = new ArrayList();
        HashSet resultingTimeoutPatterns = new HashSet();
        HashSet<Tuple2> expectedTimeoutPatterns = new HashSet<Tuple2>();
        events.add(new StreamRecord((Object)new Event(1, "start", 1.0), 1L));
        events.add(new StreamRecord((Object)new Event(2, "start", 1.0), 2L));
        events.add(new StreamRecord((Object)new Event(3, "middle", 1.0), 3L));
        events.add(new StreamRecord((Object)new Event(4, "foobar", 1.0), 4L));
        events.add(new StreamRecord((Object)new Event(5, "end", 1.0), 11L));
        events.add(new StreamRecord((Object)new Event(6, "end", 1.0), 13L));
        HashMap<String, List<Event>> timeoutPattern1 = new HashMap<String, List<Event>>();
        timeoutPattern1.put("start", Collections.singletonList(new Event(1, "start", 1.0)));
        timeoutPattern1.put("middle", Collections.singletonList(new Event(3, "middle", 1.0)));
        HashMap<String, List<Event>> timeoutPattern2 = new HashMap<String, List<Event>>();
        timeoutPattern2.put("start", Collections.singletonList(new Event(2, "start", 1.0)));
        timeoutPattern2.put("middle", Collections.singletonList(new Event(3, "middle", 1.0)));
        HashMap<String, List<Event>> timeoutPattern3 = new HashMap<String, List<Event>>();
        timeoutPattern3.put("start", Collections.singletonList(new Event(1, "start", 1.0)));
        HashMap<String, List<Event>> timeoutPattern4 = new HashMap<String, List<Event>>();
        timeoutPattern4.put("start", Collections.singletonList(new Event(2, "start", 1.0)));
        expectedTimeoutPatterns.add(Tuple2.of(timeoutPattern1, (Object)11L));
        expectedTimeoutPatterns.add(Tuple2.of(timeoutPattern2, (Object)12L));
        expectedTimeoutPatterns.add(Tuple2.of(timeoutPattern3, (Object)11L));
        expectedTimeoutPatterns.add(Tuple2.of(timeoutPattern4, (Object)12L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("start"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("middle"))).followedByAny("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("end"))).within(Time.milliseconds((long)10L));
        NFA nfa = NFAUtils.compile(pattern, true);
        NFAState nfaState = nfa.createInitialNFAState();
        for (StreamRecord event : events) {
            Collection timeoutPatterns = (Collection)nfa.advanceTime(this.sharedBufferAccessor, (NFAState)nfaState, (long)event.getTimestamp(), (AfterMatchSkipStrategy)AfterMatchSkipStrategy.noSkip()).f1;
            Collection matchedPatterns = nfa.process(this.sharedBufferAccessor, nfaState, event.getValue(), event.getTimestamp(), (AfterMatchSkipStrategy)AfterMatchSkipStrategy.noSkip(), (TimerService)new TestTimerService());
            resultingPatterns.addAll(matchedPatterns);
            resultingTimeoutPatterns.addAll(timeoutPatterns);
        }
        Assert.assertEquals((long)1L, (long)resultingPatterns.size());
        Assert.assertEquals((long)expectedTimeoutPatterns.size(), (long)resultingTimeoutPatterns.size());
        Assert.assertEquals(expectedTimeoutPatterns, resultingTimeoutPatterns);
    }

    @Test
    public void testSimplePatternWithTimeoutHandlingWithinPreviousAndCurrent() throws Exception {
        ArrayList<StreamRecord> events = new ArrayList<StreamRecord>();
        ArrayList resultingPatterns = new ArrayList();
        HashSet resultingTimeoutPatterns = new HashSet();
        HashSet<Tuple2> expectedTimeoutPatterns = new HashSet<Tuple2>();
        events.add(new StreamRecord((Object)new Event(1, "start", 1.0), 1L));
        events.add(new StreamRecord((Object)new Event(2, "start", 1.0), 2L));
        events.add(new StreamRecord((Object)new Event(3, "middle", 1.0), 3L));
        events.add(new StreamRecord((Object)new Event(4, "foobar", 1.0), 4L));
        events.add(new StreamRecord((Object)new Event(5, "end", 1.0), 11L));
        events.add(new StreamRecord((Object)new Event(6, "end", 1.0), 13L));
        HashMap<String, List<Event>> timeoutPattern1 = new HashMap<String, List<Event>>();
        timeoutPattern1.put("start", Collections.singletonList(new Event(1, "start", 1.0)));
        timeoutPattern1.put("middle", Collections.singletonList(new Event(3, "middle", 1.0)));
        HashMap<String, List<Event>> timeoutPattern2 = new HashMap<String, List<Event>>();
        timeoutPattern2.put("start", Collections.singletonList(new Event(2, "start", 1.0)));
        timeoutPattern2.put("middle", Collections.singletonList(new Event(3, "middle", 1.0)));
        expectedTimeoutPatterns.add(Tuple2.of(timeoutPattern1, (Object)13L));
        expectedTimeoutPatterns.add(Tuple2.of(timeoutPattern2, (Object)13L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("start"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("middle"))).followedByAny("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("end"))).within(Time.milliseconds((long)10L), WithinType.PREVIOUS_AND_CURRENT);
        NFA nfa = NFAUtils.compile(pattern, true);
        NFAState nfaState = nfa.createInitialNFAState();
        for (StreamRecord event : events) {
            Collection timeoutPatterns = (Collection)nfa.advanceTime(this.sharedBufferAccessor, (NFAState)nfaState, (long)event.getTimestamp(), (AfterMatchSkipStrategy)AfterMatchSkipStrategy.noSkip()).f1;
            Collection matchedPatterns = nfa.process(this.sharedBufferAccessor, nfaState, event.getValue(), event.getTimestamp(), (AfterMatchSkipStrategy)AfterMatchSkipStrategy.noSkip(), (TimerService)new TestTimerService());
            resultingPatterns.addAll(matchedPatterns);
            resultingTimeoutPatterns.addAll(timeoutPatterns);
        }
        Assert.assertEquals((long)2L, (long)resultingPatterns.size());
        Assert.assertEquals((long)expectedTimeoutPatterns.size(), (long)resultingTimeoutPatterns.size());
        Assert.assertEquals(expectedTimeoutPatterns, resultingTimeoutPatterns);
    }

    @Test
    public void testPendingStateMatchesWithinFirstAndLast() throws Exception {
        this.testPendingStateMatches(WithinType.FIRST_AND_LAST);
    }

    @Test
    public void testPendingStateMatchesWithinPreviousAndCurrent() throws Exception {
        this.testPendingStateMatches(WithinType.PREVIOUS_AND_CURRENT);
    }

    private void testPendingStateMatches(WithinType withinType) throws Exception {
        ArrayList<StreamRecord> events = new ArrayList<StreamRecord>();
        HashSet resultingPendingMatches = new HashSet();
        HashSet expectedPendingMatches = new HashSet();
        events.add(new StreamRecord((Object)new Event(1, "start", 1.0), 1L));
        events.add(new StreamRecord((Object)new Event(2, "middle", 1.0), 4L));
        events.add(new StreamRecord((Object)new Event(3, "start", 1.0), 5L));
        events.add(new StreamRecord((Object)new Event(4, "start", 1.0), 11L));
        events.add(new StreamRecord((Object)new Event(5, "middle", 1.0), 18L));
        HashMap<String, List<Event>> pendingMatches1 = new HashMap<String, List<Event>>();
        pendingMatches1.put("start", Collections.singletonList(new Event(3, "start", 1.0)));
        HashMap<String, List<Event>> pendingMatches2 = new HashMap<String, List<Event>>();
        pendingMatches2.put("start", Collections.singletonList(new Event(4, "start", 1.0)));
        expectedPendingMatches.add(pendingMatches1);
        expectedPendingMatches.add(pendingMatches2);
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("start"))).notFollowedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("middle"))).within(Time.milliseconds((long)5L), withinType);
        NFA nfa = NFAUtils.compile(pattern, true);
        NFAState nfaState = nfa.createInitialNFAState();
        for (StreamRecord event : events) {
            Collection pendingMatches = (Collection)nfa.advanceTime(this.sharedBufferAccessor, (NFAState)nfaState, (long)event.getTimestamp(), (AfterMatchSkipStrategy)AfterMatchSkipStrategy.noSkip()).f0;
            resultingPendingMatches.addAll(pendingMatches);
            nfa.process(this.sharedBufferAccessor, nfaState, event.getValue(), event.getTimestamp(), (AfterMatchSkipStrategy)AfterMatchSkipStrategy.noSkip(), (TimerService)new TestTimerService());
        }
        Assert.assertEquals((long)2L, (long)resultingPendingMatches.size());
        Assert.assertEquals((long)expectedPendingMatches.size(), (long)resultingPendingMatches.size());
        Assert.assertEquals(expectedPendingMatches, resultingPendingMatches);
    }

    @Test
    public void testBranchingPattern() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "start", 1.0);
        SubEvent middleEvent1 = new SubEvent(41, "foo1", 1.0, 10.0);
        SubEvent middleEvent2 = new SubEvent(42, "foo2", 1.0, 10.0);
        SubEvent middleEvent3 = new SubEvent(43, "foo3", 1.0, 10.0);
        SubEvent nextOne1 = new SubEvent(44, "next-one", 1.0, 2.0);
        SubEvent nextOne2 = new SubEvent(45, "next-one", 1.0, 2.0);
        Event endEvent = new Event(46, "end", 1.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 5L));
        inputEvents.add(new StreamRecord((Object)nextOne1, 6L));
        inputEvents.add(new StreamRecord((Object)nextOne2, 7L));
        inputEvents.add(new StreamRecord((Object)endEvent, 8L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("start"))).followedByAny("middle-first").subtype(SubEvent.class).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getVolume() > 5.0)).followedByAny("middle-second").subtype(SubEvent.class).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("next-one"))).followedByAny("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("end")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, nextOne1, endEvent}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent2, nextOne1, endEvent}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent3, nextOne1, endEvent}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, nextOne2, endEvent}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent2, nextOne2, endEvent}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent3, nextOne2, endEvent})}));
    }

    @Test
    public void testComplexBranchingAfterZeroOrMore() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event middleEvent3 = new Event(43, "a", 4.0);
        Event end1 = new Event(44, "b", 5.0);
        Event end2 = new Event(45, "d", 6.0);
        Event end3 = new Event(46, "d", 7.0);
        Event end4 = new Event(47, "e", 8.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 5L));
        inputEvents.add(new StreamRecord((Object)end1, 6L));
        inputEvents.add(new StreamRecord((Object)end2, 7L));
        inputEvents.add(new StreamRecord((Object)end3, 8L));
        inputEvents.add(new StreamRecord((Object)end4, 9L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().allowCombinations().optional().followedByAny("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).followedByAny("end2").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d"))).followedByAny("end3").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("e")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3, end1, end2, end4}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, end1, end2, end4}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent3, end1, end2, end4}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent2, middleEvent3, end1, end2, end4}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, end1, end2, end4}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent2, end1, end2, end4}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent3, end1, end2, end4}), Lists.newArrayList((Object[])new Event[]{startEvent, end1, end2, end4}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3, end1, end3, end4}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, end1, end3, end4}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent3, end1, end3, end4}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent2, middleEvent3, end1, end3, end4}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, end1, end3, end4}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent2, end1, end3, end4}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent3, end1, end3, end4}), Lists.newArrayList((Object[])new Event[]{startEvent, end1, end3, end4})}));
    }

    @Test
    public void testZeroOrMore() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event end1 = new Event(44, "b", 5.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)end1, 6L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().allowCombinations().optional().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent2, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, end1})}));
    }

    @Test
    public void testEagerZeroOrMore() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event middleEvent3 = new Event(43, "a", 4.0);
        Event end1 = new Event(44, "b", 5.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)new Event(50, "d", 6.0), 5L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 6L));
        inputEvents.add(new StreamRecord((Object)end1, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().optional().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, end1})}));
    }

    @Test
    public void testBeginWithZeroOrMore() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event middleEvent1 = new Event(40, "a", 2.0);
        Event middleEvent2 = new Event(41, "a", 3.0);
        Event middleEvent3 = new Event(41, "a", 3.0);
        Event end = new Event(42, "b", 4.0);
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 5L));
        inputEvents.add(new StreamRecord((Object)end, 6L));
        Pattern pattern = Pattern.begin((String)"middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().optional().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{middleEvent1, middleEvent2, middleEvent3, end}), Lists.newArrayList((Object[])new Event[]{middleEvent1, middleEvent2, end}), Lists.newArrayList((Object[])new Event[]{middleEvent2, middleEvent3, end}), Lists.newArrayList((Object[])new Event[]{middleEvent1, end}), Lists.newArrayList((Object[])new Event[]{middleEvent2, end}), Lists.newArrayList((Object[])new Event[]{middleEvent3, end}), Lists.newArrayList((Object[])new Event[]{end})}));
    }

    @Test
    public void testZeroOrMoreAfterZeroOrMore() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "d", 3.0);
        Event middleEvent3 = new Event(43, "d", 4.0);
        Event end = new Event(44, "e", 4.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 5L));
        inputEvents.add(new StreamRecord((Object)end, 6L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("middle-first").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().allowCombinations().optional().followedBy("middle-second").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d"))).oneOrMore().allowCombinations().optional().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("e")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent2, middleEvent3, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent2, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, end}), Lists.newArrayList((Object[])new Event[]{startEvent, end})}));
    }

    @Test
    public void testZeroOrMoreAfterBranching() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event merging = new Event(42, "f", 3.0);
        Event kleene1 = new Event(43, "d", 4.0);
        Event kleene2 = new Event(44, "d", 4.0);
        Event end = new Event(45, "e", 4.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)merging, 5L));
        inputEvents.add(new StreamRecord((Object)kleene1, 6L));
        inputEvents.add(new StreamRecord((Object)kleene2, 7L));
        inputEvents.add(new StreamRecord((Object)end, 8L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("branching").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).followedByAny("merging").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("f"))).followedByAny("kleene").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d"))).oneOrMore().allowCombinations().optional().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("e")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, merging, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, merging, kleene1, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, merging, kleene2, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, merging, kleene1, kleene2, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent2, merging, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent2, merging, kleene1, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent2, merging, kleene2, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent2, merging, kleene1, kleene2, end})}));
    }

    @Test
    public void testStrictContinuityNoResultsAfterZeroOrMore() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event start = new Event(40, "d", 2.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 2.0);
        Event middleEvent3 = new Event(43, "c", 3.0);
        Event end = new Event(44, "b", 4.0);
        inputEvents.add(new StreamRecord((Object)start, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 2L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 4L));
        inputEvents.add(new StreamRecord((Object)end, 5L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().optional().next("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList());
    }

    @Test
    public void testStrictContinuityResultsAfterZeroOrMore() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event start = new Event(40, "d", 2.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 2.0);
        Event end = new Event(43, "b", 4.0);
        inputEvents.add(new StreamRecord((Object)start, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 2L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 3L));
        inputEvents.add(new StreamRecord((Object)end, 5L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().optional().allowCombinations().next("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{start, middleEvent1, middleEvent2, end}), Lists.newArrayList((Object[])new Event[]{start, middleEvent2, end})}));
    }

    @Test
    public void testAtLeastOne() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event end1 = new Event(44, "b", 5.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)end1, 6L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().allowCombinations().followedByAny("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent2, end1})}));
    }

    @Test
    public void testBeginWithAtLeastOne() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent1 = new Event(41, "a", 2.0);
        Event startEvent2 = new Event(42, "a", 3.0);
        Event startEvent3 = new Event(42, "a", 4.0);
        Event end1 = new Event(44, "b", 5.0);
        inputEvents.add(new StreamRecord((Object)startEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)startEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)startEvent3, 5L));
        inputEvents.add(new StreamRecord((Object)end1, 6L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().allowCombinations().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent1, startEvent2, startEvent3, end1}), Lists.newArrayList((Object[])new Event[]{startEvent1, startEvent2, end1}), Lists.newArrayList((Object[])new Event[]{startEvent1, startEvent3, end1}), Lists.newArrayList((Object[])new Event[]{startEvent2, startEvent3, end1}), Lists.newArrayList((Object[])new Event[]{startEvent1, end1}), Lists.newArrayList((Object[])new Event[]{startEvent2, end1}), Lists.newArrayList((Object[])new Event[]{startEvent3, end1})}));
    }

    @Test
    public void testNextZeroOrMore() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "start", 1.0);
        Event middleEvent1 = new Event(40, "middle", 2.0);
        Event middleEvent2 = new Event(40, "middle", 3.0);
        Event middleEvent3 = new Event(40, "middle", 4.0);
        Event endEvent = new Event(46, "end", 1.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)new Event(1, "event", 1.0), 2L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 5L));
        inputEvents.add(new StreamRecord((Object)endEvent, 6L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("start"))).next("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("middle"))).oneOrMore().optional().consecutive().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("end")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, endEvent})}));
    }

    @Test
    public void testAtLeastOneEager() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event middleEvent3 = new Event(43, "a", 4.0);
        Event end1 = new Event(44, "b", 5.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 5L));
        inputEvents.add(new StreamRecord((Object)end1, 6L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().followedByAny("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent2, middleEvent3, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent3, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent2, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, end1})}));
    }

    @Test
    public void testOptional() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent = new Event(43, "a", 4.0);
        Event end1 = new Event(44, "b", 5.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent, 5L));
        inputEvents.add(new StreamRecord((Object)end1, 6L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).optional().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, end1})}));
    }

    @Test
    public void testTimes() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event middleEvent3 = new Event(43, "a", 4.0);
        Event end1 = new Event(44, "b", 5.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 2L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 4L));
        inputEvents.add(new StreamRecord((Object)end1, 6L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).next("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(2).allowCombinations().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent3, end1})}));
    }

    @Test
    public void testStartWithTimes() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event middleEvent3 = new Event(43, "a", 4.0);
        Event end1 = new Event(44, "b", 5.0);
        inputEvents.add(new StreamRecord((Object)middleEvent1, 2L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 4L));
        inputEvents.add(new StreamRecord((Object)end1, 6L));
        Pattern pattern = Pattern.begin((String)"middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(2).consecutive().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{middleEvent1, middleEvent2, end1}), Lists.newArrayList((Object[])new Event[]{middleEvent2, middleEvent3, end1})}));
    }

    @Test
    public void testTimesNonStrictWithNext() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent1, 2L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 3L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 5L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent3, 6L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).next("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(2).allowCombinations().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent3, ConsecutiveData.end})}));
    }

    @Test
    public void testTimesNotStrictWithFollowedByEager() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent1, 2L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent3, 6L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(2).followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.end})}));
    }

    @Test
    public void testTimesNotStrictWithFollowedByNotEager() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent1, 2L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent3, 6L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(2).allowCombinations().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent3, ConsecutiveData.middleEvent2, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent3, ConsecutiveData.middleEvent1, ConsecutiveData.end})}));
    }

    @Test
    public void testTimesStrictWithNextAndConsecutive() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent1, 2L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 3L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent3, 6L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).next("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(2).consecutive().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList());
    }

    @Test
    public void testStartWithOptional() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event end1 = new Event(44, "b", 5.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)end1, 6L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).optional().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, end1}), Lists.newArrayList((Object[])new Event[]{end1})}));
    }

    @Test
    public void testEndWithZeroOrMore() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event middleEvent3 = new Event(43, "a", 4.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 5L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().optional();
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1}), Lists.newArrayList((Object[])new Event[]{startEvent})}));
    }

    @Test
    public void testStartAndEndWithZeroOrMore() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event middleEvent3 = new Event(43, "a", 4.0);
        Event end1 = new Event(44, "d", 5.0);
        Event end2 = new Event(45, "d", 5.0);
        Event end3 = new Event(46, "d", 5.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 5L));
        inputEvents.add(new StreamRecord((Object)end1, 6L));
        inputEvents.add(new StreamRecord((Object)end2, 6L));
        inputEvents.add(new StreamRecord((Object)end3, 6L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().optional();
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{middleEvent1, middleEvent2, middleEvent3}), Lists.newArrayList((Object[])new Event[]{middleEvent1, middleEvent2}), Lists.newArrayList((Object[])new Event[]{middleEvent1}), Lists.newArrayList((Object[])new Event[]{middleEvent2, middleEvent3}), Lists.newArrayList((Object[])new Event[]{middleEvent2}), Lists.newArrayList((Object[])new Event[]{middleEvent3})}));
    }

    @Test
    public void testEndWithOptional() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).optional();
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1}), Lists.newArrayList((Object[])new Event[]{startEvent})}));
    }

    @Test
    public void testEndWithOneOrMore() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event middleEvent3 = new Event(43, "a", 4.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 5L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore();
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1})}));
    }

    @Test
    public void testTimesNonStrictOptional1() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 2L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(3).optional().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.end})}));
    }

    @Test
    public void testTimesNonStrictOptional2() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 2L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 4L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent2, 5L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent3, 6L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(2).allowCombinations().optional().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.end})}));
    }

    @Test
    public void testTimesNonStrictOptional3() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 2L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 4L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent2, 5L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent3, 6L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(2).optional().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.end})}));
    }

    @Test
    public void testTimesStrictOptional() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 2L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 4L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent2, 5L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent3, 6L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(2).consecutive().optional().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.end})}));
    }

    @Test
    public void testOneOrMoreStrictOptional() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 2L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 4L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent2, 5L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent3, 6L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().consecutive().optional().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent2, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.end})}));
    }

    @Test
    public void testTimesStrictOptional1() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent2, 5L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent3, 6L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).next("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(2).consecutive().optional().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.end})}));
    }

    @Test
    public void testOptionalTimesNonStrictWithNext() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent1, 2L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 3L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 5L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent3, 6L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).next("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(2).allowCombinations().optional().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.end})}));
    }

    @Test
    public void testStrictOneOrMore() throws Exception {
        List<List<Event>> resultingPatterns = this.testOneOrMore(Quantifier.ConsumingStrategy.STRICT);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.end})}));
    }

    @Test
    public void testSkipTillNextOneOrMore() throws Exception {
        List<List<Event>> resultingPatterns = this.testOneOrMore(Quantifier.ConsumingStrategy.SKIP_TILL_NEXT);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.middleEvent4, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.end})}));
    }

    @Test
    public void testSkipTillAnyOneOrMore() throws Exception {
        List<List<Event>> resultingPatterns = this.testOneOrMore(Quantifier.ConsumingStrategy.SKIP_TILL_ANY);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.middleEvent4, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent3, ConsecutiveData.middleEvent4, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent4, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent4, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.end})}));
    }

    private List<List<Event>> testOneOrMore(Quantifier.ConsumingStrategy strategy) throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)new Event(50, "d", 6.0), 2L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent3, 4L));
        inputEvents.add(new StreamRecord((Object)new Event(50, "d", 6.0), 5L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent4, 6L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore();
        switch (strategy) {
            case STRICT: {
                pattern = pattern.consecutive();
                break;
            }
            case SKIP_TILL_NEXT: {
                break;
            }
            case SKIP_TILL_ANY: {
                pattern = pattern.allowCombinations();
            }
        }
        pattern = pattern.followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        return NFATestUtilities.feedNFA(inputEvents, nfa);
    }

    @Test
    public void testStrictEagerZeroOrMore() throws Exception {
        List<List<Event>> resultingPatterns = this.testZeroOrMore(Quantifier.ConsumingStrategy.STRICT);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.end})}));
    }

    @Test
    public void testSkipTillAnyZeroOrMore() throws Exception {
        List<List<Event>> resultingPatterns = this.testZeroOrMore(Quantifier.ConsumingStrategy.SKIP_TILL_ANY);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.middleEvent4, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent4, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent3, ConsecutiveData.middleEvent4, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent4, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.end})}));
    }

    @Test
    public void testSkipTillNextZeroOrMore() throws Exception {
        List<List<Event>> resultingPatterns = this.testZeroOrMore(Quantifier.ConsumingStrategy.SKIP_TILL_NEXT);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.middleEvent4, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.end})}));
    }

    private List<List<Event>> testZeroOrMore(Quantifier.ConsumingStrategy strategy) throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)new Event(50, "d", 6.0), 2L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent3, 4L));
        inputEvents.add(new StreamRecord((Object)new Event(50, "d", 6.0), 5L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent4, 6L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().optional();
        switch (strategy) {
            case STRICT: {
                pattern = pattern.consecutive();
                break;
            }
            case SKIP_TILL_NEXT: {
                break;
            }
            case SKIP_TILL_ANY: {
                pattern = pattern.allowCombinations();
            }
        }
        pattern = pattern.followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        return NFATestUtilities.feedNFA(inputEvents, nfa);
    }

    @Test
    public void testTimesStrict() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 2L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 4L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent2, 5L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent3, 6L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(2).consecutive().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.end})}));
    }

    @Test
    public void testTimesNonStrict() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 2L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 4L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent2, 5L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent3, 6L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(2).allowCombinations().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.end})}));
    }

    @Test
    public void testStartWithZeroOrMoreStrict() throws Exception {
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().optional().consecutive();
        this.testStartWithOneOrZeroOrMoreStrict(pattern);
    }

    @Test
    public void testStartWithOneOrMoreStrict() throws Exception {
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().consecutive();
        this.testStartWithOneOrZeroOrMoreStrict(pattern);
    }

    private void testStartWithOneOrZeroOrMoreStrict(Pattern<Event, ?> pattern) throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 4L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent2, 5L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent3, 6L));
        NFA<Event> nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.middleEvent1}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.middleEvent2}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.middleEvent3})}));
    }

    @Test
    public void testTimesClearingBufferWithinFirstAndLast() throws Exception {
        this.testTimesClearingBuffer(WithinType.FIRST_AND_LAST);
    }

    @Test
    public void testTimesClearingBufferWithinPreviousAndCurrent() throws Exception {
        this.testTimesClearingBuffer(WithinType.PREVIOUS_AND_CURRENT);
    }

    private void testTimesClearingBuffer(WithinType withinType) throws Exception {
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event middleEvent3 = new Event(43, "a", 4.0);
        Event end1 = new Event(44, "b", 5.0);
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).next("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(2).followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).within(Time.milliseconds((long)8L), withinType);
        NFA nfa = NFAUtils.compile(pattern, false);
        NFAState nfaState = nfa.createInitialNFAState();
        NFATestHarness nfaTestHarness = NFATestHarness.forNFA(nfa).withNFAState(nfaState).build();
        nfaTestHarness.feedRecord((StreamRecord<Event>)new StreamRecord((Object)startEvent, 1L));
        nfaTestHarness.feedRecord((StreamRecord<Event>)new StreamRecord((Object)middleEvent1, 2L));
        nfaTestHarness.feedRecord((StreamRecord<Event>)new StreamRecord((Object)middleEvent2, 3L));
        nfaTestHarness.feedRecord((StreamRecord<Event>)new StreamRecord((Object)middleEvent3, 4L));
        nfaTestHarness.feedRecord((StreamRecord<Event>)new StreamRecord((Object)end1, 6L));
        nfa.advanceTime(this.sharedBufferAccessor, nfaState, 10L, (AfterMatchSkipStrategy)AfterMatchSkipStrategy.noSkip());
        Assert.assertEquals((long)1L, (long)nfaState.getPartialMatches().size());
        Assert.assertEquals((Object)"start", (Object)((ComputationState)nfaState.getPartialMatches().peek()).getCurrentStateName());
    }

    @Test
    public void testOptionalClearingBufferWithinFirstAndLast() throws Exception {
        this.testOptionalClearingBuffer(WithinType.FIRST_AND_LAST);
    }

    @Test
    public void testOptionalClearingBufferWithinPreviousAndCurrent() throws Exception {
        this.testOptionalClearingBuffer(WithinType.PREVIOUS_AND_CURRENT);
    }

    private void testOptionalClearingBuffer(WithinType withinType) throws Exception {
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent = new Event(43, "a", 4.0);
        Event end1 = new Event(44, "b", 5.0);
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).optional().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).within(Time.milliseconds((long)8L), withinType);
        NFA nfa = NFAUtils.compile(pattern, false);
        NFAState nfaState = nfa.createInitialNFAState();
        NFATestHarness nfaTestHarness = NFATestHarness.forNFA(nfa).withNFAState(nfaState).build();
        nfaTestHarness.feedRecord((StreamRecord<Event>)new StreamRecord((Object)startEvent, 1L));
        nfaTestHarness.feedRecord((StreamRecord<Event>)new StreamRecord((Object)middleEvent, 5L));
        nfaTestHarness.feedRecord((StreamRecord<Event>)new StreamRecord((Object)end1, 6L));
        nfa.advanceTime(this.sharedBufferAccessor, nfaState, 10L, (AfterMatchSkipStrategy)AfterMatchSkipStrategy.noSkip());
        Assert.assertEquals((long)1L, (long)nfaState.getPartialMatches().size());
        Assert.assertEquals((Object)"start", (Object)((ComputationState)nfaState.getPartialMatches().peek()).getCurrentStateName());
    }

    @Test
    public void testAtLeastOneClearingBufferWithinFirstAndLast() throws Exception {
        this.testAtLeastOneClearingBuffer(WithinType.FIRST_AND_LAST);
    }

    @Test
    public void testAtLeastOneClearingBufferWithPreviousAndCurrent() throws Exception {
        this.testAtLeastOneClearingBuffer(WithinType.PREVIOUS_AND_CURRENT);
    }

    private void testAtLeastOneClearingBuffer(WithinType withinType) throws Exception {
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event end1 = new Event(44, "b", 5.0);
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().allowCombinations().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).within(Time.milliseconds((long)8L));
        NFA nfa = NFAUtils.compile(pattern, false);
        NFAState nfaState = nfa.createInitialNFAState();
        NFATestHarness nfaTestHarness = NFATestHarness.forNFA(nfa).withNFAState(nfaState).build();
        nfaTestHarness.consumeRecord((StreamRecord<Event>)new StreamRecord((Object)startEvent, 1L));
        nfaTestHarness.consumeRecord((StreamRecord<Event>)new StreamRecord((Object)middleEvent1, 3L));
        nfaTestHarness.consumeRecord((StreamRecord<Event>)new StreamRecord((Object)middleEvent2, 4L));
        nfaTestHarness.consumeRecord((StreamRecord<Event>)new StreamRecord((Object)end1, 6L));
        nfa.advanceTime(this.sharedBufferAccessor, nfaState, 10L, (AfterMatchSkipStrategy)AfterMatchSkipStrategy.noSkip());
        Assert.assertEquals((long)1L, (long)nfaState.getPartialMatches().size());
        Assert.assertEquals((Object)"start", (Object)((ComputationState)nfaState.getPartialMatches().peek()).getCurrentStateName());
    }

    @Test
    public void testZeroOrMoreClearingBufferWithinFirstAndLast() throws Exception {
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event end1 = new Event(44, "b", 5.0);
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().allowCombinations().optional().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).within(Time.milliseconds((long)8L));
        NFA nfa = NFAUtils.compile(pattern, false);
        NFAState nfaState = nfa.createInitialNFAState();
        NFATestHarness nfaTestHarness = NFATestHarness.forNFA(nfa).withNFAState(nfaState).build();
        nfaTestHarness.consumeRecord((StreamRecord<Event>)new StreamRecord((Object)startEvent, 1L));
        nfaTestHarness.consumeRecord((StreamRecord<Event>)new StreamRecord((Object)middleEvent1, 3L));
        nfaTestHarness.consumeRecord((StreamRecord<Event>)new StreamRecord((Object)middleEvent2, 4L));
        nfaTestHarness.consumeRecord((StreamRecord<Event>)new StreamRecord((Object)end1, 6L));
        nfa.advanceTime(this.sharedBufferAccessor, nfaState, 10L, (AfterMatchSkipStrategy)AfterMatchSkipStrategy.noSkip());
        Assert.assertEquals((long)1L, (long)nfaState.getPartialMatches().size());
        Assert.assertEquals((Object)"start", (Object)((ComputationState)nfaState.getPartialMatches().peek()).getCurrentStateName());
    }

    @Test
    public void testZeroOrMoreClearingBufferWithinPreviousAndCurrent() throws Exception {
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event end1 = new Event(44, "b", 5.0);
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().allowCombinations().optional().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).within(Time.milliseconds((long)8L), WithinType.PREVIOUS_AND_CURRENT);
        NFA nfa = NFAUtils.compile(pattern, false);
        NFAState nfaState = nfa.createInitialNFAState();
        NFATestHarness nfaTestHarness = NFATestHarness.forNFA(nfa).withNFAState(nfaState).build();
        nfaTestHarness.consumeRecord((StreamRecord<Event>)new StreamRecord((Object)startEvent, 1L));
        nfaTestHarness.consumeRecord((StreamRecord<Event>)new StreamRecord((Object)middleEvent1, 3L));
        nfaTestHarness.consumeRecord((StreamRecord<Event>)new StreamRecord((Object)middleEvent2, 4L));
        nfaTestHarness.consumeRecord((StreamRecord<Event>)new StreamRecord((Object)end1, 6L));
        nfa.advanceTime(this.sharedBufferAccessor, nfaState, 10L, (AfterMatchSkipStrategy)AfterMatchSkipStrategy.noSkip());
        Assert.assertEquals((long)3L, (long)nfaState.getPartialMatches().size());
        Assert.assertEquals((Object)"middle:0middle:0start", (Object)nfaState.getPartialMatches().stream().map(c -> c.getCurrentStateName()).collect(Collectors.joining()));
    }

    @Test
    public void testBranchingPatternSkipTillNext() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "start", 1.0);
        SubEvent middleEvent1 = new SubEvent(41, "foo1", 1.0, 10.0);
        SubEvent middleEvent2 = new SubEvent(42, "foo2", 1.0, 10.0);
        SubEvent middleEvent3 = new SubEvent(43, "foo3", 1.0, 10.0);
        SubEvent nextOne1 = new SubEvent(44, "next-one", 1.0, 2.0);
        SubEvent nextOne2 = new SubEvent(45, "next-one", 1.0, 2.0);
        Event endEvent = new Event(46, "end", 1.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 5L));
        inputEvents.add(new StreamRecord((Object)nextOne1, 6L));
        inputEvents.add(new StreamRecord((Object)nextOne2, 7L));
        inputEvents.add(new StreamRecord((Object)endEvent, 8L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("start"))).followedBy("middle-first").subtype(SubEvent.class).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getVolume() > 5.0)).followedBy("middle-second").subtype(SubEvent.class).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("next-one"))).followedByAny("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("end")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> patterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(patterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, nextOne1, endEvent})}));
    }

    @Test
    public void testBranchingPatternMixedFollowedBy() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "start", 1.0);
        SubEvent middleEvent1 = new SubEvent(41, "foo1", 1.0, 10.0);
        SubEvent middleEvent2 = new SubEvent(42, "foo2", 1.0, 10.0);
        SubEvent middleEvent3 = new SubEvent(43, "foo3", 1.0, 10.0);
        SubEvent nextOne1 = new SubEvent(44, "next-one", 1.0, 2.0);
        SubEvent nextOne2 = new SubEvent(45, "next-one", 1.0, 2.0);
        Event endEvent = new Event(46, "end", 1.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 5L));
        inputEvents.add(new StreamRecord((Object)nextOne1, 6L));
        inputEvents.add(new StreamRecord((Object)nextOne2, 7L));
        inputEvents.add(new StreamRecord((Object)endEvent, 8L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("start"))).followedByAny("middle-first").subtype(SubEvent.class).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getVolume() > 5.0)).followedBy("middle-second").subtype(SubEvent.class).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("next-one"))).followedByAny("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("end")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> patterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(patterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, nextOne1, endEvent}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent2, nextOne1, endEvent}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent3, nextOne1, endEvent})}));
    }

    @Test
    public void testMultipleTakesVersionCollision() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(41, "a", 3.0);
        Event middleEvent3 = new Event(41, "a", 4.0);
        Event middleEvent4 = new Event(41, "a", 5.0);
        Event middleEvent5 = new Event(41, "a", 6.0);
        Event end = new Event(44, "b", 5.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 5L));
        inputEvents.add(new StreamRecord((Object)middleEvent4, 6L));
        inputEvents.add(new StreamRecord((Object)middleEvent5, 7L));
        inputEvents.add(new StreamRecord((Object)end, 10L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().allowCombinations().followedBy("middle2").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().allowCombinations().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3, middleEvent4, middleEvent5, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3, middleEvent4, middleEvent5, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3, middleEvent4, middleEvent5, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3, middleEvent4, middleEvent5, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3, middleEvent4, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent4, middleEvent5, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3, middleEvent4, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3, middleEvent5, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent3, middleEvent4, middleEvent5, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent3, middleEvent4, middleEvent5, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3, middleEvent4, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3, middleEvent5, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent4, middleEvent5, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent3, middleEvent4, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent4, middleEvent5, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent4, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent5, end}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, end})}));
    }

    @Test
    public void testNFAResultOrdering() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent1 = new Event(41, "a-1", 2.0);
        Event startEvent2 = new Event(41, "a-2", 3.0);
        Event startEvent3 = new Event(41, "a-3", 4.0);
        Event startEvent4 = new Event(41, "a-4", 5.0);
        Event endEvent1 = new Event(41, "b-1", 6.0);
        Event endEvent2 = new Event(41, "b-2", 7.0);
        Event endEvent3 = new Event(41, "b-3", 8.0);
        inputEvents.add(new StreamRecord((Object)startEvent1, 1L));
        inputEvents.add(new StreamRecord((Object)startEvent2, 3L));
        inputEvents.add(new StreamRecord((Object)startEvent3, 4L));
        inputEvents.add(new StreamRecord((Object)startEvent4, 5L));
        inputEvents.add(new StreamRecord((Object)endEvent1, 6L));
        inputEvents.add(new StreamRecord((Object)endEvent2, 7L));
        inputEvents.add(new StreamRecord((Object)endEvent3, 10L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)s -> s.getName().startsWith("a-"))).times(4).allowCombinations().followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)s -> s.getName().startsWith("b-"))).times(3).consecutive();
        NFATestHarness nfaTestHarness = NFATestHarness.forPattern(pattern).build();
        Collection<Map<String, List<Event>>> resultingPatterns = nfaTestHarness.consumeRecords(inputEvents);
        Assert.assertEquals((long)1L, (long)resultingPatterns.size());
        Map<String, List<Event>> match = resultingPatterns.iterator().next();
        Assert.assertArrayEquals((Object[])match.get("start").toArray(), (Object[])Lists.newArrayList((Object[])new Event[]{startEvent1, startEvent2, startEvent3, startEvent4}).toArray());
        Assert.assertArrayEquals((Object[])match.get("middle").toArray(), (Object[])Lists.newArrayList((Object[])new Event[]{endEvent1, endEvent2, endEvent3}).toArray());
    }

    @Test
    public void testNFAResultKeyOrdering() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(41, "a", 2.0);
        Event b1 = new Event(41, "b", 3.0);
        Event aa1 = new Event(41, "aa", 4.0);
        Event bb1 = new Event(41, "bb", 5.0);
        Event ab1 = new Event(41, "ab", 6.0);
        inputEvents.add(new StreamRecord((Object)a1, 1L));
        inputEvents.add(new StreamRecord((Object)b1, 3L));
        inputEvents.add(new StreamRecord((Object)aa1, 4L));
        inputEvents.add(new StreamRecord((Object)bb1, 5L));
        inputEvents.add(new StreamRecord((Object)ab1, 6L));
        Pattern pattern = Pattern.begin((String)"a").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)s -> s.getName().equals("a"))).next("b").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)s -> s.getName().equals("b"))).next("aa").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)s -> s.getName().equals("aa"))).next("bb").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)s -> s.getName().equals("bb"))).next("ab").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)s -> s.getName().equals("ab")));
        NFATestHarness nfaTestHarness = NFATestHarness.forPattern(pattern).build();
        Collection<Map<String, List<Event>>> resultingPatterns = nfaTestHarness.consumeRecords(inputEvents);
        Assert.assertEquals((long)1L, (long)resultingPatterns.size());
        Map<String, List<Event>> match = resultingPatterns.iterator().next();
        ArrayList expectedOrder = Lists.newArrayList((Object[])new String[]{"a", "b", "aa", "bb", "ab"});
        ArrayList<String> resultOrder = new ArrayList<String>();
        for (String key : match.keySet()) {
            resultOrder.add(key);
        }
        Assert.assertEquals((Object)expectedOrder, resultOrder);
    }

    @Test
    public void testSharedBufferClearing() throws Exception {
        Pattern pattern = Pattern.begin((String)"start").followedBy("end");
        Event a = new Event(40, "a", 1.0);
        Event b = new Event(41, "b", 2.0);
        NFA nfa = NFAUtils.compile(pattern, false);
        TestTimerService timerService = new TestTimerService();
        try (SharedBufferAccessor accessor = (SharedBufferAccessor)Mockito.spy((Object)this.sharedBuffer.getAccessor());){
            nfa.process(accessor, nfa.createInitialNFAState(), (Object)a, 1L, (AfterMatchSkipStrategy)AfterMatchSkipStrategy.noSkip(), (TimerService)timerService);
            nfa.process(accessor, nfa.createInitialNFAState(), (Object)b, 2L, (AfterMatchSkipStrategy)AfterMatchSkipStrategy.noSkip(), (TimerService)timerService);
            ((SharedBufferAccessor)Mockito.verify((Object)accessor, (VerificationMode)Mockito.never())).advanceTime(Matchers.anyLong());
            nfa.advanceTime(accessor, nfa.createInitialNFAState(), 2L, (AfterMatchSkipStrategy)AfterMatchSkipStrategy.noSkip());
            ((SharedBufferAccessor)Mockito.verify((Object)accessor, (VerificationMode)Mockito.times((int)1))).advanceTime(2L);
        }
    }

    @Test
    public void testLoopClearingWithinFirstAndLast() throws Exception {
        this.testLoopClearing(WithinType.FIRST_AND_LAST);
    }

    @Test
    public void testLoopClearingWithinPreviousAndCurrent() throws Exception {
        this.testLoopClearing(WithinType.PREVIOUS_AND_CURRENT);
    }

    private void testLoopClearing(WithinType withinType) throws Exception {
        Pattern pattern = Pattern.begin((String)"start", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipPastLastEvent()).times(4).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).within(Time.milliseconds((long)3L), withinType);
        Event a1 = new Event(40, "a", 1.0);
        Event a2 = new Event(40, "a", 1.0);
        NFA nfa = NFAUtils.compile(pattern, false);
        TestTimerService timerService = new TestTimerService();
        NFAState nfaState = nfa.createInitialNFAState();
        try (SharedBufferAccessor accessor = this.sharedBuffer.getAccessor();){
            nfa.process(accessor, nfaState, (Object)a1, 1L, (AfterMatchSkipStrategy)AfterMatchSkipStrategy.noSkip(), (TimerService)timerService);
            nfa.process(accessor, nfaState, (Object)a2, 2L, (AfterMatchSkipStrategy)AfterMatchSkipStrategy.noSkip(), (TimerService)timerService);
            nfa.advanceTime(accessor, nfaState, 4L, (AfterMatchSkipStrategy)AfterMatchSkipStrategy.noSkip());
        }
        Assert.assertThat((Object)this.sharedBuffer.getEventsBufferSize(), (Matcher)CoreMatchers.equalTo((Object)(withinType.equals((Object)WithinType.FIRST_AND_LAST) ? 1 : 2)));
    }

    private static class ConsecutiveData {
        private static final Event startEvent = new Event(40, "c", 1.0);
        private static final Event middleEvent1 = new Event(41, "a", 2.0);
        private static final Event middleEvent2 = new Event(42, "a", 3.0);
        private static final Event middleEvent3 = new Event(43, "a", 4.0);
        private static final Event middleEvent4 = new Event(43, "a", 5.0);
        private static final Event end = new Event(44, "b", 5.0);

        private ConsecutiveData() {
        }
    }
}

