/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.utils;

import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.cep.Event;
import org.apache.flink.cep.EventComparator;
import org.apache.flink.cep.functions.PatternProcessFunction;
import org.apache.flink.cep.nfa.compiler.NFACompiler;
import org.apache.flink.cep.operator.CepOperator;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.util.Collector;
import org.apache.flink.util.OutputTag;

public class CepOperatorTestUtilities {
    public static <T> OneInputStreamOperatorTestHarness<Event, T> getCepTestHarness(CepOperator<Event, Integer, T> cepOperator) throws Exception {
        TestKeySelector keySelector = new TestKeySelector();
        return new KeyedOneInputStreamOperatorTestHarness(cepOperator, (KeySelector)keySelector, (TypeInformation)BasicTypeInfo.INT_TYPE_INFO);
    }

    public static <K> CepOperator<Event, K, Map<String, List<Event>>> getKeyedCepOperator(boolean isProcessingTime, NFACompiler.NFAFactory<Event> nfaFactory) {
        return CepOperatorTestUtilities.getKeyedCepOperator(isProcessingTime, nfaFactory, null);
    }

    public static <K> CepOperator<Event, K, Map<String, List<Event>>> getKeyedCepOperator(boolean isProcessingTime, NFACompiler.NFAFactory<Event> nfaFactory, EventComparator<Event> comparator) {
        return CepOperatorTestUtilities.getKeyedCepOperator(isProcessingTime, nfaFactory, comparator, null);
    }

    public static <K> CepOperator<Event, K, Map<String, List<Event>>> getKeyedCepOperator(boolean isProcessingTime, NFACompiler.NFAFactory<Event> nfaFactory, EventComparator<Event> comparator, OutputTag<Event> outputTag) {
        return new CepOperator(Event.createTypeSerializer(), isProcessingTime, nfaFactory, comparator, null, (PatternProcessFunction)new PatternProcessFunction<Event, Map<String, List<Event>>>(){
            private static final long serialVersionUID = -7143807777582726991L;

            public void processMatch(Map<String, List<Event>> match, PatternProcessFunction.Context ctx, Collector<Map<String, List<Event>>> out) throws Exception {
                out.collect(match);
            }
        }, outputTag);
    }

    private CepOperatorTestUtilities() {
    }

    private static class TestKeySelector
    implements KeySelector<Event, Integer> {
        private static final long serialVersionUID = -4873366487571254798L;

        private TestKeySelector() {
        }

        public Integer getKey(Event value) throws Exception {
            return value.getId();
        }
    }
}

