/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.utils;

import org.apache.flink.cep.Event;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public class EventBuilder {
    private final int id;
    private final double price;
    private final String name;
    private final Long timestamp;

    private EventBuilder(int id, double price, String name, Long timestamp) {
        this.id = id;
        this.price = price;
        this.name = name;
        this.timestamp = timestamp;
    }

    public static EventBuilder event() {
        return new EventBuilder(0, 0.0, "", null);
    }

    public EventBuilder withId(int id) {
        return new EventBuilder(id, this.price, this.name, this.timestamp);
    }

    public EventBuilder withPrice(double price) {
        return new EventBuilder(this.id, price, this.name, this.timestamp);
    }

    public EventBuilder withName(String name) {
        return new EventBuilder(this.id, this.price, name, this.timestamp);
    }

    public EventBuilder withTimestamp(long timestamp) {
        return new EventBuilder(this.id, this.price, this.name, timestamp);
    }

    public StreamRecord<Event> asStreamRecord() {
        if (this.timestamp != null) {
            return new StreamRecord((Object)this.build(), this.timestamp.longValue());
        }
        return new StreamRecord((Object)this.build());
    }

    public Event build() {
        return new Event(this.id, this.name, this.price);
    }
}

