/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.changelog.fs;

import java.time.Duration;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.streaming.api.environment.ExecutionCheckpointingOptions;

@Experimental
public class FsStateChangelogOptions {
    public static final ConfigOption<String> BASE_PATH = ConfigOptions.key((String)"dstl.dfs.base-path").stringType().noDefaultValue().withDescription("Base path to store changelog files.");
    public static final ConfigOption<Boolean> COMPRESSION_ENABLED = ConfigOptions.key((String)"dstl.dfs.compression.enabled").booleanType().defaultValue((Object)false).withDescription("Whether to enable compression when serializing changelog.");
    public static final ConfigOption<MemorySize> PREEMPTIVE_PERSIST_THRESHOLD = ConfigOptions.key((String)"dstl.dfs.preemptive-persist-threshold").memoryType().defaultValue((Object)MemorySize.parse((String)"5Mb")).withDescription("Size threshold for state changes of a single operator beyond which they are persisted pre-emptively without waiting for a checkpoint.  Improves checkpointing time by allowing quasi-continuous uploading of state changes (as opposed to uploading all accumulated changes on checkpoint).");
    public static final ConfigOption<Duration> PERSIST_DELAY = ConfigOptions.key((String)"dstl.dfs.batch.persist-delay").durationType().defaultValue((Object)Duration.ofMillis(10L)).withDescription("Delay before persisting changelog after receiving persist request (on checkpoint). Minimizes the number of files and requests if multiple operators (backends) or sub-tasks are using the same store. Correspondingly increases checkpoint time (async phase).");
    public static final ConfigOption<MemorySize> PERSIST_SIZE_THRESHOLD = ConfigOptions.key((String)"dstl.dfs.batch.persist-size-threshold").memoryType().defaultValue((Object)MemorySize.parse((String)"10Mb")).withDescription("Size threshold for state changes that were requested to be persisted but are waiting for " + PERSIST_DELAY.key() + " (from all operators). . Once reached, accumulated changes are persisted immediately. This is different from " + PREEMPTIVE_PERSIST_THRESHOLD.key() + " as it happens AFTER the checkpoint and potentially for state changes of multiple operators. Must not exceed in-flight data limit (see below)");
    public static final ConfigOption<MemorySize> UPLOAD_BUFFER_SIZE = ConfigOptions.key((String)"dstl.dfs.upload.buffer-size").memoryType().defaultValue((Object)MemorySize.parse((String)"1Mb")).withDescription("Buffer size used when uploading change sets");
    public static final ConfigOption<Integer> NUM_UPLOAD_THREADS = ConfigOptions.key((String)"dstl.dfs.upload.num-threads").intType().defaultValue((Object)5).withDescription("Number of threads to use for upload.");
    public static final ConfigOption<Integer> NUM_DISCARD_THREADS = ConfigOptions.key((String)"dstl.dfs.discard.num-threads").intType().defaultValue((Object)1).withDescription("Number of threads to use to discard changelog (e.g. pre-emptively uploaded unused state).");
    public static final ConfigOption<MemorySize> IN_FLIGHT_DATA_LIMIT = ConfigOptions.key((String)"dstl.dfs.upload.max-in-flight").memoryType().defaultValue((Object)MemorySize.parse((String)"100Mb")).withDescription("Max amount of data allowed to be in-flight. Upon reaching this limit the task will be back-pressured.  I.e., snapshotting will block; normal processing will block if " + PREEMPTIVE_PERSIST_THRESHOLD.key() + " is set and reached. The limit is applied to the total size of in-flight changes if multiple operators/backends are using the same changelog storage. Must be greater than or equal to " + PERSIST_SIZE_THRESHOLD.key());
    public static final ConfigOption<String> RETRY_POLICY = ConfigOptions.key((String)"dstl.dfs.upload.retry-policy").stringType().defaultValue((Object)"fixed").withDescription("Retry policy for the failed uploads (in particular, timed out). Valid values: none, fixed.");
    public static final ConfigOption<Duration> UPLOAD_TIMEOUT = ConfigOptions.key((String)"dstl.dfs.upload.timeout").durationType().defaultValue((Object)Duration.ofSeconds(1L)).withDescription("Time threshold beyond which an upload is considered timed out. If a new attempt is made but this upload succeeds earlier then this upload result will be used. May improve upload times if tail latencies of upload requests are significantly high. Only takes effect if " + RETRY_POLICY.key() + " is fixed. Please note that timeout * max_attempts should be less than " + ExecutionCheckpointingOptions.CHECKPOINTING_TIMEOUT.key());
    public static final ConfigOption<Integer> RETRY_MAX_ATTEMPTS = ConfigOptions.key((String)"dstl.dfs.upload.max-attempts").intType().defaultValue((Object)3).withDescription("Maximum number of attempts (including the initial one) to perform a particular upload. Only takes effect if " + RETRY_POLICY.key() + " is fixed.");
    public static final ConfigOption<Duration> RETRY_DELAY_AFTER_FAILURE = ConfigOptions.key((String)"dstl.dfs.upload.next-attempt-delay").durationType().defaultValue((Object)Duration.ofMillis(500L)).withDescription("Delay before the next attempt (if the failure was not caused by a timeout).");
}

