/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.changelog.fs;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.changelog.fs.ChangelogStorageMetricGroup;
import org.apache.flink.changelog.fs.OutputStreamWithPos;
import org.apache.flink.changelog.fs.StateChangeFormat;
import org.apache.flink.changelog.fs.StateChangeUploadScheduler;
import org.apache.flink.changelog.fs.StateChangeUploader;
import org.apache.flink.changelog.fs.TaskChangelogRegistry;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.SnappyStreamCompressionDecorator;
import org.apache.flink.runtime.state.StreamCompressionDecorator;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.UncompressedStreamCompressionDecorator;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.apache.flink.shaded.guava30.com.google.common.io.Closer;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateChangeFsUploader
implements StateChangeUploader {
    private static final Logger LOG = LoggerFactory.getLogger(StateChangeFsUploader.class);
    private final Path basePath;
    private final FileSystem fileSystem;
    private final StateChangeFormat format;
    private final boolean compression;
    private final int bufferSize;
    private final ChangelogStorageMetricGroup metrics;
    private final Clock clock;
    private final TaskChangelogRegistry changelogRegistry;
    private final BiFunction<Path, Long, StreamStateHandle> handleFactory;

    @VisibleForTesting
    public StateChangeFsUploader(Path basePath, FileSystem fileSystem, boolean compression, int bufferSize, ChangelogStorageMetricGroup metrics, TaskChangelogRegistry changelogRegistry) {
        this(basePath, fileSystem, compression, bufferSize, metrics, changelogRegistry, FileStateHandle::new);
    }

    public StateChangeFsUploader(Path basePath, FileSystem fileSystem, boolean compression, int bufferSize, ChangelogStorageMetricGroup metrics, TaskChangelogRegistry changelogRegistry, BiFunction<Path, Long, StreamStateHandle> handleFactory) {
        this.basePath = basePath;
        this.fileSystem = fileSystem;
        this.format = new StateChangeFormat();
        this.compression = compression;
        this.bufferSize = bufferSize;
        this.metrics = metrics;
        this.clock = SystemClock.getInstance();
        this.changelogRegistry = changelogRegistry;
        this.handleFactory = handleFactory;
    }

    @Override
    public StateChangeUploader.UploadTasksResult upload(Collection<StateChangeUploadScheduler.UploadTask> tasks) throws IOException {
        String fileName = this.generateFileName();
        LOG.debug("upload {} tasks to {}", (Object)tasks.size(), (Object)fileName);
        Path path = new Path(this.basePath, fileName);
        try {
            return this.uploadWithMetrics(path, tasks);
        }
        catch (IOException e) {
            this.metrics.getUploadFailuresCounter().inc();
            try (Closer closer = Closer.create();){
                closer.register(() -> {
                    throw e;
                });
                tasks.forEach(cs -> closer.register(() -> cs.fail(e)));
                closer.register(() -> this.fileSystem.delete(path, true));
            }
            return null;
        }
    }

    private StateChangeUploader.UploadTasksResult uploadWithMetrics(Path path, Collection<StateChangeUploadScheduler.UploadTask> tasks) throws IOException {
        this.metrics.getUploadsCounter().inc();
        long start = this.clock.relativeTimeNanos();
        StateChangeUploader.UploadTasksResult result = this.upload(path, tasks);
        this.metrics.getUploadLatenciesNanos().update(this.clock.relativeTimeNanos() - start);
        this.metrics.getUploadSizes().update(result.getStateSize());
        return result;
    }

    /*
     * Exception decompiling
     */
    private StateChangeUploader.UploadTasksResult upload(Path path, Collection<StateChangeUploadScheduler.UploadTask> tasks) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private OutputStreamWithPos wrap(FSDataOutputStream fsStream) throws IOException {
        StreamCompressionDecorator instance = this.compression ? SnappyStreamCompressionDecorator.INSTANCE : UncompressedStreamCompressionDecorator.INSTANCE;
        FSDataOutputStream compressed = this.compression ? instance.decorateWithCompression((OutputStream)fsStream) : fsStream;
        return new OutputStreamWithPos(new BufferedOutputStream((OutputStream)compressed, this.bufferSize));
    }

    private String generateFileName() {
        return UUID.randomUUID().toString();
    }

    @Override
    public void close() {
    }

    private static /* synthetic */ Stream lambda$upload$4(StateChangeUploadScheduler.UploadTask t) {
        return t.getChangeSets().stream();
    }
}

