/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.changelog.fs;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.changelog.fs.TaskChangelogRegistryImpl;
import org.apache.flink.runtime.state.StreamStateHandle;

@Internal
public interface TaskChangelogRegistry {
    public static final TaskChangelogRegistry NO_OP = new TaskChangelogRegistry(){

        @Override
        public void startTracking(StreamStateHandle handle, Set<UUID> backendIDs) {
        }

        @Override
        public void stopTracking(StreamStateHandle handle) {
        }

        @Override
        public void notUsed(StreamStateHandle handle, UUID backendId) {
        }
    };

    public void startTracking(StreamStateHandle var1, Set<UUID> var2);

    public void stopTracking(StreamStateHandle var1);

    public void notUsed(StreamStateHandle var1, UUID var2);

    public static TaskChangelogRegistry defaultChangelogRegistry(int numAsyncDiscardThreads) {
        return TaskChangelogRegistry.defaultChangelogRegistry(Executors.newFixedThreadPool(numAsyncDiscardThreads));
    }

    @VisibleForTesting
    public static TaskChangelogRegistry defaultChangelogRegistry(Executor executor) {
        return new TaskChangelogRegistryImpl(executor);
    }
}

