/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.OutputStreamBasedPartFileWriter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class OutputStreamBasedPartFileRecoverableMigrationTest {
    private static final int CURRENT_VERSION = 1;
    private static final String IN_PROGRESS_CONTENT = "writing";
    private static final String PENDING_CONTENT = "wrote";
    private static final java.nio.file.Path BASE_PATH = Paths.get("src/test/resources/", new String[0]).resolve("recoverable-serializer-migration");

    static Stream<Integer> previousVersions() {
        return Stream.of(Integer.valueOf(1));
    }

    @Test
    @Disabled
    void prepareDeserializationInProgress() throws IOException {
        String scenario = "in-progress";
        java.nio.file.Path path = this.resolveVersionPath(1L, scenario);
        RecoverableWriter writer = FileSystem.getLocalFileSystem().createRecoverableWriter();
        OutputStreamBasedPartFileWriter.OutputStreamBasedInProgressFileRecoverableSerializer serializer = new OutputStreamBasedPartFileWriter.OutputStreamBasedInProgressFileRecoverableSerializer(writer.getResumeRecoverableSerializer());
        RecoverableFsDataOutputStream outputStream = writer.open(new Path(path.resolve("content").toString()));
        outputStream.write(IN_PROGRESS_CONTENT.getBytes(StandardCharsets.UTF_8));
        RecoverableWriter.ResumeRecoverable resumeRecoverable = outputStream.persist();
        OutputStreamBasedPartFileWriter.OutputStreamBasedInProgressFileRecoverable recoverable = new OutputStreamBasedPartFileWriter.OutputStreamBasedInProgressFileRecoverable(resumeRecoverable);
        byte[] bytes = serializer.serialize((InProgressFileWriter.InProgressFileRecoverable)recoverable);
        Files.write(path.resolve("recoverable"), bytes, new OpenOption[0]);
    }

    @ParameterizedTest(name="Previous Version = {0}")
    @MethodSource(value={"previousVersions"})
    void testSerializationInProgress(int previousVersion) throws IOException {
        String scenario = "in-progress";
        java.nio.file.Path path = this.resolveVersionPath(previousVersion, scenario);
        RecoverableWriter writer = FileSystem.getLocalFileSystem().createRecoverableWriter();
        OutputStreamBasedPartFileWriter.OutputStreamBasedInProgressFileRecoverableSerializer serializer = new OutputStreamBasedPartFileWriter.OutputStreamBasedInProgressFileRecoverableSerializer(writer.getResumeRecoverableSerializer());
        InProgressFileWriter.InProgressFileRecoverable recoverable = serializer.deserialize(previousVersion, Files.readAllBytes(path.resolve("recoverable")));
        Assertions.assertThat((Object)recoverable).isInstanceOf(OutputStreamBasedPartFileWriter.OutputStreamBasedInProgressFileRecoverable.class);
        writer.recover(((OutputStreamBasedPartFileWriter.OutputStreamBasedInProgressFileRecoverable)recoverable).getResumeRecoverable());
    }

    @Test
    @Disabled
    void prepareDeserializationPending() throws IOException {
        String scenario = "pending";
        java.nio.file.Path path = this.resolveVersionPath(1L, scenario);
        RecoverableWriter writer = FileSystem.getLocalFileSystem().createRecoverableWriter();
        OutputStreamBasedPartFileWriter.OutputStreamBasedPendingFileRecoverableSerializer serializer = new OutputStreamBasedPartFileWriter.OutputStreamBasedPendingFileRecoverableSerializer(writer.getCommitRecoverableSerializer());
        RecoverableFsDataOutputStream outputStream = writer.open(new Path(path.resolve("content").toString()));
        outputStream.write(PENDING_CONTENT.getBytes(StandardCharsets.UTF_8));
        RecoverableWriter.CommitRecoverable commitRecoverable = outputStream.closeForCommit().getRecoverable();
        OutputStreamBasedPartFileWriter.OutputStreamBasedPendingFileRecoverable recoverable = new OutputStreamBasedPartFileWriter.OutputStreamBasedPendingFileRecoverable(commitRecoverable);
        byte[] bytes = serializer.serialize((InProgressFileWriter.PendingFileRecoverable)recoverable);
        Files.write(path.resolve("recoverable"), bytes, new OpenOption[0]);
    }

    @ParameterizedTest(name="Previous Version = {0}")
    @MethodSource(value={"previousVersions"})
    void testSerializationPending(int previousVersion) throws IOException {
        String scenario = "pending";
        java.nio.file.Path path = this.resolveVersionPath(previousVersion, scenario);
        RecoverableWriter writer = FileSystem.getLocalFileSystem().createRecoverableWriter();
        OutputStreamBasedPartFileWriter.OutputStreamBasedPendingFileRecoverableSerializer serializer = new OutputStreamBasedPartFileWriter.OutputStreamBasedPendingFileRecoverableSerializer(writer.getCommitRecoverableSerializer());
        InProgressFileWriter.PendingFileRecoverable recoverable = serializer.deserialize(previousVersion, Files.readAllBytes(path.resolve("recoverable")));
        Assertions.assertThat((Object)recoverable).isInstanceOf(OutputStreamBasedPartFileWriter.OutputStreamBasedPendingFileRecoverable.class);
        writer.recoverForCommit(((OutputStreamBasedPartFileWriter.OutputStreamBasedPendingFileRecoverable)recoverable).getCommitRecoverable());
    }

    private java.nio.file.Path resolveVersionPath(long version, String scenario) {
        return BASE_PATH.resolve(scenario + "-v" + version);
    }
}

