/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.Preconditions;

public abstract class AnalyticHelper<T>
extends RichOutputFormat<T> {
    private static final String SEPARATOR = "-";
    private String id = new AbstractID().toString();

    public void configure(Configuration parameters) {
    }

    public void open(int taskNumber, int numTasks) throws IOException {
    }

    public <V, A extends Serializable> void addAccumulator(String name, Accumulator<V, A> accumulator) {
        this.getRuntimeContext().addAccumulator(this.id + SEPARATOR + name, accumulator);
    }

    public <A> A getAccumulator(ExecutionEnvironment env, String accumulatorName) {
        JobExecutionResult result = env.getLastJobExecutionResult();
        Preconditions.checkNotNull((Object)result, (String)"No result found for job, was execute() called before getting the result?");
        return (A)result.getAccumulatorResult(this.id + SEPARATOR + accumulatorName);
    }
}

