/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.asm.dataset;

import java.io.IOException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.SimpleAccumulator;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.graph.AnalyticHelper;
import org.apache.flink.graph.asm.dataset.DataSetAnalyticBase;

public class ChecksumHashCode<T>
extends DataSetAnalyticBase<T, Checksum> {
    private static final String CHECKSUM = "checksum";
    private ChecksumHashCodeHelper<T> checksumHashCodeHelper;

    public ChecksumHashCode<T> run(DataSet<T> input) throws Exception {
        super.run((DataSet)input);
        this.checksumHashCodeHelper = new ChecksumHashCodeHelper();
        input.output(this.checksumHashCodeHelper).name("ChecksumHashCode");
        return this;
    }

    @Override
    public Checksum getResult() {
        return (Checksum)this.checksumHashCodeHelper.getAccumulator(this.env, CHECKSUM);
    }

    public static class Checksum
    implements SimpleAccumulator<Checksum> {
        private long count;
        private long checksum;

        public Checksum(long count, long checksum) {
            this.count = count;
            this.checksum = checksum;
        }

        public long getCount() {
            return this.count;
        }

        public long getChecksum() {
            return this.checksum;
        }

        public String toString() {
            return String.format("ChecksumHashCode 0x%016x, count %d", this.checksum, this.count);
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.count).append(this.checksum).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Checksum rhs = (Checksum)obj;
            return new EqualsBuilder().append(this.count, rhs.count).append(this.checksum, rhs.checksum).isEquals();
        }

        public void add(Checksum value) {
            this.count += value.count;
            this.checksum += value.checksum;
        }

        public Checksum getLocalValue() {
            return this;
        }

        public void resetLocal() {
            this.count = 0L;
            this.checksum = 0L;
        }

        public void merge(Accumulator<Checksum, Checksum> other) {
            this.add((Checksum)((Object)other.getLocalValue()));
        }

        public Accumulator<Checksum, Checksum> clone() {
            return new Checksum(this.count, this.checksum);
        }
    }

    private static class ChecksumHashCodeHelper<U>
    extends AnalyticHelper<U> {
        private long count;
        private long checksum;

        private ChecksumHashCodeHelper() {
        }

        public void writeRecord(U record) throws IOException {
            ++this.count;
            this.checksum += (long)record.hashCode() & 0xFFFFFFFFL;
        }

        public void close() throws IOException {
            this.addAccumulator(ChecksumHashCode.CHECKSUM, new Checksum(this.count, this.checksum));
        }
    }
}

