/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.asm.dataset;

import java.io.IOException;
import org.apache.flink.api.common.accumulators.LongCounter;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.graph.AnalyticHelper;
import org.apache.flink.graph.asm.dataset.DataSetAnalyticBase;

public class Count<T>
extends DataSetAnalyticBase<T, Long> {
    private static final String COUNT = "count";
    private CountHelper<T> countHelper;

    public Count<T> run(DataSet<T> input) throws Exception {
        super.run((DataSet)input);
        this.countHelper = new CountHelper();
        input.output(this.countHelper).name("Count");
        return this;
    }

    @Override
    public Long getResult() {
        return (Long)this.countHelper.getAccumulator(this.env, COUNT);
    }

    private static class CountHelper<U>
    extends AnalyticHelper<U> {
        private long count;

        private CountHelper() {
        }

        public void writeRecord(U record) throws IOException {
            ++this.count;
        }

        public void close() throws IOException {
            this.addAccumulator(Count.COUNT, new LongCounter(this.count));
        }
    }
}

