/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.asm.translate;

import org.apache.flink.api.java.DataSet;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.asm.translate.Translate;
import org.apache.flink.graph.asm.translate.TranslateFunction;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingBase;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingGraph;
import org.apache.flink.util.Preconditions;

public class TranslateEdgeValues<K, VV, OLD, NEW>
extends GraphAlgorithmWrappingGraph<K, VV, OLD, K, VV, NEW> {
    private TranslateFunction<OLD, NEW> translator;

    public TranslateEdgeValues(TranslateFunction<OLD, NEW> translator) {
        Preconditions.checkNotNull(translator);
        this.translator = translator;
    }

    @Override
    protected boolean canMergeConfigurationWith(GraphAlgorithmWrappingBase other) {
        if (!super.canMergeConfigurationWith(other)) {
            return false;
        }
        TranslateEdgeValues rhs = (TranslateEdgeValues)other;
        return this.translator == rhs.translator;
    }

    @Override
    public Graph<K, VV, NEW> runInternal(Graph<K, VV, OLD> input) throws Exception {
        DataSet<Edge<K, NEW>> translatedEdges = Translate.translateEdgeValues(input.getEdges(), this.translator, this.parallelism);
        return Graph.fromDataSet(input.getVertices(), translatedEdges, input.getContext());
    }
}

