/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.generator;

import java.util.List;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.operators.PartitionOperator;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.generator.GraphGeneratorBase;
import org.apache.flink.graph.generator.GraphGeneratorUtils;
import org.apache.flink.graph.generator.random.BlockInfo;
import org.apache.flink.graph.generator.random.RandomGenerableFactory;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

public class RMatGraph<T extends RandomGenerator>
extends GraphGeneratorBase<LongValue, NullValue, NullValue> {
    public static final int MINIMUM_VERTEX_COUNT = 1;
    public static final int MINIMUM_EDGE_COUNT = 1;
    public static final float DEFAULT_A = 0.57f;
    public static final float DEFAULT_B = 0.19f;
    public static final float DEFAULT_C = 0.19f;
    public static final float DEFAULT_NOISE = 0.1f;
    private ExecutionEnvironment env;
    private final RandomGenerableFactory<T> randomGenerableFactory;
    private final long vertexCount;
    private final long edgeCount;
    private float a = 0.57f;
    private float b = 0.19f;
    private float c = 0.19f;
    private boolean noiseEnabled = false;
    private float noise = 0.1f;

    public RMatGraph(ExecutionEnvironment env, RandomGenerableFactory<T> randomGeneratorFactory, long vertexCount, long edgeCount) {
        Preconditions.checkArgument((vertexCount >= 1L ? 1 : 0) != 0, (Object)"Vertex count must be at least 1");
        Preconditions.checkArgument((edgeCount >= 1L ? 1 : 0) != 0, (Object)"Edge count must be at least 1");
        this.env = env;
        this.randomGenerableFactory = randomGeneratorFactory;
        this.vertexCount = vertexCount;
        this.edgeCount = edgeCount;
    }

    public RMatGraph<T> setConstants(float a, float b, float c) {
        Preconditions.checkArgument((a >= 0.0f && b >= 0.0f && c >= 0.0f && a + b + c <= 1.0f ? 1 : 0) != 0, (Object)"RMat parameters A, B, and C must be non-negative and sum to less than or equal to one");
        this.a = a;
        this.b = b;
        this.c = c;
        return this;
    }

    public RMatGraph<T> setNoise(boolean noiseEnabled, float noise) {
        Preconditions.checkArgument((noise >= 0.0f && noise <= 2.0f ? 1 : 0) != 0, (Object)"RMat parameter noise must be non-negative and less than or equal to 2.0");
        this.noiseEnabled = noiseEnabled;
        this.noise = noise;
        return this;
    }

    @Override
    public Graph<LongValue, NullValue, NullValue> generate() {
        int scale = 64 - Long.numberOfLeadingZeros(this.vertexCount - 1L);
        int cyclesPerEdge = this.noiseEnabled ? 5 * scale : scale;
        List<BlockInfo<T>> generatorBlocks = this.randomGenerableFactory.getRandomGenerables(this.edgeCount, cyclesPerEdge);
        Operator edges = ((FlatMapOperator)((PartitionOperator)((PartitionOperator)((DataSource)this.env.fromCollection(generatorBlocks).name("Random generators")).rebalance().setParallelism(this.parallelism)).name("Rebalance")).flatMap(new GenerateEdges(this.vertexCount, scale, this.a, this.b, this.c, this.noiseEnabled, this.noise)).setParallelism(this.parallelism)).name("RMat graph edges");
        DataSet vertices = GraphGeneratorUtils.vertexSet(edges, this.parallelism);
        return Graph.fromDataSet(vertices, edges, this.env);
    }

    private static class GenerateEdges<T extends RandomGenerator>
    implements FlatMapFunction<BlockInfo<T>, Edge<LongValue, NullValue>> {
        private final long vertexCount;
        private final int scale;
        private final float a;
        private final float b;
        private final float c;
        private final float d;
        private final boolean noiseEnabled;
        private final float noise;
        private LongValue source = new LongValue();
        private LongValue target = new LongValue();
        private Edge<LongValue, NullValue> sourceToTarget = new Edge<LongValue, NullValue>(this.source, this.target, NullValue.getInstance());
        private Edge<LongValue, NullValue> targetToSource = new Edge<LongValue, NullValue>(this.target, this.source, NullValue.getInstance());

        public GenerateEdges(long vertexCount, int scale, float a, float b, float c, boolean noiseEnabled, float noise) {
            this.vertexCount = vertexCount;
            this.scale = scale;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = 1.0f - a - b - c;
            this.noiseEnabled = noiseEnabled;
            this.noise = noise;
        }

        public void flatMap(BlockInfo<T> blockInfo, Collector<Edge<LongValue, NullValue>> out) throws Exception {
            T rng = blockInfo.getRandomGenerable().generator();
            long edgesToGenerate = blockInfo.getElementCount();
            while (edgesToGenerate > 0L) {
                long x = 0L;
                long y = 0L;
                float a = this.a;
                float b = this.b;
                float c = this.c;
                float d = this.d;
                for (int bit = 0; bit < this.scale; ++bit) {
                    x <<= 1;
                    y <<= 1;
                    float random = rng.nextFloat();
                    if (!(random <= a)) {
                        if (random <= a + b) {
                            ++y;
                        } else if (random <= a + b + c) {
                            ++x;
                        } else {
                            ++x;
                            ++y;
                        }
                    }
                    if (!this.noiseEnabled) continue;
                    a = (float)((double)a * (1.0 - (double)(this.noise / 2.0f) + (double)(rng.nextFloat() * this.noise)));
                    b = (float)((double)b * (1.0 - (double)(this.noise / 2.0f) + (double)(rng.nextFloat() * this.noise)));
                    c = (float)((double)c * (1.0 - (double)(this.noise / 2.0f) + (double)(rng.nextFloat() * this.noise)));
                    d = (float)((double)d * (1.0 - (double)(this.noise / 2.0f) + (double)(rng.nextFloat() * this.noise)));
                    float norm = 1.0f / (a + b + c + d);
                    d = 1.0f - (a *= norm) - (b *= norm) - (c *= norm);
                }
                if (x >= this.vertexCount || y >= this.vertexCount) continue;
                this.source.setValue(x);
                this.target.setValue(y);
                out.collect(this.sourceToTarget);
                --edgesToGenerate;
            }
        }
    }
}

