/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.generator;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.generator.GraphGeneratorBase;
import org.apache.flink.graph.generator.GraphGeneratorUtils;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;
import org.apache.flink.util.Collector;
import org.apache.flink.util.LongValueSequenceIterator;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SplittableIterator;

public class StarGraph
extends GraphGeneratorBase<LongValue, NullValue, NullValue> {
    public static final int MINIMUM_VERTEX_COUNT = 2;
    private final ExecutionEnvironment env;
    private final long vertexCount;

    public StarGraph(ExecutionEnvironment env, long vertexCount) {
        Preconditions.checkArgument((vertexCount >= 2L ? 1 : 0) != 0, (Object)"Vertex count must be at least 2");
        this.env = env;
        this.vertexCount = vertexCount;
    }

    @Override
    public Graph<LongValue, NullValue, NullValue> generate() {
        Preconditions.checkState((this.vertexCount >= 2L ? 1 : 0) != 0);
        DataSet<Vertex<LongValue, NullValue>> vertices = GraphGeneratorUtils.vertexSequence(this.env, this.parallelism, this.vertexCount);
        LongValueSequenceIterator iterator = new LongValueSequenceIterator(1L, this.vertexCount - 1L);
        Operator edges = ((FlatMapOperator)((DataSource)((DataSource)this.env.fromParallelCollection((SplittableIterator)iterator, LongValue.class).setParallelism(this.parallelism)).name("Edge iterators")).flatMap((FlatMapFunction)new LinkVertexToCenter()).setParallelism(this.parallelism)).name("Star graph edges");
        return Graph.fromDataSet(vertices, edges, this.env);
    }

    @FunctionAnnotation.ForwardedFields(value={"*->f0"})
    private static class LinkVertexToCenter
    implements FlatMapFunction<LongValue, Edge<LongValue, NullValue>> {
        private LongValue center = new LongValue(0L);
        private Edge<LongValue, NullValue> centerToLeaf = new Edge<Object, NullValue>(this.center, null, NullValue.getInstance());
        private Edge<LongValue, NullValue> leafToCenter = new Edge<LongValue, NullValue>(null, this.center, NullValue.getInstance());

        private LinkVertexToCenter() {
        }

        public void flatMap(LongValue leaf, Collector<Edge<LongValue, NullValue>> out) throws Exception {
            this.centerToLeaf.f1 = leaf;
            out.collect(this.centerToLeaf);
            this.leafToCenter.f0 = leaf;
            out.collect(this.leafToCenter);
        }
    }
}

